/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.energy.systems;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.energy.IEnergySystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/TeslaSystem;", "Lnet/ndrei/teslacorelib/energy/IEnergySystem;", "()V", "MODID", "", "ModId", "getModId", "()Ljava/lang/String;", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "wrapCapability", "T", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)Ljava/lang/Object;", "wrapItemStack", "stack", "Lnet/minecraft/item/ItemStack;", "wrapTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "ReverseWrapper", "WraperConsumer", "WrapperHolder", "WrapperProducer", "tesla-core-lib"})
public final class TeslaSystem
implements IEnergySystem {
    @NotNull
    public static final String MODID = "tesla";
    public static final TeslaSystem INSTANCE;

    @Override
    @NotNull
    public String getModId() {
        return MODID;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return this.isAvailable() && (Intrinsics.areEqual(capability, (Object)TeslaCapabilities.CAPABILITY_CONSUMER) || Intrinsics.areEqual(capability, (Object)TeslaCapabilities.CAPABILITY_HOLDER) || Intrinsics.areEqual(capability, (Object)TeslaCapabilities.CAPABILITY_PRODUCER));
    }

    @Override
    @Nullable
    public <T> T wrapCapability(@NotNull Capability<T> capability, @NotNull IGenericEnergyStorage energy) {
        Object object;
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
        if (!this.isAvailable()) {
            return null;
        }
        Capability<T> capability2 = capability;
        if (Intrinsics.areEqual(capability2, (Object)TeslaCapabilities.CAPABILITY_HOLDER)) {
            WrapperHolder wrapperHolder = new WrapperHolder(energy);
            if (!(wrapperHolder instanceof Object)) {
                wrapperHolder = null;
            }
            object = wrapperHolder;
        } else if (Intrinsics.areEqual(capability2, (Object)TeslaCapabilities.CAPABILITY_PRODUCER)) {
            WrapperProducer wrapperProducer = new WrapperProducer(energy);
            if (!(wrapperProducer instanceof Object)) {
                wrapperProducer = null;
            }
            object = wrapperProducer;
        } else if (Intrinsics.areEqual(capability2, (Object)TeslaCapabilities.CAPABILITY_CONSUMER)) {
            WraperConsumer wraperConsumer = new WraperConsumer(energy);
            if (!(wraperConsumer instanceof Object)) {
                wraperConsumer = null;
            }
            object = wraperConsumer;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapTileEntity(@NotNull TileEntity te, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (this.isAvailable() && (te.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side) || te.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side) || te.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side))) {
            return new ReverseWrapper((ICapabilityProvider)te, side);
        }
        return null;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.isAvailable() && !stack.func_190926_b() && (stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, null) || stack.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null) || stack.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, null))) {
            return new ReverseWrapper((ICapabilityProvider)stack, null);
        }
        return null;
    }

    private TeslaSystem() {
    }

    static {
        TeslaSystem teslaSystem;
        INSTANCE = teslaSystem = new TeslaSystem();
    }

    @Override
    public boolean isAvailable() {
        return IEnergySystem.DefaultImpls.isAvailable(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/TeslaSystem$WraperConsumer;", "Lnet/darkhax/tesla/api/ITeslaConsumer;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "givePower", "", "power", "simulated", "", "tesla-core-lib"})
    public static final class WraperConsumer
    implements ITeslaConsumer {
        @NotNull
        private final IGenericEnergyStorage energy;

        public long givePower(long power, boolean simulated) {
            return this.energy.givePower(power, simulated);
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public WraperConsumer(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/TeslaSystem$WrapperProducer;", "Lnet/darkhax/tesla/api/ITeslaProducer;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "takePower", "", "power", "simulated", "", "tesla-core-lib"})
    public static final class WrapperProducer
    implements ITeslaProducer {
        @NotNull
        private final IGenericEnergyStorage energy;

        public long takePower(long power, boolean simulated) {
            return this.energy.takePower(power, simulated);
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public WrapperProducer(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/TeslaSystem$WrapperHolder;", "Lnet/darkhax/tesla/api/ITeslaHolder;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "getCapacity", "", "getStoredPower", "tesla-core-lib"})
    public static final class WrapperHolder
    implements ITeslaHolder {
        @NotNull
        private final IGenericEnergyStorage energy;

        public long getCapacity() {
            return this.energy.getCapacity();
        }

        public long getStoredPower() {
            return this.energy.getStored();
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public WrapperHolder(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/TeslaSystem$ReverseWrapper;", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "provider", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "side", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/ICapabilityProvider;Lnet/minecraft/util/EnumFacing;)V", "canGive", "", "getCanGive", "()Z", "canTake", "getCanTake", "capacity", "", "getCapacity", "()J", "consumer", "Lnet/darkhax/tesla/api/ITeslaConsumer;", "holder", "Lnet/darkhax/tesla/api/ITeslaHolder;", "producer", "Lnet/darkhax/tesla/api/ITeslaProducer;", "stored", "getStored", "givePower", "power", "simulated", "takePower", "tesla-core-lib"})
    public static final class ReverseWrapper
    implements IGenericEnergyStorage {
        private final ITeslaHolder holder;
        private final ITeslaConsumer consumer;
        private final ITeslaProducer producer;

        @Override
        public long getCapacity() {
            ITeslaHolder iTeslaHolder = this.holder;
            return iTeslaHolder != null ? iTeslaHolder.getCapacity() : 0L;
        }

        @Override
        public long getStored() {
            ITeslaHolder iTeslaHolder = this.holder;
            return iTeslaHolder != null ? iTeslaHolder.getStoredPower() : 0L;
        }

        @Override
        public boolean getCanGive() {
            return this.consumer != null;
        }

        @Override
        public long givePower(long power, boolean simulated) {
            ITeslaConsumer iTeslaConsumer = this.consumer;
            return iTeslaConsumer != null ? iTeslaConsumer.givePower(power, simulated) : 0L;
        }

        @Override
        public boolean getCanTake() {
            return this.producer != null;
        }

        @Override
        public long takePower(long power, boolean simulated) {
            ITeslaProducer iTeslaProducer = this.producer;
            return iTeslaProducer != null ? iTeslaProducer.takePower(power, simulated) : 0L;
        }

        public ReverseWrapper(@NotNull ICapabilityProvider provider, @Nullable EnumFacing side) {
            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
            this.holder = provider.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side) ? (ITeslaHolder)provider.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side) : null;
            this.consumer = provider.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side) ? (ITeslaConsumer)provider.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side) : null;
            this.producer = provider.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side) ? (ITeslaProducer)provider.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side) : null;
        }

        @Override
        public boolean tryGive() {
            return IGenericEnergyStorage.DefaultImpls.tryGive(this);
        }

        @Override
        public boolean tryTake() {
            return IGenericEnergyStorage.DefaultImpls.tryTake(this);
        }
    }
}

