/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.core.network.BasePacket;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ServerChunkLoadingCapability
extends ChunkLoadingCapability {
    private ForgeChunkManager.Ticket ticket;

    public ServerChunkLoadingCapability(World level) {
        super(level);
    }

    public void addChunkLoader(ChunkLoaderBlockEntity entity) {
        BlockPos pos = entity.func_174877_v();
        UUID owner = entity.getOwner();
        if (!this.chunkLoadersPerPlayer.containsKey(owner) || !((Set)this.chunkLoadersPerPlayer.get(owner)).contains(pos)) {
            ChunkPos chunkPos = new ChunkPos(pos);
            this.chunkLoadersPerChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.chunkLoadersPerChunk.get(chunkPos)).add(pos);
            this.chunkLoadersPerPlayer.putIfAbsent(owner, new HashSet());
            ((Set)this.chunkLoadersPerPlayer.get(owner)).add(pos);
            this.chunkLoaderCacheMap.put(pos, new ChunkLoaderCache(pos, entity.getChunkLoaderType(), owner));
            int centerChunkX = entity.func_174877_v().func_177958_n() >> 4;
            int centerChunkZ = entity.func_174877_v().func_177952_p() >> 4;
            int range = entity.getChunkLoaderType().getRange();
            this.availableChunksPerPlayer.putIfAbsent(owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    ((Set)this.availableChunksPerPlayer.get(owner)).add(new ChunkPos(centerChunkX + x, centerChunkZ + z));
                }
            }
            this.sendToAllPlayers(new PackedChunkLoaderAdded(pos, owner, entity.getChunkLoaderType()));
        }
    }

    public void removeChunkLoader(ChunkLoaderBlockEntity entity) {
        BlockPos pos = entity.func_174877_v();
        ChunkPos chunkPos = new ChunkPos(pos);
        Set chunkLoadersPerChunk = (Set)this.chunkLoadersPerChunk.get(chunkPos);
        if (chunkLoadersPerChunk != null && chunkLoadersPerChunk.contains(pos)) {
            chunkLoadersPerChunk.remove(pos);
            if (chunkLoadersPerChunk.isEmpty()) {
                this.chunkLoadersPerChunk.remove(chunkPos);
            }
            UUID owner = entity.getOwner();
            Set chunkLoadersPerPlayer = (Set)this.chunkLoadersPerPlayer.get(owner);
            chunkLoadersPerPlayer.remove(pos);
            if (chunkLoadersPerPlayer.isEmpty()) {
                this.chunkLoadersPerPlayer.remove(owner);
            }
            this.chunkLoaderCacheMap.remove(pos);
            Set loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(owner);
            Set availableChunksPerPlayer = (Set)this.availableChunksPerPlayer.get(owner);
            int radius = entity.getChunkLoaderType().getRange();
            for (int x = -radius + 1; x < radius; ++x) {
                block1: for (int z = -radius + 1; z < radius; ++z) {
                    ChunkPos otherChunk = new ChunkPos(chunkPos.field_77276_a + x, chunkPos.field_77275_b + z);
                    if (this.chunkLoadersPerPlayer.containsKey(owner)) {
                        for (BlockPos chunkLoaderPos : (Set)this.chunkLoadersPerPlayer.get(owner)) {
                            int chunkLoaderChunkX = chunkLoaderPos.func_177958_n() >> 4;
                            int chunkLoaderChunkZ = chunkLoaderPos.func_177952_p() >> 4;
                            ChunkLoaderType type = ((ChunkLoaderCache)this.chunkLoaderCacheMap.get((Object)chunkLoaderPos)).chunkLoaderType;
                            if (Math.abs(chunkLoaderChunkX - otherChunk.field_77276_a) >= type.getRange() || Math.abs(chunkLoaderChunkZ - otherChunk.field_77275_b) >= type.getRange()) continue;
                            continue block1;
                        }
                    }
                    if (loadedChunksPerPlayer != null && loadedChunksPerPlayer.contains(otherChunk)) {
                        this.stopLoadingChunk(owner, otherChunk);
                    }
                    availableChunksPerPlayer.remove(otherChunk);
                }
            }
            if (availableChunksPerPlayer.isEmpty()) {
                this.availableChunksPerPlayer.remove(owner);
            }
            this.sendToAllPlayers(new PackedChunkLoaderRemoved(pos, owner, entity.getChunkLoaderType()));
        }
    }

    public void startLoadingChunk(UUID player, ChunkPos chunkPos) {
        if (!this.canPlayerLoadChunk(player, chunkPos)) {
            return;
        }
        boolean active = PlayerActivityTracker.isPlayerActive(player);
        if (active) {
            this.activePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.activePlayersPerLoadedChunk.get(chunkPos)).add(player);
        } else {
            this.inactivePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)).add(player);
        }
        this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
        ((Set)this.loadedChunksPerPlayer.get(player)).add(chunkPos);
        this.loadChunk(chunkPos);
        this.sendToAllPlayers(new PackedStartLoadingChunk(player, chunkPos, active));
    }

    public void stopLoadingChunk(UUID player, ChunkPos chunkPos) {
        Set loadedChunksPerPlayer;
        Set players;
        Set inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos);
        if (inactivePlayer != null) {
            inactivePlayer.remove(player);
            if (inactivePlayer.isEmpty()) {
                this.inactivePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
            players.remove(player);
            if (players.isEmpty()) {
                this.activePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((inactivePlayer == null || inactivePlayer.isEmpty()) && (players == null || players.isEmpty())) {
            this.unloadChunk(chunkPos);
        }
        if ((loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(player)) != null) {
            loadedChunksPerPlayer.remove(chunkPos);
            if (loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(player);
            }
        }
        this.sendToAllPlayers(new PackedStopLoadingChunk(player, chunkPos));
    }

    public boolean togglePlayerActivity(UUID player, boolean active) {
        Set chunks = (Set)this.loadedChunksPerPlayer.get(player);
        if (chunks != null) {
            if (active) {
                for (ChunkPos chunk : chunks) {
                    Set activePlayers;
                    Set inactivePlayers = (Set)this.inactivePlayersPerLoadedChunk.get(chunk);
                    if (inactivePlayers != null) {
                        inactivePlayers.remove(player);
                        if (inactivePlayers.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    if ((activePlayers = this.activePlayersPerLoadedChunk.computeIfAbsent(chunk, c -> new HashSet())).isEmpty()) {
                        this.loadChunk(chunk);
                    }
                    activePlayers.add(player);
                }
            } else {
                for (ChunkPos chunk : chunks) {
                    Set activePlayers = (Set)this.activePlayersPerLoadedChunk.get(chunk);
                    if (activePlayers != null) {
                        activePlayers.remove(player);
                        if (activePlayers.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunk);
                            this.unloadChunk(chunk);
                        }
                    }
                    this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            }
            this.sendToAllPlayers(new PackedTogglePlayerActivity(player, active));
            return true;
        }
        return false;
    }

    public Set<ChunkPos> getChunksToBeTicked() {
        return this.activePlayersPerLoadedChunk.keySet();
    }

    private void loadChunk(ChunkPos pos) {
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)ChunkLoaders.instance, (World)this.level, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
    }

    private void unloadChunk(ChunkPos pos) {
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)pos);
    }

    public void onLoadLevel(List<ForgeChunkManager.Ticket> tickets) {
        tickets.forEach(ForgeChunkManager::releaseTicket);
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)ChunkLoaders.instance, (World)this.level, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        for (ChunkPos pos : this.activePlayersPerLoadedChunk.keySet()) {
            this.loadChunk(pos);
        }
    }

    private void sendToAllPlayers(BasePacket packet) {
        ChunkLoaders.CHANNEL.sendToDimension(this.level, packet);
    }

    public NBTTagCompound writeClientInfo() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList chunkLoaderCachesTag = new NBTTagList();
        for (ChunkLoaderCache cache : this.chunkLoaderCacheMap.values()) {
            chunkLoaderCachesTag.func_74742_a((NBTBase)cache.write());
        }
        compound.func_74782_a("chunkLoaderCaches", (NBTBase)chunkLoaderCachesTag);
        NBTTagList loadedChunksPerActivePlayerTag = new NBTTagList();
        NBTTagList loadedChunksPerInactivePlayerTag = new NBTTagList();
        for (Map.Entry entry : this.loadedChunksPerPlayer.entrySet()) {
            NBTTagCompound playerTag = new NBTTagCompound();
            playerTag.func_186854_a("player", (UUID)entry.getKey());
            NBTTagList chunksTag = new NBTTagList();
            ((Set)entry.getValue()).stream().map(pos -> {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("chunkX", pos.field_77276_a);
                tag.func_74768_a("chunkZ", pos.field_77275_b);
                return tag;
            }).forEach(arg_0 -> ((NBTTagList)chunksTag).func_74742_a(arg_0));
            playerTag.func_74782_a("chunks", (NBTBase)chunksTag);
            if (PlayerActivityTracker.isPlayerActive((UUID)entry.getKey())) {
                loadedChunksPerActivePlayerTag.func_74742_a((NBTBase)playerTag);
                continue;
            }
            loadedChunksPerInactivePlayerTag.func_74742_a((NBTBase)playerTag);
        }
        compound.func_74782_a("loadedChunksPerActivePlayer", (NBTBase)loadedChunksPerActivePlayerTag);
        compound.func_74782_a("loadedChunksPerInactivePlayer", (NBTBase)loadedChunksPerInactivePlayerTag);
        return compound;
    }
}

