/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.chunkloaders.LegacyChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ClientChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersBlockStateGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLanguageGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLootTableGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersModelGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersRecipeGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersTagGenerator;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.chunkloaders.packet.PacketFullCapabilityData;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="chunkloaders", name="Chunk Loaders", version="1.2.9", dependencies="required-after:supermartijn642corelib@[1.1.17,1.2.0);required-after:supermartijn642configlib@[1.1.6,)")
public class ChunkLoaders {
    @CapabilityInject(value=ChunkLoadingCapability.class)
    public static Capability<ChunkLoadingCapability> CHUNK_LOADING_CAPABILITY;
    public static final Logger LOGGER;
    public static final PacketChannel CHANNEL;
    public static final CreativeItemGroup GROUP;
    @Mod.Instance
    public static ChunkLoaders instance;

    public ChunkLoaders() {
        CHANNEL.registerMessage(PackedChunkLoaderAdded.class, PackedChunkLoaderAdded::new, true);
        CHANNEL.registerMessage(PackedChunkLoaderRemoved.class, PackedChunkLoaderRemoved::new, true);
        CHANNEL.registerMessage(PackedStartLoadingChunk.class, PackedStartLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedStopLoadingChunk.class, PackedStopLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedTogglePlayerActivity.class, PackedTogglePlayerActivity::new, true);
        CHANNEL.registerMessage(PacketFullCapabilityData.class, PacketFullCapabilityData::new, true);
        CHANNEL.registerMessage(PacketToggleChunk.class, PacketToggleChunk::new, true);
        ChunkLoaders.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ChunkLoadersClient.register();
        }
        ChunkLoaders.registerGenerators();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ChunkLoadersClient.setup();
        }
        LegacyChunkLoadingCapability.register();
        CapabilityManager.INSTANCE.register(ChunkLoadingCapability.class, (Capability.IStorage)new Capability.IStorage<ChunkLoadingCapability>(){

            public NBTBase writeNBT(Capability<ChunkLoadingCapability> capability, ChunkLoadingCapability instance, EnumFacing side) {
                return instance.write();
            }

            public void readNBT(Capability<ChunkLoadingCapability> capability, ChunkLoadingCapability instance, EnumFacing side, NBTBase nbt) {
                instance.read((NBTTagCompound)nbt);
            }
        }, () -> new ClientChunkLoadingCapability(null));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (tickets, level) -> {
            ((ChunkLoadingCapability)level.getCapability(CHUNK_LOADING_CAPABILITY, null)).castServer().onLoadLevel(tickets);
            ((LegacyChunkLoadingCapability.ChunkTracker)level.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY, null)).onLoadLevel(tickets);
        });
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"chunkloaders");
        handler.addGenerator(ChunkLoadersModelGenerator::new);
        handler.addGenerator(ChunkLoadersBlockStateGenerator::new);
        handler.addGenerator(ChunkLoadersLanguageGenerator::new);
        handler.addGenerator(ChunkLoadersLootTableGenerator::new);
        handler.addGenerator(ChunkLoadersRecipeGenerator::new);
        handler.addGenerator(ChunkLoadersTagGenerator::new);
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerAboutToStartEvent e) {
        PlayerActivityTracker.onServerStarting(e);
    }

    static {
        LOGGER = LogManager.getLogger((String)"chunkloaders");
        CHANNEL = PacketChannel.create((String)"chunkloaders");
        GROUP = CreativeItemGroup.create((String)"chunkloaders", ChunkLoaderType.ADVANCED::getItem);
    }

    @Mod.EventBusSubscriber
    public static class ModBusEvents {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
            World level = (World)e.getObject();
            final ChunkLoadingCapability tracker = level.field_72995_K ? new ClientChunkLoadingCapability(level) : new ServerChunkLoadingCapability(level);
            e.addCapability(new ResourceLocation("chunkloaders", "chunk_loading_capability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){

                @Nonnull
                public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
                    return (T)(cap == CHUNK_LOADING_CAPABILITY ? CHUNK_LOADING_CAPABILITY.cast((Object)tracker) : null);
                }

                public boolean hasCapability(@Nonnull Capability<?> cap, @Nullable EnumFacing facing) {
                    return cap == CHUNK_LOADING_CAPABILITY;
                }

                public NBTBase serializeNBT() {
                    return CHUNK_LOADING_CAPABILITY.writeNBT((Object)tracker, null);
                }

                public void deserializeNBT(NBTBase nbt) {
                    CHUNK_LOADING_CAPABILITY.readNBT((Object)tracker, null, nbt);
                }
            });
        }
    }
}

