/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.LegacyChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.block.BaseBlockEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class ChunkLoaderBlockEntity
extends BaseBlockEntity {
    private final ChunkLoaderType type;
    public final int animationOffset = new Random().nextInt(20000);
    private UUID owner;

    public ChunkLoaderBlockEntity(ChunkLoaderType type) {
        super(type.getBlockEntityType());
        this.type = type;
    }

    public ChunkLoaderType getChunkLoaderType() {
        return this.type;
    }

    void setOwner(UUID owner) {
        if (!this.field_145850_b.field_72995_K && owner != null) {
            this.owner = owner;
            this.dataChanged();
            ChunkLoadingCapability.get(this.field_145850_b).castServer().addChunkLoader(this);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K && this.owner != null) {
            ChunkLoadingCapability.get(this.field_145850_b).castServer().addChunkLoader(this);
        }
    }

    protected NBTTagCompound writeData() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.owner != null) {
            compound.func_186854_a("owner", this.owner);
        }
        return compound;
    }

    protected void readData(NBTTagCompound compound) {
        this.owner = compound.func_150297_b("ownerLeast", 4) ? compound.func_186857_a("owner") : null;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_73046_m() != null) {
            IBlockState state = this.getBlockState();
            this.field_145850_b.func_73046_m().func_152344_a(() -> {
                Chunk chunk = this.field_145850_b.func_72863_F().func_186026_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177956_o() >> 4);
                if (chunk != null && chunk.func_177435_g(this.field_174879_c).func_177230_c() != state.func_177230_c() && !(chunk.func_177424_a(this.field_174879_c, Chunk.EnumCreateEntityType.CHECK) instanceof ChunkLoaderBlockEntity)) {
                    if (this.hasOwner()) {
                        ChunkLoadingCapability.get(this.field_145850_b).castServer().removeChunkLoader(this);
                    } else {
                        LegacyChunkLoadingCapability.ChunkTracker cap = (LegacyChunkLoadingCapability.ChunkTracker)this.field_145850_b.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY, null);
                        if (cap != null) {
                            cap.remove(this.field_174879_c);
                        }
                    }
                }
            });
        }
    }
}

