/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.chunkloaders.LegacyChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChunkLoaderBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final BlockShape SINGLE_SHAPE = BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final BlockShape BASIC_SHAPE = BlockShape.createBlockShape((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BlockShape ADVANCED_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final BlockShape ULTIMATE_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private final ChunkLoaderType type;

    public ChunkLoaderBlock(ChunkLoaderType type) {
        super(false, BlockProperties.create((Material)Material.field_151573_f, (MapColor)MapColor.field_151670_w).requiresCorrectTool().destroyTime(1.5f).explosionResistance(6.0f));
        this.type = type;
    }

    protected BaseBlock.InteractionFeedback interact(IBlockState state, World level, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing hitSide, Vec3d hitLocation) {
        TileEntity entity = level.func_175625_s(pos);
        if (entity instanceof ChunkLoaderBlockEntity) {
            if (((ChunkLoaderBlockEntity)entity).hasOwner()) {
                if (level.field_72995_K) {
                    ChunkLoadersClient.openChunkLoaderScreen((ChunkLoaderBlockEntity)entity);
                }
            } else if (player.func_70093_af()) {
                if (level.field_72995_K) {
                    player.func_146105_b(TextComponents.translation((String)"chunkloaders.legacy_success").color(TextFormatting.WHITE).get(), true);
                } else {
                    ((ChunkLoaderBlockEntity)entity).setOwner(player.func_110124_au());
                    LegacyChunkLoadingCapability.ChunkTracker cap = (LegacyChunkLoadingCapability.ChunkTracker)level.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY, null);
                    if (cap != null) {
                        cap.remove(pos);
                    }
                }
            } else if (level.field_72995_K) {
                player.func_146105_b(TextComponents.translation((String)"chunkloaders.legacy_message").color(TextFormatting.RED).get(), true);
            }
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.type.getShape().simplify();
    }

    public TileEntity createNewBlockEntity() {
        return this.type.createBlockEntity();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof ChunkLoaderBlockEntity && placer instanceof EntityPlayer) {
            ((ChunkLoaderBlockEntity)entity).setOwner(placer.func_110124_au());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && entity instanceof ChunkLoaderBlockEntity) {
            if (((ChunkLoaderBlockEntity)entity).hasOwner()) {
                ChunkLoadingCapability.get(worldIn).castServer().removeChunkLoader((ChunkLoaderBlockEntity)entity);
            } else {
                LegacyChunkLoadingCapability.ChunkTracker cap = (LegacyChunkLoadingCapability.ChunkTracker)worldIn.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY, null);
                if (cap != null) {
                    cap.remove(pos);
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176213_c(World level, BlockPos pos, IBlockState newState) {
        TileEntity entity;
        if (newState.func_177230_c() == this && (entity = level.func_175625_s(pos)) instanceof ChunkLoaderBlockEntity) {
            entity.onLoad();
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockAccess level, Consumer<ITextComponent> info, boolean advanced) {
        if (this.type.getGridSize() == 1) {
            info.accept(TextComponents.translation((String)"chunkloaders.chunk_loader.info.single").color(TextFormatting.AQUA).get());
        } else {
            info.accept(TextComponents.translation((String)"chunkloaders.chunk_loader.info.multiple", (Object[])new Object[]{this.type.getGridSize()}).color(TextFormatting.AQUA).get());
        }
    }
}

