/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.teamdman.animus.AnimusConfig;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@RitualRegister(value="ritualPeace")
public class RitualPeace
extends Ritual {
    private EntityList.EntityEggInfo[] targets;

    public RitualPeace() {
        super("ritualPeace", 0, 5000, "ritual.animus.ritualPeace");
    }

    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, UUID owner) {
        return this.rebuildList(masterRitualStone);
    }

    private boolean rebuildList(IMasterRitualStone masterRitualStone) {
        try {
            System.out.println("Rebuilding Ritual of Peace entity list. [" + masterRitualStone.getBlockPos().toString() + "]");
            this.targets = (EntityList.EntityEggInfo[])EntityList.field_75627_a.values().stream().filter(e -> e.field_75613_a != null).filter(e -> e.field_75613_a.func_110624_b().equals("minecraft")).filter(e -> EntityList.func_188429_b((ResourceLocation)e.field_75613_a, (World)masterRitualStone.getWorldObj()) != null).filter(e -> !EntityList.func_188429_b((ResourceLocation)e.field_75613_a, (World)masterRitualStone.getWorldObj()).isCreatureType(EnumCreatureType.MONSTER, false)).toArray(EntityList.EntityEggInfo[]::new);
            return this.targets.length > 0;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.out.println("Peace ritual creation failed. Entity List:");
            EntityList.field_75627_a.values().forEach(System.out::println);
            return false;
        }
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        BlockPos masterPos = masterRitualStone.getBlockPos();
        if (!world.field_72995_K) {
            Entity mob;
            int index;
            if (this.targets == null || this.targets[index = world.field_73012_v.nextInt(this.targets.length)] == null || this.targets[index].field_75613_a == null || (mob = EntityList.func_188429_b((ResourceLocation)this.targets[index].field_75613_a, (World)world)) == null) {
                if (!this.rebuildList(masterRitualStone)) {
                    masterRitualStone.stopRitual(Ritual.BreakType.DEACTIVATE);
                }
                return;
            }
            for (int i = 0; i < 16; ++i) {
                mob.func_70107_b((double)(masterPos.func_177958_n() + world.field_73012_v.nextInt(8) - 4), (double)(masterPos.func_177956_o() + 1), (double)(masterPos.func_177952_p() + world.field_73012_v.nextInt(8) - 4));
                if (!world.func_175623_d(mob.func_180425_c())) break;
            }
            world.func_72838_d(mob);
            world.func_184133_a(null, mob.func_180425_c(), SoundEvents.field_187815_fJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.peace", new Object[0]), this.getRefreshCost()));
        }
    }

    public int getRefreshCost() {
        return AnimusConfig.rituals.peaceCost;
    }

    public int getRefreshTime() {
        return 400;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 4, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 4, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 4, 2, 0, EnumRuneType.WATER);
        this.addRune(components, 0, 1, 4, EnumRuneType.EARTH);
        this.addRune(components, 0, 2, 4, EnumRuneType.EARTH);
        this.addRune(components, 0, 3, 4, EnumRuneType.WATER);
        this.addRune(components, -4, 2, 0, EnumRuneType.EARTH);
        this.addRune(components, -4, 3, 0, EnumRuneType.EARTH);
        this.addRune(components, -4, 4, 0, EnumRuneType.WATER);
        this.addRune(components, 0, 3, -4, EnumRuneType.EARTH);
        this.addRune(components, 0, 4, -4, EnumRuneType.EARTH);
        this.addRune(components, 0, 5, -4, EnumRuneType.WATER);
    }

    public Ritual getNewCopy() {
        return new RitualPeace();
    }
}

