/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.teamdman.animus.Animus;
import com.teamdman.animus.AnimusConfig;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aura.AuraHelper;

@RitualRegister(value="ritualEldritchWill")
public class RitualEldritchWill
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String EFFECT_RANGE = "effect";
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    public double will = 100.0;
    public final int maxWill = 100;
    public int willRadius;

    public RitualEldritchWill() {
        super("ritualEldritchWill", 0, 5000, "ritual.animus.ritualEldritchWill");
        this.willRadius = AnimusConfig.rituals.willRadius;
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 24));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 1, 1, 1);
        if (this.willRadius > 1) {
            this.willRadius = 1;
        } else if (this.willRadius < 0) {
            this.willRadius = 0;
        }
    }

    public void performRitual(IMasterRitualStone ritualStone) {
        World world = ritualStone.getWorldObj();
        Random random = world.field_73012_v;
        BlockPos pos = ritualStone.getBlockPos();
        EnumDemonWillType type = EnumDemonWillType.DEFAULT;
        this.will = WorldDemonWillHandler.getCurrentWill((World)world, (BlockPos)pos, (EnumDemonWillType)type);
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)ritualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (!Animus.thaumcraftLoaded) {
            return;
        }
        if (!ritualStone.getWorldObj().field_72995_K) {
            double filled;
            float reduction;
            if (currentEssence < this.getRefreshCost()) {
                network.causeNausea();
                return;
            }
            float flux = AuraHelper.getFlux((World)world, (BlockPos)pos);
            int fluxConfig = AnimusConfig.rituals.fluxDrainMax;
            if (fluxConfig < 1) {
                fluxConfig = 1;
            }
            if ((reduction = (float)random.nextInt(fluxConfig)) > flux) {
                reduction = flux;
            }
            ArrayList<BlockPos> UpdateChunks = new ArrayList<BlockPos>();
            Chunk chunk = world.func_175726_f(pos);
            BlockPos centeredPos = new BlockPos(this.getCenterX(chunk), 1, this.getCenterZ(chunk));
            UpdateChunks.add(centeredPos);
            switch (this.willRadius) {
                case 1: {
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, -1), 4, this.getCenterZ(chunk, -1)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, -1), 4, this.getCenterZ(chunk)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, -1), 4, this.getCenterZ(chunk, 1)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk), 4, this.getCenterZ(chunk, 1)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk), 4, this.getCenterZ(chunk, -1)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, 1), 4, this.getCenterZ(chunk, -1)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, 1), 4, this.getCenterZ(chunk)));
                    UpdateChunks.add(new BlockPos(this.getCenterX(chunk, 1), 4, this.getCenterZ(chunk, 1)));
                    break;
                }
            }
            for (int z = 0; z < UpdateChunks.size(); ++z) {
                BlockPos updatePos = (BlockPos)UpdateChunks.get(z);
                AuraHelper.drainFlux((World)world, (BlockPos)updatePos, (float)reduction, (boolean)false);
                AuraHelper.polluteAura((World)world, (BlockPos)updatePos, (float)0.0f, (boolean)true);
            }
            int fluxMulti = AnimusConfig.rituals.fluxToWillConversionMultiplier;
            if (fluxMulti < 0) {
                fluxMulti = 0;
            }
            if ((filled = WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)(reduction * (float)fluxMulti), (double)100.0, (boolean)false)) > 0.0) {
                WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)filled, (double)100.0, (boolean)true);
            }
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.eldritch", new Object[0]), this.getRefreshCost()));
        }
    }

    public int getRefreshCost() {
        if (!Animus.thaumcraftLoaded) {
            return 0;
        }
        return AnimusConfig.rituals.eldritchWillCost;
    }

    public int getRefreshTime() {
        if (!Animus.thaumcraftLoaded) {
            return 10000;
        }
        return AnimusConfig.rituals.eldritchWillSpeed;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(-2, 1, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-2, 1, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-2, 1, 2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -1), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(0, 1, -2), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 1, 2), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(1, 0, -1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(0, -1, 0), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(1, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 1, -2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(2, 1, 0), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 1, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(3, 1, 3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(3, 1, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-3, 1, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-3, 1, 3), EnumRuneType.DUSK));
    }

    public Ritual getNewCopy() {
        return new RitualEldritchWill();
    }

    public int getCenterX(Chunk chunk) {
        return (chunk.field_76635_g << 4) + 8;
    }

    public int getCenterZ(Chunk chunk) {
        return (chunk.field_76647_h << 4) + 8;
    }

    public int getCenterX(Chunk chunk, int offset) {
        return (chunk.field_76635_g << 4) + 8 + offset * 16;
    }

    public int getCenterZ(Chunk chunk, int offset) {
        return (chunk.field_76647_h << 4) + 8 + offset * 16;
    }
}

