/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import amerifrance.guideapi.util.LogHelper;
import com.teamdman.animus.AnimusConfig;
import com.teamdman.animus.common.util.AnimusUtil;
import com.teamdman.animus.handlers.AnimusSoundEventHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@RitualRegister(value="ritualCulling")
public class RitualCulling
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String EFFECT_RANGE = "effect";
    public static final int amount = 200;
    static final DamageSource culled = new DamageSource("animus.absolute").func_76359_i().func_76348_h().func_151518_m();
    public final int maxWill = 100;
    public final Random rand = new Random();
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    public double crystalBuffer = 0.0;
    public LogHelper logger = new LogHelper();
    public int reagentDrain = 2;
    public boolean result = false;
    public double willBuffer = 0.0;
    public HashMap<EnumDemonWillType, Double> willMap = new HashMap();

    public RitualCulling() {
        super("ritualCulling", 0, 50000, "ritual.animus.ritualCulling");
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 0, 15, 15);
    }

    public double smallGauss(double d) {
        Random myRand = new Random();
        return ((double)myRand.nextFloat() - 0.5) * d;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.willBuffer = tag.func_74769_h("willBuffer");
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("willBuffer", this.willBuffer);
    }

    public boolean activateRitual(IMasterRitualStone ritualStone, EntityPlayer player, UUID owner) {
        double xCoord = ritualStone.getBlockPos().func_177958_n();
        double yCoord = ritualStone.getBlockPos().func_177956_o();
        double zCoord = ritualStone.getBlockPos().func_177952_p();
        if (player != null) {
            player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, xCoord, yCoord, zCoord, false));
        }
        return true;
    }

    public void performRitual(IMasterRitualStone ritualStone) {
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)ritualStone.getOwner());
        if (network == null) {
            return;
        }
        int currentEssence = network.getCurrentEssence();
        World world = ritualStone.getWorldObj();
        World soundSource = ritualStone.getWorldObj();
        EnumDemonWillType type = EnumDemonWillType.DESTRUCTIVE;
        BlockPos pos = ritualStone.getBlockPos();
        double currentAmount = WorldDemonWillHandler.getCurrentWill((World)world, (BlockPos)pos, (EnumDemonWillType)type);
        TileAltar tileAltar = AnimusUtil.getNearbyAltar(world, ritualStone.getBlockRange(ALTAR_RANGE), pos, this.altarOffsetPos);
        if (tileAltar == null) {
            if (AnimusConfig.rituals.CullingDebug) {
                System.out.println("Animus: [Ritual of Culling Debug]: No valid altar found within altar range for MRS at " + ritualStone.getBlockPos().toString());
            }
            return;
        }
        this.altarOffsetPos = tileAltar.func_174877_v();
        AreaDescriptor damageRange = ritualStone.getBlockRange(EFFECT_RANGE);
        AxisAlignedBB range = damageRange.getAABB(pos);
        List list = world.func_72872_a(EntityLivingBase.class, range);
        if (AnimusConfig.rituals.CullingDebug) {
            System.out.println("Animus: [Ritual of Culling Debug]: Starting Ritual perform for MRS at " + ritualStone.getBlockPos().toString());
        }
        if (AnimusConfig.rituals.CullingKillsTnT) {
            List Itemlist = world.func_72872_a(EntityTNTPrimed.class, range);
            for (EntityTNTPrimed tnt : Itemlist) {
                tnt.func_184534_a(1000);
                tnt.func_70106_y();
                if (!AnimusConfig.rituals.CullingDebug) continue;
                System.out.println("Animus: [Ritual of Culling Debug]: Found TNT entity, killing");
            }
        }
        int entityCount = 0;
        if (currentEssence < this.getRefreshCost() * list.size()) {
            network.causeNausea();
            if (AnimusConfig.rituals.CullingDebug) {
                System.out.println("Animus: [Ritual of Culling Debug]: Culling MRS at " + ritualStone.getBlockPos().toString() + " does not have sufficient LP from the owner");
            }
        } else {
            double filled;
            if (AnimusConfig.rituals.CullingDebug) {
                System.out.println("Animus: [Ritual of Culling Debug]: Starting culling for loop for MRS at " + ritualStone.getBlockPos().toString());
            }
            for (EntityLivingBase livingEntity : list) {
                Collection effect;
                if (livingEntity instanceof EntityPlayer && livingEntity.func_110143_aJ() > 4.0f || !(effect = livingEntity.func_70651_bq()).isEmpty() && !AnimusConfig.general.canKillBuffedMobs) continue;
                float damage = 0.0f;
                BlockPos at = livingEntity.func_180425_c();
                soundSource = livingEntity.field_70170_p;
                boolean isNonBoss = livingEntity.func_184222_aU();
                if (livingEntity.func_70005_c_().contains("Gaia")) continue;
                livingEntity.func_174810_b(true);
                if (AnimusConfig.rituals.CullingDebug) {
                    System.out.println("Animus: [Ritual of Culling Debug]: MRS at " + ritualStone.getBlockPos().toString() + " Found entity, killing");
                }
                damage = 2.1474836E9f;
                if (AnimusConfig.rituals.killWither && !isNonBoss && currentAmount > 99.0 && currentEssence >= 25000 + this.getRefreshCost() * list.size()) {
                    livingEntity.func_184224_h(false);
                    if (livingEntity instanceof EntityWither) {
                        EntityWither EW = (EntityWither)livingEntity;
                        EW.func_82215_s(0);
                    }
                }
                this.result = livingEntity.func_70097_a(culled, damage);
                if (!this.result) continue;
                ++entityCount;
                tileAltar.sacrificialDaggerCall(200, true);
                if (!isNonBoss) {
                    network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.culling", new Object[0]), 25000));
                } else {
                    double modifier = 0.5;
                    if (livingEntity instanceof EntityAnimal) {
                        modifier = 2.0;
                    }
                    this.willBuffer += modifier * Math.min(15.0, (double)livingEntity.func_110138_aP());
                }
                if (world.field_72995_K) {
                    for (int i = 0; i < this.rand.nextInt(4); ++i) {
                        world.func_175688_a(EnumParticleTypes.PORTAL, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0, new int[0]);
                    }
                }
                soundSource.func_184133_a(null, at, AnimusSoundEventHandler.ghostly, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.culling", new Object[0]), this.getRefreshCost() * entityCount));
            double drainAmount = Math.min(100.0 - currentAmount, (double)Math.min(entityCount / 2, 10));
            if (this.rand.nextInt(30) == 0 && (filled = WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)drainAmount, (double)100.0, (boolean)false)) > 0.0) {
                WorldDemonWillHandler.fillWillToMaximum((World)world, (BlockPos)pos, (EnumDemonWillType)type, (double)filled, (double)100.0, (boolean)true);
            }
        }
    }

    public int getRefreshCost() {
        return 75;
    }

    public int getRefreshTime() {
        return 25;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(1, 0, 1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(1, 0, -1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(2, -1, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, -1, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, -1, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, -1, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(0, -1, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, -1, 0), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(0, -1, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, -1, 0), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-3, -1, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(3, -1, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-3, -1, 3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(3, -1, 3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, -1, 4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, -1, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, -1, 4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, -1, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, -1, -4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-4, -1, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, -1, -4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-4, -1, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(1, 0, 4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, 0, 1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(1, 0, -4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-4, 0, 1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, 0, -1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-4, 0, -1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, 1, 0), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(0, 1, 4), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-4, 1, 0), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(0, 1, -4), EnumRuneType.DUSK));
    }

    public Ritual getNewCopy() {
        return new RitualCulling();
    }
}

