/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.PacketColorCache;
import sonar.fluxnetworks.common.network.PacketFeedback;
import sonar.fluxnetworks.common.network.PacketNetworkUpdate;

public class PacketGeneralHandler {
    public static NBTTagCompound getCreateNetworkPacket(String name, int color, SecurityType security, EnergyType energy, String password) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, name);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static IMessage handleCreateNetworkPacket(EntityPlayer player, NBTTagCompound nbtTag) {
        String name = nbtTag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = nbtTag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        SecurityType security = SecurityType.values()[nbtTag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[nbtTag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = nbtTag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.ILLEGAL_PASSWORD);
        }
        if (FluxNetworkCache.instance.hasSpaceLeft(player)) {
            FluxNetworkCache.instance.createdNetwork(player, name, color, security, energy, password);
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS);
        }
        return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_SPACE);
    }

    public static NBTTagCompound getNetworkEditPacket(int networkID, String networkName, int color, SecurityType security, EnergyType energy, String password) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(FluxNetworkData.NETWORK_COLOR, color);
        tag.func_74768_a(FluxNetworkData.SECURITY_TYPE, security.ordinal());
        tag.func_74768_a(FluxNetworkData.ENERGY_TYPE, energy.ordinal());
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static IMessage handleNetworkEditPacket(EntityPlayer player, NBTTagCompound tag) {
        int networkID = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String newName = tag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        int color = tag.func_74762_e(FluxNetworkData.NETWORK_COLOR);
        SecurityType security = SecurityType.values()[tag.func_74762_e(FluxNetworkData.SECURITY_TYPE)];
        EnergyType energy = EnergyType.values()[tag.func_74762_e(FluxNetworkData.ENERGY_TYPE)];
        String password = tag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (!FluxUtils.checkPassword(password)) {
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.ILLEGAL_PASSWORD);
        }
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                boolean needPacket = false;
                if (!network.getSetting(NetworkSettings.NETWORK_NAME).equals(newName)) {
                    network.setSetting(NetworkSettings.NETWORK_NAME, newName);
                    needPacket = true;
                }
                if (network.getSetting(NetworkSettings.NETWORK_COLOR) != color) {
                    network.setSetting(NetworkSettings.NETWORK_COLOR, color);
                    needPacket = true;
                    List<IFluxConnector> list = network.getConnections(FluxLogicType.ANY);
                    list.forEach(fluxConnector -> fluxConnector.connect(network));
                }
                if (needPacket) {
                    HashMap<Integer, Tuple<Integer, String>> cache = new HashMap<Integer, Tuple<Integer, String>>();
                    cache.put(networkID, new Tuple((Object)(network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000), (Object)network.getSetting(NetworkSettings.NETWORK_NAME)));
                    PacketHandler.network.sendToAll((IMessage)new PacketColorCache.ColorCacheMessage(cache));
                }
                network.setSetting(NetworkSettings.NETWORK_SECURITY, security);
                network.setSetting(NetworkSettings.NETWORK_ENERGY, energy);
                network.setSetting(NetworkSettings.NETWORK_PASSWORD, password);
                PacketHandler.network.sendToAll((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
                return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS_2);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getDeleteNetworkPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage handleDeleteNetworkPacket(EntityPlayer player, NBTTagCompound nbtTag) {
        int id = nbtTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork toDelete = FluxNetworkCache.instance.getNetwork(id);
        if (!toDelete.isInvalid()) {
            if (toDelete.getMemberPermission(player).canDelete()) {
                FluxNetworkData.get().removeNetwork(toDelete);
                return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_OWNER);
        }
        return null;
    }

    @Deprecated
    public static NBTTagCompound getAddMemberPacket(int networkID, String playerName) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a("playerName", playerName);
        return tag;
    }

    @Deprecated
    public static IMessage handleAddMemberPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String playerName = packetTag.func_74779_i("playerName");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.addNewMember(playerName);
                return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    @Deprecated
    public static NBTTagCompound getRemoveMemberPacket(int networkID, UUID playerRemoved) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        return tag;
    }

    @Deprecated
    public static IMessage handleRemoveMemberPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.removeMember(playerRemoved);
                return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getChangePermissionPacket(int networkID, UUID playerChanged, int type) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        tag.func_74768_a("t", type);
        return tag;
    }

    public static IMessage handleChangePermissionPacket(EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network;
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        int type = packetTag.func_74762_e("t");
        if (playerChanged != null && !(network = FluxNetworkCache.instance.getNetwork(networkID)).isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                if (type == 0) {
                    EntityPlayerMP player1 = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerChanged);
                    if (player1 != null) {
                        NetworkMember newMember = NetworkMember.createNetworkMember((EntityPlayer)player1, AccessLevel.USER);
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(newMember);
                        PacketHandler.network.sendTo((IMessage)new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS), (EntityPlayerMP)player);
                        return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                    }
                    return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.INVALID_USER);
                }
                Optional<NetworkMember> settings = network.getValidMember(playerChanged);
                if (settings.isPresent()) {
                    NetworkMember p = settings.get();
                    if (type == 1) {
                        p.setAccessPermission(AccessLevel.ADMIN);
                    } else if (type == 2) {
                        p.setAccessPermission(AccessLevel.USER);
                    } else if (type == 3) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).remove(p);
                    } else if (type == 4) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).removeIf(f -> f.getAccessPermission().canDelete());
                        network.setSetting(NetworkSettings.NETWORK_OWNER, playerChanged);
                        p.setAccessPermission(AccessLevel.OWNER);
                    }
                    PacketHandler.network.sendTo((IMessage)new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS), (EntityPlayerMP)player);
                    return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                }
                if (type == 4) {
                    EntityPlayerMP player1 = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerChanged);
                    if (player1 != null) {
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).removeIf(f -> f.getAccessPermission().canDelete());
                        NetworkMember newMember = NetworkMember.createNetworkMember((EntityPlayer)player1, AccessLevel.OWNER);
                        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(newMember);
                        network.setSetting(NetworkSettings.NETWORK_OWNER, playerChanged);
                        PacketHandler.network.sendTo((IMessage)new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS), (EntityPlayerMP)player);
                        return new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_PLAYERS);
                    }
                    return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.INVALID_USER);
                }
                return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.INVALID_USER);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static NBTTagCompound getChangeWirelessPacket(int networkID, int wirelessMode) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74768_a(FluxNetworkData.WIRELESS_MODE, wirelessMode);
        return tag;
    }

    public static IMessage handleChangeWirelessPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        int wireless = packetTag.func_74762_e(FluxNetworkData.WIRELESS_MODE);
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(networkID);
        if (!network.isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                network.setSetting(NetworkSettings.NETWORK_WIRELESS, wireless);
                PacketHandler.network.sendTo((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL), (EntityPlayerMP)player);
                return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }
}

