/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiDraw;

public class SlidedSwitchButton
extends GuiButtonCore {
    public boolean slideControl = false;
    protected float center;
    private int guiLeft;
    private int guiTop;

    public SlidedSwitchButton(int x, int y, int id, int guiLeft, int guiTop, boolean defaultControl) {
        super(x, y, 16, 8, id);
        if (defaultControl) {
            this.slideControl = true;
            this.center = 8.0f;
        }
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY, int guiLeft, int guiTop) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int s = this.getState(mc, mouseX, mouseY);
        mc.func_110434_K().func_110577_a(GuiDraw.BUTTONS);
        this.drawTexturedRectangular(this.x, this.y, 32.0, 32.0, this.center * 2.0f, 8.0);
        this.func_175174_a((float)this.x + this.center, this.y, 16 * s, 40, 8, 8);
        this.func_73729_b(this.x, this.y, 16 * s, 32, 16, 8);
        GlStateManager.func_179121_F();
    }

    private int getState(Minecraft mc, int mouseX, int mouseY) {
        return this.slideControl || this.isMouseHovered(mc, mouseX - this.guiLeft, mouseY - this.guiTop) ? 0 : 1;
    }

    public void switchButton() {
        this.slideControl = !this.slideControl;
    }

    @Override
    public void updateButton(float partialTicks, int mouseX, int mouseY) {
        float par = partialTicks * 4.0f;
        this.center = this.slideControl ? (this.center <= 8.0f - par ? (this.center += par) : 8.0f) : (this.center >= par ? (this.center -= par) : 0.0f);
    }
}

