/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.player.tracker;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.misc.Misc;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerIconRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElement;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementCollector;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementReader;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderProvider;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final double WORLD_MINIMUM_DISTANCE = 10.0;
    private final double WORLD_FADING_LENGTH = 10.0;
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;
    private float nameScale;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(EntityPlayer player, NetworkPlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).func_110306_p() : info.func_178837_g();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        GlStateManager.func_179126_j();
        ((PlayerTrackerMinimapElementRenderContext)this.context).renderEntityDimId = renderInfo.renderEntityDimension;
        ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = renderInfo.mapDimension;
        ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale = renderInfo.location == MinimapElementRenderLocation.IN_WORLD ? HudMod.INSTANCE.getSettings().getTrackedPlayerWorldIconScale(renderInfo.scaledResolution.func_78325_e()) : HudMod.INSTANCE.getSettings().getTrackedPlayerMinimapIconScale(renderInfo.scaledResolution.func_78325_e());
        this.nameScale = HudMod.INSTANCE.getSettings().getTrackedPlayerWorldNameScale(renderInfo.scaledResolution.func_78325_e());
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
        this.elementCollector.resetRenderedOnRadarFlags();
        GlStateManager.func_179097_i();
    }

    @Override
    public boolean renderElement(PlayerTrackerMinimapElement<?> e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        float alpha;
        double trackedZ;
        double offZ;
        double trackedY;
        double offY;
        if (!outOfBounds && renderInfo.location != MinimapElementRenderLocation.IN_WORLD && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(e.getPlayerId());
        if (info == null) {
            return false;
        }
        EntityPlayer clientPlayer = mc.field_71441_e.func_152378_a(e.getPlayerId());
        double trackedX = clientPlayer == null ? e.getX() : EntityUtils.getEntityX((Entity)clientPlayer, renderInfo.partialTicks);
        double offX = trackedX - renderInfo.renderEntityPos.field_72450_a;
        double distance = Math.sqrt(offX * offX + (offY = (trackedY = clientPlayer == null ? e.getY() : EntityUtils.getEntityY((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.field_72448_b) * offY + (offZ = (trackedZ = clientPlayer == null ? e.getZ() : EntityUtils.getEntityZ((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.field_72449_c) * offZ);
        if (distance < 10.0) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)optionalDepth);
        boolean inWorld = renderInfo.location == MinimapElementRenderLocation.IN_WORLD;
        float f = alpha = inWorld ? 0.5f : 1.0f;
        if (highlighted && inWorld) {
            alpha = 0.8f;
        }
        if (!highlighted && inWorld && distance < 20.0) {
            alpha *= (float)((distance - 10.0) / 10.0);
        }
        int backgroundColor = 0xFFFFFF | (int)(Misc.adjustOpacityForGamma(alpha) * 255.0f) << 24;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, (float)((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, (float)1.0f);
        GlStateManager.func_179118_c();
        this.playerTrackerIconRenderer.renderIcon(mc, clientPlayer, this.getPlayerSkin(clientPlayer, info), alpha);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.01);
        Gui.func_73734_a((int)-5, (int)-5, (int)5, (int)5, (int)backgroundColor);
        GlStateManager.func_179121_F();
        if (highlighted && inWorld) {
            GlStateManager.func_179109_b((float)(-5.0f * ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.nameScale, (float)this.nameScale, (float)1.0f);
            String playerName = info.func_178845_a().getName();
            int playerNameWidth = mc.field_71466_p.func_78256_a(playerName);
            float labelAlpha = Misc.adjustOpacityForGamma(0.3529412f);
            backgroundColor = (int)(labelAlpha * 255.0f) << 24;
            Gui.func_73734_a((int)(-playerNameWidth - 1), (int)-5, (int)0, (int)5, (int)backgroundColor);
            mc.field_71466_p.func_78276_b(playerName, -playerNameWidth, -4, -1);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        return true;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        return location != MinimapElementRenderLocation.IN_WORLD && this.modMain.getSettings().displayTrackedPlayersOnMap || location == MinimapElementRenderLocation.IN_WORLD && this.modMain.getSettings().displayTrackedPlayersInWorld;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

