/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node.options;

import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryWidget;
import xaero.hud.category.ui.entry.EditorListEntryWrapper;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.entry.widget.EditorButtonIteration;
import xaero.hud.category.ui.entry.widget.EditorSlider;
import xaero.hud.category.ui.entry.widget.ICategorySettingsWidget;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorOptionNode;
import xaero.hud.category.ui.node.options.EditorOptionsNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;

public abstract class EditorCompactOptionsNode<V>
extends EditorOptionsNode<V> {
    private IntConsumer updatedIndexConsumer;
    protected int currentIndex;
    protected final int optionCount;

    protected EditorCompactOptionsNode(String displayName, int currentIndex, int optionCount, boolean movable, EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier, EditorOptionsNode.IOptionsNodeIsActiveSupplier isActiveSupplier) {
        super(displayName, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.currentIndex = currentIndex;
        this.optionCount = optionCount;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getOptionCount() {
        return this.optionCount;
    }

    public final IntConsumer getUpdatedIndexConsumer() {
        if (this.updatedIndexConsumer == null) {
            this.updatedIndexConsumer = new IntConsumer(){

                @Override
                public void accept(int i) {
                    EditorCompactOptionsNode.this.currentIndex = i;
                    EditorCompactOptionsNode.this.setCurrentValue(EditorCompactOptionsNode.this.getIndexReader().apply(i));
                }
            };
        }
        return this.updatedIndexConsumer;
    }

    protected abstract IntFunction<EditorOptionNode<V>> getIndexReader();

    @Override
    public List<EditorNode> getSubNodes() {
        return null;
    }

    public static abstract class Builder<V, B extends Builder<V, B>>
    extends EditorOptionsNode.Builder<V, B> {
        private boolean slider;

        protected Builder() {
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.setSlider(false);
            return (B)((Builder)this.self);
        }

        public B setSlider(boolean slider) {
            this.slider = slider;
            return (B)((Builder)this.self);
        }

        @Override
        public EditorOptionsNode<V> build() {
            this.setListEntryFactory(this.getMainEntryFactory(this.slider));
            return super.build();
        }

        private EditorListRootEntryFactory getMainEntryFactory(final boolean slider) {
            return new EditorListRootEntryFactory(){

                @Override
                public EditorListRootEntry get(EditorNode data, EditorNode parent, int index, ConnectionLineType lineType, GuiCategoryEditor.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new EditorListEntryWrapper(Builder.this.getCenteredEntryFactory(slider, data, parent, index, rowList, screenWidth), screenWidth, index, rowList, lineType, data);
                }
            };
        }

        protected EditorListRootEntry.CenteredEntryFactory getCenteredEntryFactory(boolean slider, final EditorNode data, final EditorNode parent, final int index, final GuiCategoryEditor.SettingRowList rowList, int screenWidth) {
            final ICategorySettingsWidget widget = this.getEntryWidget(slider, data, parent, index, rowList, screenWidth);
            return new EditorListRootEntry.CenteredEntryFactory(){

                @Override
                public EditorListEntry get(int x, int y, int width, int height, EditorListRootEntry root) {
                    return new EditorListEntryWidget(x, y, width, height, index, rowList, root, widget, data.getTooltipSupplier(parent));
                }
            };
        }

        protected ICategorySettingsWidget getEntryWidget(boolean slider, EditorNode data, EditorNode parent, int index, GuiCategoryEditor.SettingRowList rowList, int screenWidth) {
            if (slider) {
                return new EditorSlider(((EditorCompactOptionsNode)data).getUpdatedIndexConsumer(), ((EditorCompactOptionsNode)data).getMessageSupplier(), ((EditorCompactOptionsNode)data).getCurrentIndex(), ((EditorCompactOptionsNode)data).getOptionCount(), 216, 20, rowList, screenWidth);
            }
            return new EditorButtonIteration(parent, ((EditorCompactOptionsNode)data).getUpdatedIndexConsumer(), ((EditorCompactOptionsNode)data).getMessageSupplier(), true, ((EditorCompactOptionsNode)data).getCurrentIndex(), ((EditorCompactOptionsNode)data).getOptionCount(), 216, 20, rowList);
        }

        @Override
        protected abstract EditorCompactOptionsNode<V> buildInternally();
    }
}

