/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiActionButton;
import xaero.common.gui.ScreenBase;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;

public abstract class GuiCategoryEditor<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    private ITextComponent title;
    protected ED cutCategory;
    protected ED cutCategorySuper;

    protected GuiCategoryEditor(IXaeroMinimap modMain, GuiScreen parent, GuiScreen escape, ITextComponent title, EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
        super(modMain, parent, escape);
        this.dataConverter = dataConverter;
        this.editorData = this.constructEditorData(dataConverter);
        this.title = title;
    }

    protected abstract ED constructEditorData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new GuiActionButton(this.field_146294_l / 2 + 5, this.field_146295_m - 32, 150, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_cancel", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategoryEditor.this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int id) {
                        if (result) {
                            GuiCategoryEditor.super.onExit(GuiCategoryEditor.this.parent);
                        } else {
                            GuiCategoryEditor.this.field_146297_k.func_147108_a((GuiScreen)GuiCategoryEditor.this);
                        }
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_settings_cancel_confirm", (Object[])new Object[0]), "", 0));
            }
        });
        this.func_189646_b(new GuiActionButton(this.field_146294_l / 2 - 155, this.field_146295_m - 32, 150, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_confirm", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategoryEditor.this.confirm();
            }
        });
        this.func_189646_b(new GuiActionButton(6, 6, 120, 20, I18n.func_135052_a((String)"gui.xaero_category_settings_reset", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiCategoryEditor.this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int id) {
                        if (result) {
                            GuiCategoryEditor.this.editorData = GuiCategoryEditor.this.constructDefaultData(GuiCategoryEditor.this.dataConverter);
                        }
                        GuiCategoryEditor.this.field_146297_k.func_147108_a((GuiScreen)GuiCategoryEditor.this);
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_settings_reset_confirm1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_category_settings_reset_confirm2", (Object[])new Object[0]), 0));
            }
        });
        this.rowList = new SettingRowList(this.dataConverter);
        this.rowList.func_148134_d(7, 8);
    }

    private void confirm() {
        this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        super.onExit(this.parent);
    }

    @Override
    protected void onExit(final GuiScreen screen) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    GuiCategoryEditor.this.confirm();
                }
                GuiCategoryEditor.super.onExit(screen);
            }
        }, I18n.func_135052_a((String)"gui.xaero_category_settings_save_confirm", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_category_settings_save_confirm_warning", (Object[])new Object[0]), 0){

            protected void func_73869_a(char typedChar, int keyCode) throws IOException {
                if (keyCode == 1) {
                    return;
                }
                super.func_73869_a(typedChar, keyCode);
            }
        });
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        this.rowList.func_148128_a(i, j, f);
        this.func_73732_a(this.field_146297_k.field_71466_p, this.title.func_150254_d(), this.field_146294_l / 2, 5, 0xFFFFFF);
        super.func_73863_a(i, j, f);
        if (this.rowList.hovered == null) {
            return;
        }
        Supplier<CursorBox> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
        if (tooltipSupplier == null) {
            return;
        }
        CursorBox tooltip = tooltipSupplier.get();
        if (tooltip == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        tooltip.drawBox(i, j, this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179121_F();
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.rowList.keyTyped(typedChar, keyCode);
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        this.rowList.tick();
        super.func_73876_c();
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.rowList.mouseDragged(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.handledMouseInput) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.rowList.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.handledMouseInput) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.rowList.mouseReleased(mouseX, mouseY, state);
        if (this.handledMouseInput) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        this.rowList.func_178039_p();
    }

    public class SettingRowList
    extends GuiSlot {
        private EditorNode lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private EditorListEntry hovered;
        private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
        private List<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> entries;
        private xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry selected;

        public SettingRowList(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategoryEditor.this.field_146297_k, GuiCategoryEditor.this.field_146294_l, GuiCategoryEditor.this.field_146295_m, 32, Math.max(36, GuiCategoryEditor.this.field_146295_m - 48), 24);
            this.dataConverter = dataConverter;
            this.entries = new ArrayList<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry>();
            this.updateEntries();
            this.func_193651_b(false);
        }

        public xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry getSelected() {
            return this.selected;
        }

        private void clearEntries() {
            this.entries.clear();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void addEntry(Entry e) {
            this.entries.add((xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry)e);
        }

        public boolean hasCut() {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return false;
            }
            if (((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().contains(GuiCategoryEditor.this.cutCategory)) {
                return true;
            }
            this.setCutCategory(null, null);
            return false;
        }

        public ED getCut() {
            return GuiCategoryEditor.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategoryEditor.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategoryEditor.this.cutCategory = cutCategory;
            GuiCategoryEditor.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return;
            }
            if (destination == GuiCategoryEditor.this.cutCategory || destination == GuiCategoryEditor.this.cutCategorySuper) {
                this.setCutCategory(null, null);
                this.updateEntries();
                return;
            }
            ((EditorNode)destination).getExpandAction(this).run();
            this.setLastExpandedData((EditorNode)GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().remove(GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)destination).getSubCategories().add(0, GuiCategoryEditor.this.cutCategory);
            this.setCutCategory(null, null);
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int slotIndex) {
            return this.getSelected() == this.entries.get(slotIndex);
        }

        protected void func_148123_a() {
            GuiCategoryEditor.this.func_146276_q_();
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
            Entry entry = (Entry)this.entries.get(slotIndex);
            entry.render(slotIndex, yPos, xPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn, this.func_148124_c(mouseXIn, mouseYIn) == slotIndex, partialTicks);
        }

        public void setLastExpandedData(EditorNode lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void centerScrollOn(Entry entry) {
            int index = this.entries.indexOf(entry);
            this.field_148169_q = index * this.func_148146_j() - (this.field_148154_c - this.field_148153_b) / 2;
            if (this.field_148169_q < 0.0f) {
                this.field_148169_q = 0.0f;
            }
        }

        public void updateEntries() {
            int scrollBackup = this.func_148148_g();
            this.clearEntries();
            GuiCategoryEditor.this.editorData.setExpanded(true);
            this.addEntriesForExpanded(GuiCategoryEditor.this.editorData, null);
            if (this.getSelected() != null) {
                this.centerScrollOn(this.getSelected());
            }
            if (this.restoreScrollAfterUpdate) {
                this.field_148169_q = scrollBackup;
                this.restoreScrollAfterUpdate = false;
            }
        }

        private void addEntriesForExpanded(EditorNode data, EditorNode parent) {
            int nextIndex = this.entries.size();
            List<EditorNode> subExpandables = data.getSubNodes();
            if (subExpandables == null) {
                return;
            }
            EditorNode expandedData = null;
            for (EditorNode sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            EditorListRootEntry wrappedEntry = data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.field_148155_a, expandedData == null);
            Entry currentEntry = new Entry(wrappedEntry, nextIndex++);
            this.addEntry(currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpanded(expandedData, data);
                return;
            }
            if (this.lastExpandedData == null && data.isExpanded()) {
                this.setSelected(currentEntry);
            }
            boolean first = true;
            for (EditorNode sed : subExpandables) {
                wrappedEntry = sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.field_148155_a, false);
                Entry leafEntry = new Entry(wrappedEntry, nextIndex++);
                this.addEntry(leafEntry);
                if (sed == this.lastExpandedData) {
                    this.setSelected(leafEntry);
                }
                first = false;
            }
        }

        public boolean keyTyped(char c, int i) {
            boolean result;
            return this.getSelected() != null && (result = this.getSelected().keyTyped(c, i));
        }

        public void tick() {
            if (this.getSelected() != null) {
                this.getSelected().tick();
            }
        }

        public boolean confirmSelection() {
            Entry entry = this.getSelected();
            if (entry == null) {
                return false;
            }
            EditorListEntry selectedSubEntry = entry.wrappedEntry.confirmSelection();
            return selectedSubEntry != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.getSelected() != null) {
                this.getSelected().wrappedEntry.unfocusRecursively();
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            this.selected = entry;
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        public void func_148128_a(int i, int j, float f) {
            this.hovered = null;
            super.func_148128_a(i, j, f);
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + 164;
        }

        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            Entry e;
            if (mouseY < this.field_148153_b || mouseY >= this.field_148154_c) {
                return;
            }
            int slotIndex = GuiCategoryEditor.this.rowList.func_148124_c(mouseX, mouseY);
            if (slotIndex >= 0 && slotIndex < this.entries.size() && (e = (Entry)this.entries.get(slotIndex)).mouseClicked(mouseX, mouseY, mouseButton)) {
                GuiCategoryEditor.this.handledMouseInput = true;
                return;
            }
        }

        public void mouseReleased(int mouseX, int mouseY, int i) {
            for (Entry entry : this.entries) {
                entry.mouseReleased(mouseX, mouseY, i);
            }
        }

        public void mouseDragged(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        }

        public void func_178039_p() {
            super.func_178039_p();
            if (this.field_148170_p > 0.0f) {
                this.field_148157_o = -2;
                this.field_148170_p = 0.0f;
            }
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry {
            private EditorListRootEntry wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(EditorListRootEntry entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void render(int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                boolean includesSelected = SettingRowList.this.getSelected() == this;
                this.wrappedEntry.preRender(includesSelected, true);
                EditorListEntry hoveredInRow = this.wrappedEntry.render(index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategoryEditor.this.field_146289_q, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender();
                GlStateManager.func_179121_F();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean mouseClicked(int mouseX, int mouseY, int i) {
                SettingRowList.this.setSelected(this);
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
            }

            public boolean mouseReleased(int mouseX, int mouseY, int i) {
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
            }

            public boolean mouseDragged(int mouseX, int mouseY, int i, long timeSinceLastClick) {
                int relativeMouseX = mouseX - this.lastX - this.wrappedEntry.getEntryRelativeX();
                int relativeMouseY = mouseY - this.lastY - this.wrappedEntry.getEntryRelativeY();
                return this.wrappedEntry.mouseDragged(this, relativeMouseX, relativeMouseY, i, timeSinceLastClick);
            }

            public boolean keyTyped(char c, int i) {
                return this.wrappedEntry.keyTyped(c, i, true);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }
        }
    }
}

