/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.zenscript;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.runtime.GlobalFunctions;
import crafttweaker.zenscript.CrTCompileEnvironment;
import crafttweaker.zenscript.CrTGlobalEnvironment;
import crafttweaker.zenscript.CrtStoringErrorLogger;
import crafttweaker.zenscript.IBracketHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenTypeIntRange;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.Pair;

public class GlobalRegistry {
    private static final Map<String, IZenSymbol> globals = new HashMap<String, IZenSymbol>();
    private static final Set<Pair<Integer, IBracketHandler>> bracketHandlers = new TreeSet<Pair>(Comparator.comparingInt(Pair::getKey).thenComparing(o -> ((IBracketHandler)o.getValue()).getClass().getName()));
    private static final TypeRegistry types = new TypeRegistry();
    private static final SymbolPackage root = new SymbolPackage("<root>");
    private static final IZenErrorLogger errors = new CrtStoringErrorLogger();
    private static final IZenCompileEnvironment environment = new CrTCompileEnvironment();
    private static final Map<String, TypeExpansion> expansions = new HashMap<String, TypeExpansion>();

    private GlobalRegistry() {
    }

    public static void registerGlobal(String name, IZenSymbol symbol) {
        if (globals.containsKey(name)) {
            throw new IllegalArgumentException("symbol already exists: " + name);
        }
        globals.put(name, symbol);
    }

    public static void registerExpansion(Class<?> cls) {
        try {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof ZenExpansion)) continue;
                ZenExpansion eAnnotation = (ZenExpansion)annotation;
                if (!expansions.containsKey(eAnnotation.value())) {
                    expansions.put(eAnnotation.value(), new TypeExpansion(eAnnotation.value()));
                }
                expansions.get(eAnnotation.value()).expand(cls, types);
            }
        }
        catch (Throwable ex) {
            CraftTweakerAPI.getLogger().logError("Failed to register expansion for " + cls.getName(), ex);
        }
    }

    public static void registerBracketHandler(IBracketHandler handler) {
        int prio = 10;
        if (handler.getClass().getAnnotation(BracketHandler.class) != null) {
            prio = handler.getClass().getAnnotation(BracketHandler.class).priority();
        } else {
            CraftTweakerAPI.logInfo(handler.getClass().getName() + " is missing a BracketHandler annotation, setting the priority to " + prio);
        }
        bracketHandlers.add(new Pair<Integer, IBracketHandler>(prio, handler));
    }

    public static void removeBracketHandler(IBracketHandler handler) {
        Pair<Integer, IBracketHandler> prioPair = null;
        for (Pair<Integer, IBracketHandler> pair : bracketHandlers) {
            if (!pair.getValue().equals(handler)) continue;
            prioPair = pair;
        }
        bracketHandlers.remove(prioPair);
    }

    public static void registerNativeClass(Class<?> cls) {
        try {
            ZenTypeNative type = new ZenTypeNative(cls);
            type.complete(types);
            root.put(type.getName(), new SymbolType(type), errors);
        }
        catch (Throwable ex) {
            CraftTweakerAPI.getLogger().logError("Failed to register class for " + cls.getName(), ex);
        }
    }

    public static IZenSymbol resolveBracket(IEnvironmentGlobal environment, List<Token> tokens) {
        for (Pair<Integer, IBracketHandler> pair : bracketHandlers) {
            IZenSymbol symbol = pair.getValue().resolve(environment, tokens);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static IZenSymbol getStaticFunction(Class<?> cls, String name, Class<?> ... arguments) {
        IJavaMethod method = JavaMethod.get(types, cls, name, arguments);
        return new SymbolJavaStaticMethod(method);
    }

    public static IZenSymbol getStaticField(Class<?> cls, String name) {
        try {
            Field field = cls.getDeclaredField(name);
            return new SymbolJavaStaticField(cls, field, types);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(GlobalRegistry.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static IEnvironmentGlobal makeGlobalEnvironment(Map<String, byte[]> classes) {
        return new CrTGlobalEnvironment(classes);
    }

    public static IEnvironmentGlobal makeGlobalEnvironment(Map<String, byte[]> classes, String loaderMainName) {
        return new CrTGlobalEnvironment(classes, GlobalRegistry.capitalize(loaderMainName));
    }

    private static String capitalize(String in) {
        if (in == null || in.length() < 1) {
            return "";
        }
        return Character.toUpperCase(in.charAt(0)) + in.substring(1);
    }

    public static Map<String, IZenSymbol> getGlobals() {
        return globals;
    }

    public static Set<Pair<Integer, IBracketHandler>> getPrioritizedBracketHandlers() {
        return bracketHandlers;
    }

    @Deprecated
    public static List<IBracketHandler> getBracketHandlers() {
        LinkedList<IBracketHandler> handlers = new LinkedList<IBracketHandler>();
        for (Pair<Integer, IBracketHandler> pair : GlobalRegistry.getPrioritizedBracketHandlers()) {
            handlers.add(pair.getValue());
        }
        return handlers;
    }

    public static TypeRegistry getTypes() {
        return types;
    }

    public static SymbolPackage getRoot() {
        return root;
    }

    public static IZenErrorLogger getErrors() {
        return errors;
    }

    public static IZenCompileEnvironment getEnvironment() {
        return environment;
    }

    public static Map<String, TypeExpansion> getExpansions() {
        return expansions;
    }

    static {
        GlobalRegistry.registerGlobal("print", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "print", String.class));
        GlobalRegistry.registerGlobal("totalActions", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "totalActions", new Class[0]));
        GlobalRegistry.registerGlobal("enableDebug", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "enableDebug", new Class[0]));
        GlobalRegistry.registerGlobal("isNull", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "isNull", Object.class));
        GlobalRegistry.registerGlobal("max", GlobalRegistry.getStaticFunction(Math.class, "max", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("min", GlobalRegistry.getStaticFunction(Math.class, "min", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("pow", GlobalRegistry.getStaticFunction(Math.class, "pow", Double.TYPE, Double.TYPE));
        root.put(ZenTypeIntRange.INTRANGE.getName(), new SymbolType(ZenTypeIntRange.INSTANCE), errors);
    }
}

