/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.event.PlayerFillBucketEvent;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IRayTraceResult;
import crafttweaker.api.world.IWorld;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MCPlayerFillBucketEvent
implements PlayerFillBucketEvent {
    private final FillBucketEvent event;

    public MCPlayerFillBucketEvent(FillBucketEvent ev) {
        this.event = ev;
    }

    @Override
    public IItemStack getResult() {
        return CraftTweakerMC.getIItemStack(this.event.getFilledBucket());
    }

    @Override
    public void setResult(IItemStack result) {
        this.event.setFilledBucket(CraftTweakerMC.getItemStack(result));
        this.event.setResult(Event.Result.ALLOW);
    }

    @Override
    public IItemStack getEmptyBucket() {
        return CraftTweakerMC.getIItemStack(this.event.getEmptyBucket());
    }

    @Override
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld(this.event.getWorld());
    }

    @Override
    public IBlock getBlock() {
        IBlockState blockState = this.getBlockState();
        return blockState == null ? null : blockState.getBlock();
    }

    @Override
    public IBlockState getBlockState() {
        RayTraceResult target = this.event.getTarget();
        return target == null ? null : CraftTweakerMC.getBlockState(this.event.getWorld().func_180495_p(target.func_178782_a()));
    }

    @Override
    public int getDimension() {
        return this.getWorld().getDimension();
    }

    @Override
    public IBlockPos getPosition() {
        RayTraceResult target = this.event.getTarget();
        return CraftTweakerMC.getIBlockPos(target == null ? this.event.getEntityPlayer().func_180425_c() : target.func_178782_a());
    }

    @Override
    public IRayTraceResult getRayTraceResult() {
        return CraftTweakerMC.getIRayTraceResult(this.event.getTarget());
    }

    @Override
    public boolean isCanceled() {
        return this.event.isCanceled();
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.event.setCanceled(canceled);
    }

    @Override
    public void process() {
        this.event.setResult(Event.Result.ALLOW);
    }

    @Override
    public boolean isProcessed() {
        return this.event.getResult() == Event.Result.ALLOW;
    }

    @Override
    public IPlayer getPlayer() {
        return CraftTweakerMC.getIPlayer(this.event.getEntityPlayer());
    }
}

