/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.generator;

import com.buuz135.industrial.proxy.client.infopiece.PetrifiedFuelInfoPiece;
import com.buuz135.industrial.tile.CustomGeneratorMachine;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;

public abstract class AbstractFuelGenerator
extends CustomGeneratorMachine {
    private ItemStackHandler inStackHandler;
    private ItemStack current = ItemStack.field_190927_a;
    private int burnTime = 0;

    public AbstractFuelGenerator(int hash) {
        super(hash);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inStackHandler = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                AbstractFuelGenerator.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inStackHandler, EnumDyeColor.GREEN, "Fuel input", new BoundingRectangle(61, 25, 18, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return AbstractFuelGenerator.this.acceptsItemStack(stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 1, 3, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, EnumDyeColor.GREEN));
                return pieces;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle boundingRectangle = this.getBoundingBox();
                for (int y = 0; y < this.getInnerHandler().getSlots(); ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, boundingRectangle.getLeft() + 1, boundingRectangle.getTop() + 1 + y * 18));
                }
                return slots;
            }
        });
        super.addInventoryToStorage(this.inStackHandler, "pet_gen_input");
    }

    public ItemStack getFirstFuel(boolean replace) {
        if (!replace) {
            return this.current;
        }
        for (int i = 0; i < this.inStackHandler.getSlots(); ++i) {
            if (this.inStackHandler.getStackInSlot(i).func_190926_b()) continue;
            this.current = new ItemStack(this.inStackHandler.getStackInSlot(i).func_77973_b(), 1);
            this.forceSync();
            return this.inStackHandler.getStackInSlot(i);
        }
        this.current = ItemStack.field_190927_a;
        return this.current;
    }

    public long consumeFuel() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0L;
        }
        ItemStack temp = this.getFirstFuel(true);
        if (temp.func_190926_b()) {
            return 0L;
        }
        this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)temp);
        temp.func_190920_e(temp.func_190916_E() - 1);
        return (long)((float)(this.burnTime * 100) * this.getMultiplier());
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> list = super.getGuiContainerPieces(container);
        list.add((IGuiContainerPiece)new PetrifiedFuelInfoPiece(this, 88, 25));
        return list;
    }

    public abstract boolean acceptsItemStack(ItemStack var1);

    public abstract long getEnergyProduced(int var1);

    public abstract float getMultiplier();

    protected long getEnergyFillRate() {
        return this.getEnergyProduced(this.burnTime);
    }

    public ItemStack getCurrent() {
        return this.current;
    }
}

