/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.ritual.imperfect.ImperfectRitual;
import WayofTime.bloodmagic.util.BMLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class RitualManager {
    public static final DamageSource RITUAL_DAMAGE = new DamageSource("ritual_damage").func_76348_h();
    private final Map<String, Ritual> rituals = Maps.newTreeMap();
    private final Map<Ritual, String> ritualsReverse = Maps.newHashMap();
    private final List<Ritual> sortedRituals = Lists.newArrayList();
    private final Map<String, ImperfectRitual> imperfectRituals = Maps.newTreeMap();
    private final Map<ImperfectRitual, String> imperfectRitualsReverse = Maps.newHashMap();
    private final Configuration config;

    public RitualManager(Configuration config) {
        this.config = config;
    }

    public void discover(ASMDataTable dataTable) {
        Set data = dataTable.getAll(RitualRegister.class.getName());
        for (ASMDataTable.ASMData found : data) {
            try {
                Class<?> discoveredClass = Class.forName(found.getClassName());
                if (!Ritual.class.isAssignableFrom(discoveredClass)) {
                    throw new BadRitualException("Annotated class " + found.getClassName() + " does not inherit from " + Ritual.class.getName());
                }
                Class<Ritual> ritualClass = discoveredClass.asSubclass(Ritual.class);
                RitualRegister ritualRegister = ritualClass.getAnnotation(RitualRegister.class);
                String id = ritualRegister.value();
                Ritual ritual = ritualRegister.factory().newInstance().apply(ritualClass);
                if (ritual == null) {
                    BMLog.DEFAULT.error("Error creating ritual instance for {}.", id);
                    continue;
                }
                this.rituals.put(id, ritual);
                this.ritualsReverse.put(ritual, id);
                BMLog.DEBUG.info("Registered ritual {}", id);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        Set imperfectData = dataTable.getAll(RitualRegister.Imperfect.class.getName());
        for (ASMDataTable.ASMData found : imperfectData) {
            try {
                Class<?> discoveredClass = Class.forName(found.getClassName());
                if (!ImperfectRitual.class.isAssignableFrom(discoveredClass)) {
                    throw new BadRitualException("Annotated class " + found.getClassName() + " does not inherit from " + ImperfectRitual.class.getName());
                }
                Class<ImperfectRitual> ritualClass = discoveredClass.asSubclass(ImperfectRitual.class);
                RitualRegister.Imperfect ritualRegister = ritualClass.getAnnotation(RitualRegister.Imperfect.class);
                String id = ritualRegister.value();
                ImperfectRitual ritual = ritualRegister.factory().newInstance().apply(ritualClass);
                if (ritual == null) {
                    BMLog.DEFAULT.error("Error creating imperfect ritual instance for {}.", id);
                    continue;
                }
                this.imperfectRituals.put(id, ritual);
                this.imperfectRitualsReverse.put(ritual, id);
                BMLog.DEBUG.info("Registered imperfect ritual {}", id);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        this.syncConfig();
        this.sortedRituals.addAll(this.rituals.values());
        this.sortedRituals.sort((o1, o2) -> {
            HashSet components = Sets.newHashSet();
            o1.gatherComponents(components::add);
            int initialSize = components.size();
            components.clear();
            o2.gatherComponents(components::add);
            return Integer.compare(initialSize, components.size());
        });
    }

    public Ritual getRitual(String id) {
        return this.rituals.get(id);
    }

    public String getId(Ritual ritual) {
        return this.ritualsReverse.get(ritual);
    }

    public ImperfectRitual getImperfectRitual(IBlockState state) {
        for (ImperfectRitual ritual : this.imperfectRituals.values()) {
            if (!ritual.getBlockRequirement().test(state)) continue;
            return ritual;
        }
        return null;
    }

    public String getId(ImperfectRitual ritual) {
        return this.imperfectRitualsReverse.get(ritual);
    }

    public Collection<Ritual> getRituals() {
        return this.rituals.values();
    }

    public Collection<ImperfectRitual> getImperfectRituals() {
        return this.imperfectRituals.values();
    }

    public List<Ritual> getSortedRituals() {
        return this.sortedRituals;
    }

    public void syncConfig() {
        this.config.addCustomCategoryComment("rituals", "Toggles for all rituals");
        this.rituals.forEach((k, v) -> this.config.getBoolean(k, "rituals", true, "Enable the " + k + " ritual."));
        this.imperfectRituals.forEach((k, v) -> this.config.getBoolean(k, "rituals.imperfect", true, "Enable the " + k + " imperfect ritual."));
        this.config.save();
    }

    public boolean enabled(String id, boolean imperfect) {
        return id != null && this.config.getBoolean(id, "rituals" + (imperfect ? ".imperfect" : ""), true, "");
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static class BadRitualException
    extends RuntimeException {
        public BadRitualException(String message) {
            super(message);
        }
    }
}

