/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSprintAttack;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerSprintAttack
extends StatTracker {
    public static HashMap<LivingArmour, Double> changeMap = new HashMap();
    public static int[] damageRequired = new int[]{200, 800, 1300, 2500, 3800};
    public double totalDamageDealt = 0.0;

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.sprintAttack";
    }

    @Override
    public void resetTracker() {
        this.totalDamageDealt = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalDamageDealt = tag.func_74769_h("bloodmagic.tracker.sprintAttack");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("bloodmagic.tracker.sprintAttack", this.totalDamageDealt);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalDamageDealt += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0.0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 5; ++i) {
            if (!(this.totalDamageDealt >= (double)damageRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeSprintAttack(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalDamageDealt, damageRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.sprintAttack");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeSprintAttack && (level = upgrade.getUpgradeLevel()) < damageRequired.length) {
            this.totalDamageDealt = Math.max(this.totalDamageDealt, (double)damageRequired[level]);
            this.markDirty();
        }
    }

    public static void incrementCounter(LivingArmour armour, double damage) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + damage : damage);
    }
}

