/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeFallProtect;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerFallProtect
extends StatTracker {
    public static HashMap<LivingArmour, Double> changeMap = new HashMap();
    public static int[] damageRequired = new int[]{30, 200, 400, 800, 1500};
    public int totalDamage = 0;

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.fallProtect";
    }

    @Override
    public void resetTracker() {
        this.totalDamage = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalDamage = tag.func_74762_e("bloodmagic.tracker.fallProtect");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bloodmagic.tracker.fallProtect", this.totalDamage);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalDamage = (int)((double)this.totalDamage + Math.abs(changeMap.get(livingArmour)));
            changeMap.put(livingArmour, 0.0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 5; ++i) {
            if (this.totalDamage < damageRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeFallProtect(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalDamage, damageRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.fallProtect");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeFallProtect && (level = upgrade.getUpgradeLevel()) < damageRequired.length) {
            this.totalDamage = Math.max(this.totalDamage, damageRequired[level]);
            this.markDirty();
        }
    }

    public static void incrementCounter(LivingArmour armour, double damage) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + damage : damage);
    }
}

