/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeExperience;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerExperience
extends StatTracker {
    public static HashMap<LivingArmour, Integer> changeMap = new HashMap();
    public static int[] experienceRequired = new int[]{100, 400, 1000, 1600, 3200, 5000, 7000, 9200, 11500, 140000};
    public double totalExperienceGained = 0.0;

    @Override
    public String getUniqueIdentifier() {
        return "bloodmagic.tracker.experienced";
    }

    @Override
    public void resetTracker() {
        this.totalExperienceGained = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalExperienceGained = tag.func_74769_h("bloodmagic.tracker.experienced");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("bloodmagic.tracker.experienced", this.totalExperienceGained);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = (double)Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalExperienceGained += (double)Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (!(this.totalExperienceGained >= (double)experienceRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeExperience(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalExperienceGained, experienceRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("bloodmagic.upgrade.experienced");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeExperience && (level = upgrade.getUpgradeLevel()) < experienceRequired.length) {
            this.totalExperienceGained = Math.max(this.totalExperienceGained, (double)experienceRequired[level]);
            this.markDirty();
        }
    }

    public static void incrementCounter(LivingArmour armour, int exp) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + exp : exp);
    }
}

