/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.block.BlockRitualStone;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.item.ItemEnum;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInscriptionTool
extends ItemEnum.Variant<EnumRuneType>
implements IBindable {
    public ItemInscriptionTool() {
        super(EnumRuneType.class, "scribe");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (EnumRuneType runeType : (EnumRuneType[])this.types) {
            if (runeType == EnumRuneType.BLANK || !ConfigHandler.general.enableTierSixEvenThoughThereIsNoContent && runeType == EnumRuneType.DAWN) continue;
            ItemStack stack = new ItemStack((Item)this, 1, runeType.ordinal());
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("uses", 10);
            stack.func_77982_d(tag);
            list.add((Object)stack);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRitualStone && !((BlockRitualStone)state.func_177230_c()).isRuneType(world, pos, (EnumRuneType)this.getItemType(stack))) {
            stack = NBTHelper.checkNBT(stack);
            int uses = stack.func_77978_p().func_74762_e("uses");
            world.func_175656_a(pos, state.func_177226_a(((BlockRitualStone)state.func_177230_c()).getProperty(), this.getItemType(stack)));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77978_p().func_74768_a("uses", --uses);
                if (uses <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int uses = stack.func_77978_p().func_74762_e("uses");
        return 1.0 - (double)uses / 10.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int uses = stack.func_77978_p().func_74762_e("uses");
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)uses / 10.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect("tooltip.bloodmagic.inscriber.desc", new Object[0]))));
        if (!stack.func_77942_o()) {
            return;
        }
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentOwner", binding.getOwnerName()));
        }
    }
}

