/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.client.mesh.CustomMeshDefinitionActivatable;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.ItemBoundTool;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundPickaxe
extends ItemBoundTool
implements IMeshProvider {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150333_U, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U});

    public ItemBoundPickaxe() {
        super("pickaxe", 5.0f, EFFECTIVE_ON);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() == 3 : (blockIn != Blocks.field_150484_ah && blockIn != Blocks.field_150482_ag ? (blockIn != Blocks.field_150412_bA && blockIn != Blocks.field_150475_bE ? (blockIn != Blocks.field_150340_R && blockIn != Blocks.field_150352_o ? (blockIn != Blocks.field_150339_S && blockIn != Blocks.field_150366_p ? (blockIn != Blocks.field_150368_y && blockIn != Blocks.field_150369_x ? (blockIn != Blocks.field_150450_ax && blockIn != Blocks.field_150439_ay ? blockIn.func_185904_a() == Material.field_151576_e || blockIn.func_185904_a() == Material.field_151573_f || blockIn.func_185904_a() == Material.field_151574_g : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!this.getActivated(stack)) {
            return 1.0f;
        }
        return state.func_185904_a() != Material.field_151573_f && state.func_185904_a() != Material.field_151574_g && state.func_185904_a() != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    @Override
    protected void onBoundRelease(ItemStack stack, World world, EntityPlayer player, int charge) {
        if (world.field_72995_K) {
            return;
        }
        int fortuneLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int range = charge / 6;
        BlockPos playerPos = player.func_180425_c();
        for (int i = -range; i <= range; ++i) {
            for (int j = 0; j <= 2 * range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockEvent.BreakEvent event;
                    BlockPos blockPos = playerPos.func_177982_a(i, j, k);
                    IBlockState blockState = world.func_180495_p(blockPos);
                    if (world.func_175623_d(blockPos) || blockState.func_185904_a() != Material.field_151576_e && !EFFECTIVE_ON.contains(blockState.func_177230_c()) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, blockPos, blockState, player))) || event.getResult() == Event.Result.DENY) continue;
                    this.sharedHarvest(stack, world, player, blockPos, blockState, silkTouch, fortuneLvl);
                }
            }
        }
        NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, (int)((double)(charge * charge * charge) / 2.7)));
        world.func_72876_a((Entity)player, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 0.5f, false);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getActivated(stack) ? 5.0 : 2.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("bound_pickaxe");
    }

    @Override
    public void gatherVariants(Consumer<String> variants) {
        variants.accept("active=true");
        variants.accept("active=false");
    }
}

