/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class RenderConfiguration {
    private final String modid;
    private final String name;
    private final VertexFormat format;
    private final PrimitiveType primitiveType;
    private final RenderStateConfiguration configuration;

    public static RenderConfiguration create(String modid, String name, VertexFormat format, PrimitiveType primitive, RenderStateConfiguration renderStateConfiguration) {
        return new RenderConfiguration(modid, name, format, primitive, renderStateConfiguration);
    }

    private RenderConfiguration(String modid, String name, VertexFormat format, PrimitiveType primitive, RenderStateConfiguration configuration) {
        this.modid = modid;
        this.name = name;
        this.format = format;
        this.primitiveType = primitive;
        this.configuration = configuration;
    }

    public void setupState() {
        this.configuration.setup();
    }

    public void clearState() {
        this.configuration.clear();
    }

    public BufferBuilder begin() {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(this.primitiveType.glMode, this.format);
        return bufferBuilder;
    }

    public void end() {
        this.setupState();
        Tessellator.func_178181_a().func_78381_a();
        this.clearState();
    }

    public static enum PrimitiveType {
        LINES(1, 2, 2, false),
        LINE_STRIP(3, 2, 1, true),
        TRIANGLE_LINES(4, 2, 2, false),
        TRIANGLE_LINE_STRIP(5, 2, 1, true),
        TRIANGLES(4, 3, 3, false),
        TRIANGLE_STRIP(5, 3, 1, true),
        TRIANGLE_FAN(6, 3, 1, true),
        QUADS(7, 4, 4, false);

        private final int glMode;
        private final int vertexCount;
        private final int vertexOffset;
        private final boolean isConnected;

        private PrimitiveType(int glMode, int vertexCount, int vertexOffset, boolean isConnected) {
            this.glMode = glMode;
            this.vertexCount = vertexCount;
            this.vertexOffset = vertexOffset;
            this.isConnected = isConnected;
        }

        public int getGlMode() {
            return this.glMode;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getVertexOffset() {
            return this.vertexOffset;
        }

        public boolean isConnected() {
            return this.isConnected;
        }
    }
}

