/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.EditableBlockRenderLayer;
import com.supermartijn642.core.extensions.TileEntityRendererDispatcherExtension;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.gui.ContainerScreenManager;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    private final String modid;
    private final Set<ResourceLocation> models = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, Supplier<IBakedModel>> specialModels = new HashMap<ResourceLocation, Supplier<IBakedModel>>();
    private final List<Pair<Supplier<Stream<ModelResourceLocation>>, Function<IBakedModel, IBakedModel>>> modelOverwrites = new ArrayList<Pair<Supplier<Stream<ModelResourceLocation>>, Function<IBakedModel, IBakedModel>>>();
    private final Map<Class<?>, Supplier<Render<?>>> entityRenderers = new HashMap();
    private final List<Pair<Supplier<BaseBlockEntityType<?>>, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<Class<?>, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<?>>> classBlockEntityRenderers = new HashMap();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureAtlasSprites = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final List<Pair<Supplier<Item>, Supplier<TileEntityItemStackRenderer>>> customItemRenderers = new ArrayList<Pair<Supplier<Item>, Supplier<TileEntityItemStackRenderer>>>();
    private final List<Pair<Supplier<BaseContainerType<?>>, Function<Container, GuiContainer>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, BlockRenderLayer>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, BlockRenderLayer>>();
    private boolean passedModelRegistry;
    private boolean passedModelBake;
    private boolean passedClientSetup;
    private boolean passedTextureStitch;

    static void setItemCustomModelLocation(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(Registries.ITEMS.getIdentifier(item), "inventory"));
    }

    @Deprecated
    public static void registerAllSpecialModels(Consumer<ResourceLocation> consumer) {
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.handleModelRegistry(consumer));
    }

    @Deprecated
    public static void registerAllRenderers() {
        REGISTRATION_HELPER_MAP.values().forEach(ClientRegistrationHandler::registerRenderers);
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        String activeMod;
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String string = activeMod = Loader.instance().activeModContainer() == null ? null : Loader.instance().activeModContainer().getModId();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + Loader.instance().activeModContainer().getName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void handleModelBakeEvent(ModelBakeEvent e) {
                ClientRegistrationHandler.this.handleModelBakeEvent(e);
            }

            @SubscribeEvent
            public void handleTextureStitchEvent(TextureStitchEvent.Pre e) {
                ClientRegistrationHandler.this.handleTextureStitchEvent(e);
            }
        });
    }

    public void registerModel(ResourceLocation identifier) {
        if (this.passedModelRegistry) {
            throw new IllegalStateException("Cannot register new models after ModelRegistryEvent has been fired!");
        }
        if (this.models.contains(identifier)) {
            throw new RuntimeException("Duplicate model location '" + identifier + "'!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model location '" + identifier + "'!");
        }
        this.models.add(identifier);
    }

    public void registerModel(String namespace, String identifier) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModel(new ResourceLocation(namespace, identifier));
    }

    public void registerModel(String identifier) {
        this.registerModel(this.modid, identifier);
    }

    public void registerSpecialModel(String identifier, Supplier<IBakedModel> model) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new special models after ModelBakeEvent has been fired!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(this.modid, identifier);
        if (this.specialModels.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate special model entry '" + fullIdentifier + "'!");
        }
        this.specialModels.put(fullIdentifier, model);
    }

    public void registerSpecialModel(String identifier, IBakedModel model) {
        this.registerSpecialModel(identifier, () -> model);
    }

    public void registerModelOverwrite(ResourceLocation identifier, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model overwrite '" + identifier + "'!");
        }
        ModelResourceLocation modelIdentifier = identifier instanceof ModelResourceLocation ? (ModelResourceLocation)identifier : new ModelResourceLocation(identifier, "normal");
        this.modelOverwrites.add(Pair.of(() -> Stream.of(modelIdentifier), modelOverwrite));
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (!RegistryUtil.isValidPath(variant)) {
            throw new IllegalArgumentException("Variant '" + variant + "' must only contain characters [a-z0-9_./-]!");
        }
        ModelResourceLocation fullIdentifier = new ModelResourceLocation(namespace + ":" + identifier + "#" + variant);
        this.registerModelOverwrite((ResourceLocation)fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Supplier<IBakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<IBakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, IBakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (IBakedModel model) -> modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, IBakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (IBakedModel model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> ClientUtils.getMinecraft().field_175617_aL.func_174954_c().func_178120_a().func_188181_b((Block)block.get()).values().stream(), modelOverwrite));
        this.registerItemModelOverwrite(() -> Item.func_150898_a((Block)((Block)block.get())), modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<IBakedModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, IBakedModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (IBakedModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> Stream.of(new ModelResourceLocation(Registries.ITEMS.getIdentifier((Item)item.get()), "inventory")), modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<IBakedModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, IBakedModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (IBakedModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, Supplier<Render<? super T>> entityRenderer) {
        if (this.classBlockEntityRenderers.containsKey(entityClass)) {
            throw new RuntimeException("Duplicate block entity renderer for block entity class '" + entityClass.getCanonicalName() + "'!");
        }
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after item registry event has been fired!");
        }
        this.entityRenderers.put(entityClass, entityRenderer);
    }

    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, Render<? super T> entityRenderer) {
        this.registerEntityRenderer(entityClass, () -> entityRenderer);
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Class<T> entityClass, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<? super T>> blockEntityRenderer) {
        if (this.classBlockEntityRenderers.containsKey(entityClass)) {
            throw new RuntimeException("Duplicate block entity renderer for block entity class '" + entityClass.getCanonicalName() + "'!");
        }
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after item registry event has been fired!");
        }
        this.classBlockEntityRenderers.put(entityClass, blockEntityRenderer);
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Class<T> entityClass, Supplier<TileEntitySpecialRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityClass, (TileEntityRendererDispatcher context) -> (TileEntitySpecialRenderer)blockEntityRenderer.get());
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Class<T> entityClass, TileEntitySpecialRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityClass, (TileEntityRendererDispatcher context) -> blockEntityRenderer);
    }

    public <T extends TileEntity> void registerCustomBlockEntityRenderer(Class<T> entityClass, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityClass, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends TileEntity> void registerCustomBlockEntityRenderer(Class<T> entityClass, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityClass, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public <T extends BaseBlockEntity> void registerBlockEntityRenderer(Supplier<BaseBlockEntityType<T>> entityType, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<? super T>> blockEntityRenderer) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends BaseBlockEntity> void registerBlockEntityRenderer(Supplier<BaseBlockEntityType<T>> entityType, Supplier<TileEntitySpecialRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> (TileEntitySpecialRenderer)blockEntityRenderer.get());
    }

    public <T extends BaseBlockEntity> void registerBlockEntityRenderer(Supplier<BaseBlockEntityType<T>> entityType, TileEntitySpecialRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> blockEntityRenderer);
    }

    public <T extends BaseBlockEntity> void registerCustomBlockEntityRenderer(Supplier<BaseBlockEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends BaseBlockEntity> void registerCustomBlockEntityRenderer(Supplier<BaseBlockEntityType<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, ResourceLocation spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + spriteLocation + "' for atlas '" + textureAtlas + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, new ResourceLocation(this.modid, spriteLocation));
    }

    public void registerItemRenderer(Supplier<Item> item, Supplier<TileEntityItemStackRenderer> itemRenderer) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after item RegistryEvent has been fired!");
        }
        this.customItemRenderers.add(Pair.of(item, itemRenderer));
    }

    public void registerItemRenderer(Supplier<Item> item, TileEntityItemStackRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> itemRenderer);
    }

    public void registerItemRenderer(Item item, Supplier<TileEntityItemStackRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, itemRenderer);
    }

    public void registerItemRenderer(Item item, TileEntityItemStackRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> itemRenderer);
    }

    public void registerCustomItemRenderer(Supplier<Item> item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Supplier<Item> item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public void registerCustomItemRenderer(Item item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Item item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public <T extends Container, U extends GuiContainer> void registerContainerScreen(Supplier<BaseContainerType<T>> menuType, Function<T, U> screenSupplier) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends Container, U extends GuiContainer> void registerContainerScreen(BaseContainerType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public void registerBlockModelRenderType(Supplier<Block> block, BlockRenderLayer renderType) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderType));
    }

    public void registerBlockModelRenderType(Block block, BlockRenderLayer renderType) {
        this.registerBlockModelRenderType(() -> block, renderType);
    }

    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.SOLID);
    }

    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.SOLID);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.CUTOUT_MIPPED);
    }

    public void registerBlockModelCutoutMippedRenderType(Block block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.CUTOUT_MIPPED);
    }

    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.CUTOUT);
    }

    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.CUTOUT);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.TRANSLUCENT);
    }

    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, BlockRenderLayer.TRANSLUCENT);
    }

    private void handleModelRegistry(Consumer<ResourceLocation> consumer) {
        this.passedModelRegistry = true;
        for (ResourceLocation model : this.models) {
            consumer.accept(model);
        }
    }

    private void handleModelBakeEvent(ModelBakeEvent e) {
        Throwable model;
        this.passedModelBake = true;
        for (Map.Entry<ResourceLocation, Supplier<IBakedModel>> entry : this.specialModels.entrySet()) {
            ModelResourceLocation modelIdentifier;
            ResourceLocation identifier = entry.getKey();
            ModelResourceLocation modelResourceLocation = modelIdentifier = identifier instanceof ModelResourceLocation ? (ModelResourceLocation)identifier : new ModelResourceLocation(identifier.toString());
            if (e.getModelRegistry().func_82594_a((Object)modelIdentifier) != null) {
                throw new RuntimeException("Special model '" + identifier + "' is trying to overwrite another model!");
            }
            model = entry.getValue().get();
            if (model == null) {
                throw new RuntimeException("Got null object for special model '" + entry.getKey() + "'!");
            }
            e.getModelRegistry().func_82595_a((Object)modelIdentifier, (Object)model);
        }
        for (Pair pair : this.modelOverwrites) {
            List modelIdentifiers;
            model = null;
            try (Stream stream = (Stream)((Supplier)pair.left()).get();){
                modelIdentifiers = stream.collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                model = throwable;
                throw throwable;
            }
            for (ModelResourceLocation identifier : modelIdentifiers) {
                if (e.getModelRegistry().func_82594_a((Object)identifier) == null) {
                    throw new RuntimeException("No model registered for model overwrite '" + identifier + "'!");
                }
                IBakedModel model2 = (IBakedModel)e.getModelRegistry().func_82594_a((Object)identifier);
                model2 = (IBakedModel)((Function)pair.right()).apply(model2);
                if (model2 == null) {
                    throw new RuntimeException("Model overwrite for '" + identifier + "' returned a null model!");
                }
                e.getModelRegistry().func_82595_a((Object)identifier, (Object)model2);
            }
        }
    }

    private void registerRenderers() {
        this.passedClientSetup = true;
        for (Map.Entry<Class<?>, Supplier<Render<?>>> entry : this.entityRenderers.entrySet()) {
            Class<?> clazz = entry.getKey();
            Render<?> entityRenderer2 = entry.getValue().get();
            if (entityRenderer2 == null) {
                throw new RuntimeException("Got null entity renderer for entity class '" + clazz.getCanonicalName() + "!");
            }
            ClientUtils.getMinecraft().func_175598_ae().field_78729_o.put(clazz, entityRenderer2);
        }
        HashSet blockEntityTypes = new HashSet();
        for (Pair<Supplier<BaseBlockEntityType<?>>, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<?>>> pair : this.blockEntityRenderers) {
            BaseBlockEntityType<?> blockEntityType = pair.left().get();
            if (blockEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(blockEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType) + "'!");
            }
            TileEntitySpecialRenderer<?> tileEntitySpecialRenderer = pair.right().apply(TileEntityRendererDispatcher.field_147556_a);
            if (tileEntitySpecialRenderer == null) {
                throw new RuntimeException("Got null block entity renderer for block entity type '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType) + "'!");
            }
            blockEntityTypes.add(blockEntityType);
            ((TileEntityRendererDispatcherExtension)TileEntityRendererDispatcher.field_147556_a).coreLibRegisterRenderer(blockEntityType, tileEntitySpecialRenderer);
        }
        for (Map.Entry<Class<?>, Function<TileEntityRendererDispatcher, TileEntitySpecialRenderer<?>>> entry : this.classBlockEntityRenderers.entrySet()) {
            Class<?> blockEntityClass = entry.getKey();
            TileEntitySpecialRenderer<?> tileEntitySpecialRenderer = entry.getValue().apply(TileEntityRendererDispatcher.field_147556_a);
            if (tileEntitySpecialRenderer == null) {
                throw new RuntimeException("Got null block entity renderer for block entity class '" + blockEntityClass.getCanonicalName() + "'!");
            }
            ClientRegistry.bindTileEntitySpecialRenderer(blockEntityClass, tileEntitySpecialRenderer);
        }
        HashSet<Item> hashSet = new HashSet<Item>();
        for (Pair<Supplier<Item>, Supplier<TileEntityItemStackRenderer>> entry : this.customItemRenderers) {
            Item item = entry.left().get();
            if (item == null) {
                throw new RuntimeException("Custom item renderer registered with null item!");
            }
            if (hashSet.contains(item)) {
                throw new RuntimeException("Duplicate custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            if (item.getTileEntityItemStackRenderer() != TileEntityItemStackRenderer.field_147719_a) {
                throw new RuntimeException("Item '" + Registries.ITEMS.getIdentifier(item) + "' already has a custom item renderer set!");
            }
            TileEntityItemStackRenderer customRenderer = (TileEntityItemStackRenderer)((Supplier)entry.right()).get();
            if (customRenderer == null) {
                throw new RuntimeException("Got null custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            hashSet.add(item);
            item.setTileEntityItemStackRenderer(customRenderer);
        }
        HashSet<BaseContainerType> hashSet2 = new HashSet<BaseContainerType>();
        for (Pair pair : this.containerScreens) {
            BaseContainerType menuType = (BaseContainerType)((Supplier)pair.left()).get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (hashSet2.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + Registries.MENU_TYPES.getIdentifier(menuType) + "'!");
            }
            hashSet2.add(menuType);
            ContainerScreenManager.registerContainerScreen(menuType, (Function)pair.right());
        }
        HashSet<Block> blocks = new HashSet<Block>();
        for (Pair<Supplier<Block>, BlockRenderLayer> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (blocks.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            if (!(block instanceof EditableBlockRenderLayer)) {
                throw new RuntimeException("Block '" + Registries.BLOCKS.getIdentifier(block) + "' must implement EditableBlockRenderLayer to set it's render type!");
            }
            BlockRenderLayer renderType = entry.right();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            blocks.add(block);
            ((EditableBlockRenderLayer)block).setRenderLayer(renderType);
        }
    }

    private void handleTextureStitchEvent(TextureStitchEvent.Pre e) {
        this.passedTextureStitch = true;
        Set<ResourceLocation> sprites = this.textureAtlasSprites.entrySet().stream().filter(entry -> ClientUtils.getTextureManager().func_110581_b((ResourceLocation)entry.getKey()) == e.getMap()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        sprites.forEach(arg_0 -> ((TextureMap)e.getMap()).func_174942_a(arg_0));
    }
}

