/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelLoader.class})
public class ModelLoaderMixin {
    @Shadow(remap=false)
    @Final
    private Map<ModelResourceLocation, IModel> stateModels;
    @Shadow(remap=false)
    @Final
    private Map<ResourceLocation, Exception> loadingExceptions;
    private List<ResourceLocation> coreLibSpecialModels = new ArrayList<ResourceLocation>();

    @Inject(method={"setupModelRegistry"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/model/ModelLoader;loadVariantItemModels()V", shift=At.Shift.AFTER)})
    private void loadModelsInject(CallbackInfoReturnable<?> ci) {
        ModelLoader bakery = (ModelLoader)this;
        ClientRegistrationHandler.registerAllSpecialModels(this.coreLibSpecialModels::add);
        ArrayDeque modelsToBeLoaded = Queues.newArrayDeque(this.coreLibSpecialModels);
        HashSet loadedModels = Sets.newHashSet();
        for (ResourceLocation location : bakery.field_177611_h.keySet()) {
            loadedModels.add(location);
            bakery.func_188633_a((Deque)modelsToBeLoaded, (Set)loadedModels, (ModelBlock)bakery.field_177611_h.get(location));
        }
        while (!modelsToBeLoaded.isEmpty()) {
            ResourceLocation modelLocation = (ResourceLocation)modelsToBeLoaded.pop();
            try {
                if (bakery.field_177611_h.get(modelLocation) != null) continue;
                ModelBlock modelBlock = bakery.func_177594_c(new ResourceLocation(modelLocation.func_110624_b(), "models/" + modelLocation.func_110623_a()));
                bakery.field_177611_h.put(modelLocation, modelBlock);
                bakery.func_188633_a((Deque)modelsToBeLoaded, (Set)loadedModels, modelBlock);
            }
            catch (Exception exception) {
                ModelBakery.field_177603_c.warn("In parent chain: {}; unable to load model: '{}'", (Object)ModelBakery.field_177601_e.join((Iterable)bakery.func_177573_e(modelLocation)), (Object)modelLocation, (Object)exception);
            }
            loadedModels.add(modelLocation);
        }
    }

    @Inject(method={"setupModelRegistry"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/model/ModelLoader;loadVariantItemModels()V", shift=At.Shift.AFTER)})
    private void bakeModelsInject(CallbackInfoReturnable<?> ci) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        for (ResourceLocation modelLocation : this.coreLibSpecialModels) {
            IModel model;
            try {
                model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            }
            catch (Exception e) {
                this.loadingExceptions.put(modelLocation, e);
                Method getMissingModel = ModelLoaderRegistry.class.getDeclaredMethod("getMissingModel", ResourceLocation.class, Throwable.class);
                getMissingModel.setAccessible(true);
                model = (IModel)getMissingModel.invoke(null, modelLocation, e);
            }
            this.stateModels.put(new ModelResourceLocation(modelLocation, ""), model);
        }
    }
}

