/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.loot_table.BinomialNumberProvider;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LootPool.Serializer.class})
public class LootPoolSerializerMixin {
    @Inject(method={"deserialize"}, at={@At(value="HEAD")}, cancellable=true)
    private void deserialize(JsonElement json, Type type, JsonDeserializationContext context, CallbackInfoReturnable<LootPool> ci) {
        boolean hasBinomialBonusRolls;
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"loot pool");
        boolean hasBinomialRolls = jsonObject.has("rolls") && jsonObject.get("rolls").isJsonObject() && jsonObject.getAsJsonObject("rolls").has("type") && jsonObject.getAsJsonObject("rolls").get("type").isJsonPrimitive() && jsonObject.getAsJsonObject("rolls").getAsJsonPrimitive("type").isString() && jsonObject.getAsJsonObject("rolls").get("type").getAsString().equals("supermartijn642corelib:binomial");
        boolean bl = hasBinomialBonusRolls = jsonObject.has("bonus_rolls") && jsonObject.get("bonus_rolls").isJsonObject() && jsonObject.getAsJsonObject("bonus_rolls").has("type") && jsonObject.getAsJsonObject("bonus_rolls").get("type").isJsonPrimitive() && jsonObject.getAsJsonObject("bonus_rolls").getAsJsonPrimitive("type").isString() && jsonObject.getAsJsonObject("bonus_rolls").get("type").getAsString().equals("supermartijn642corelib:binomial");
        if (hasBinomialRolls || hasBinomialBonusRolls) {
            String name = ForgeHooks.readPoolName((JsonObject)jsonObject);
            LootEntry[] entries = (LootEntry[])JsonUtils.func_188174_a((JsonObject)jsonObject, (String)"entries", (JsonDeserializationContext)context, LootEntry[].class);
            LootCondition[] conditions = (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonObject, (String)"conditions", (Object)new LootCondition[0], (JsonDeserializationContext)context, LootCondition[].class);
            BinomialNumberProvider rolls = hasBinomialRolls ? new BinomialNumberProvider(JsonUtils.func_151215_f((JsonElement)jsonObject.get("rolls"), (String)"n"), JsonUtils.func_151215_f((JsonElement)jsonObject.get("rolls"), (String)"p")) : (RandomValueRange)JsonUtils.func_188174_a((JsonObject)jsonObject, (String)"rolls", (JsonDeserializationContext)context, RandomValueRange.class);
            BinomialNumberProvider bonus_rolls = hasBinomialBonusRolls ? new BinomialNumberProvider(JsonUtils.func_151215_f((JsonElement)jsonObject.get("bonus_rolls"), (String)"n"), JsonUtils.func_151215_f((JsonElement)jsonObject.get("bonus_rolls"), (String)"p")) : (RandomValueRange)JsonUtils.func_188174_a((JsonObject)jsonObject, (String)"bonus_rolls", (JsonDeserializationContext)context, RandomValueRange.class);
            ci.setReturnValue(new LootPool(entries, conditions, (RandomValueRange)rolls, (RandomValueRange)bonus_rolls, name));
        }
    }
}

