/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.loot_table.BinomialNumberProvider;
import com.supermartijn642.core.loot_table.SurvivesExplosionLootCondition;
import com.supermartijn642.core.loot_table.ToolMatchLootCondition;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;

public abstract class LootTableGenerator
extends ResourceGenerator {
    private static final Gson GSON = LootTableManager.field_186526_b;
    private final Map<ResourceLocation, LootTableBuilder> lootTables = new HashMap<ResourceLocation, LootTableBuilder>();

    public LootTableGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (LootTableBuilder lootTableBuilder : this.lootTables.values()) {
            JsonObject json = new JsonObject();
            if (!lootTableBuilder.functions.isEmpty()) {
                JsonArray functionsJson = new JsonArray();
                for (LootFunction function : lootTableBuilder.functions) {
                    functionsJson.add(GSON.toJsonTree((Object)function));
                }
                json.add("functions", (JsonElement)functionsJson);
            }
            int poolNameCounter = 1;
            if (!lootTableBuilder.pools.isEmpty()) {
                JsonArray poolsJson = new JsonArray();
                for (LootPoolBuilder pool : lootTableBuilder.pools) {
                    JsonObject rollsJson;
                    JsonObject poolJson = new JsonObject();
                    poolJson.addProperty("name", pool.name == null || pool.name.isEmpty() ? "pool" + poolNameCounter++ : pool.name);
                    if (pool.rolls instanceof BinomialNumberProvider) {
                        rollsJson = new JsonObject();
                        rollsJson.addProperty("type", "supermartijn642corelib:binomial");
                        rollsJson.addProperty("n", (Number)((BinomialNumberProvider)pool.rolls).getN());
                        rollsJson.addProperty("p", (Number)Float.valueOf(((BinomialNumberProvider)pool.rolls).getP()));
                        poolJson.add("rolls", (JsonElement)rollsJson);
                    } else {
                        poolJson.add("rolls", GSON.toJsonTree((Object)pool.rolls));
                    }
                    if (pool.bonusRolls instanceof BinomialNumberProvider) {
                        rollsJson = new JsonObject();
                        rollsJson.addProperty("type", "supermartijn642corelib:binomial");
                        rollsJson.addProperty("n", (Number)((BinomialNumberProvider)pool.bonusRolls).getN());
                        rollsJson.addProperty("p", (Number)Float.valueOf(((BinomialNumberProvider)pool.bonusRolls).getP()));
                        poolJson.add("bonus_rolls", (JsonElement)rollsJson);
                    } else if (pool.bonusRolls.func_186509_a() != 0.0f || pool.bonusRolls.func_186512_b() != 0.0f) {
                        poolJson.add("bonus_rolls", GSON.toJsonTree((Object)pool.bonusRolls));
                    }
                    if (!pool.conditions.isEmpty()) {
                        JsonArray conditionsJson = new JsonArray();
                        for (LootCondition condition : pool.conditions) {
                            conditionsJson.add(GSON.toJsonTree((Object)condition));
                        }
                        poolJson.add("conditions", (JsonElement)conditionsJson);
                    }
                    if (!pool.functions.isEmpty()) {
                        JsonArray functionsJson = new JsonArray();
                        for (LootFunction function : pool.functions) {
                            functionsJson.add(GSON.toJsonTree((Object)function));
                        }
                        poolJson.add("functions", (JsonElement)functionsJson);
                    }
                    if (pool.entries.isEmpty()) {
                        throw new RuntimeException("Loot table '" + lootTableBuilder.identifier + "' has loot pool without any entries!");
                    }
                    JsonArray entriesJson = new JsonArray();
                    for (LootEntry entry : pool.entries) {
                        entriesJson.add(GSON.toJsonTree((Object)entry));
                    }
                    poolJson.add("entries", (JsonElement)entriesJson);
                    poolsJson.add((JsonElement)poolJson);
                }
                json.add("pools", (JsonElement)poolsJson);
            }
            ResourceLocation identifier = lootTableBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.ASSET, json, identifier.func_110624_b(), "loot_tables", identifier.func_110623_a());
        }
    }

    protected LootTableBuilder lootTable(ResourceLocation identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, identifier.func_110624_b(), "loot_tables", identifier.func_110623_a(), ".json");
        return this.lootTables.computeIfAbsent(identifier, LootTableBuilder::new);
    }

    protected LootTableBuilder lootTable(String namespace, String path) {
        return this.lootTable(new ResourceLocation(namespace, path));
    }

    protected LootTableBuilder lootTable(Block block) {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(block);
        return this.lootTable(new ResourceLocation(identifier.func_110624_b(), "blocks/" + identifier.func_110623_a()));
    }

    protected LootTableBuilder dropSelf(Block block) {
        return this.lootTable(block).pool(poolBuilder -> poolBuilder.survivesExplosionCondition().itemEntry(block));
    }

    protected LootTableBuilder dropSelfWhenSilkTouch(Block block) {
        return this.lootTable(block).pool(poolBuilder -> poolBuilder.hasEnchantmentCondition(Enchantments.field_185306_r).itemEntry(block));
    }

    @Override
    public String getName() {
        return this.modName + " Loot Table Generator";
    }

    public static class LootPoolBuilder {
        private final List<LootCondition> conditions = new ArrayList<LootCondition>();
        private final List<LootFunction> functions = new ArrayList<LootFunction>();
        private final List<LootEntry> entries = new ArrayList<LootEntry>();
        private RandomValueRange rolls = new RandomValueRange(1.0f);
        private RandomValueRange bonusRolls = new RandomValueRange(0.0f);
        private String name;

        protected LootPoolBuilder() {
        }

        public LootPoolBuilder rolls(RandomValueRange provider) {
            this.rolls = provider;
            return this;
        }

        public LootPoolBuilder constantRolls(int rolls) {
            return this.rolls(new RandomValueRange((float)rolls));
        }

        public LootPoolBuilder uniformRolls(int min, int max) {
            return this.rolls(new RandomValueRange((float)min, (float)max));
        }

        public LootPoolBuilder binomialRolls(int n, int p) {
            return this.rolls(new BinomialNumberProvider(n, p));
        }

        public LootPoolBuilder bonusRolls(RandomValueRange provider) {
            this.bonusRolls = provider;
            return this;
        }

        public LootPoolBuilder constantBonusRolls(int rolls) {
            return this.bonusRolls(new RandomValueRange((float)rolls));
        }

        public LootPoolBuilder uniformBonusRolls(int min, int max) {
            return this.bonusRolls(new RandomValueRange((float)min, (float)max));
        }

        public LootPoolBuilder binomialBonusRolls(int n, int p) {
            return this.bonusRolls(new BinomialNumberProvider(n, p));
        }

        public LootPoolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LootPoolBuilder condition(LootCondition condition) {
            if (!LootConditionManager.field_186643_b.containsKey(condition.getClass())) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool condition '" + condition + "'!");
            }
            this.conditions.add(condition);
            return this;
        }

        public LootPoolBuilder survivesExplosionCondition() {
            return this.condition(new SurvivesExplosionLootCondition());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel, int maxLevel) {
            EnchantmentPredicate enchantmentPredicate = new EnchantmentPredicate(enchantment, new MinMaxBounds(Float.valueOf(minLevel), Float.valueOf(maxLevel)));
            ItemPredicate itemPredicate = new ItemPredicate(null, null, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[]{enchantmentPredicate}, null, NBTPredicate.field_193479_a);
            return this.condition(new ToolMatchLootCondition(itemPredicate));
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel) {
            EnchantmentPredicate enchantmentPredicate = new EnchantmentPredicate(enchantment, new MinMaxBounds(Float.valueOf(minLevel), null));
            ItemPredicate itemPredicate = new ItemPredicate(null, null, MinMaxBounds.field_192516_a, MinMaxBounds.field_192516_a, new EnchantmentPredicate[]{enchantmentPredicate}, null, NBTPredicate.field_193479_a);
            return this.condition(new ToolMatchLootCondition(itemPredicate));
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment) {
            return this.hasEnchantmentCondition(enchantment, 1);
        }

        public LootPoolBuilder entry(LootEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public LootPoolBuilder emptyEntry(int weight) {
            return this.entry((LootEntry)new LootEntryEmpty(weight, 0, new LootCondition[0], null));
        }

        public LootPoolBuilder emptyEntry() {
            return this.emptyEntry(1);
        }

        public LootPoolBuilder itemEntry(Item item, int weight) {
            return this.entry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[0], new LootCondition[0], null));
        }

        public LootPoolBuilder itemEntry(Block block, int weight) {
            return this.itemEntry(Item.func_150898_a((Block)block), weight);
        }

        public LootPoolBuilder itemEntry(Item item) {
            return this.itemEntry(item, 1);
        }

        public LootPoolBuilder itemEntry(Block block) {
            return this.itemEntry(Item.func_150898_a((Block)block), 1);
        }

        public LootPoolBuilder itemEntry(Item item, int count, int weight) {
            return this.entry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange((float)count))}, new LootCondition[0], null));
        }

        public LootPoolBuilder itemEntry(Block block, int count, int weight) {
            return this.itemEntry(Item.func_150898_a((Block)block), count, weight);
        }

        public LootPoolBuilder itemEntry(Item item, int min, int max, int weight) {
            return this.entry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max))}, new LootCondition[0], null));
        }

        public LootPoolBuilder itemEntry(Block block, int min, int max, int weight) {
            return this.itemEntry(Item.func_150898_a((Block)block), min, max, weight);
        }

        public LootPoolBuilder enchantedItemEntry(Item item, int levels, boolean allowCurses, int weight) {
            EnchantWithLevels function = new EnchantWithLevels(new LootCondition[0], new RandomValueRange((float)levels), allowCurses);
            return this.entry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{function}, new LootCondition[0], null));
        }

        public LootPoolBuilder enchantedItemEntry(Block block, int levels, boolean allowCurses, int weight) {
            return this.enchantedItemEntry(Item.func_150898_a((Block)block), levels, allowCurses, weight);
        }

        public LootPoolBuilder enchantedItemEntry(Item item, int minLevels, int maxLevels, boolean allowCurses, int weight) {
            EnchantWithLevels function = new EnchantWithLevels(new LootCondition[0], new RandomValueRange((float)minLevels, (float)maxLevels), allowCurses);
            return this.entry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{function}, new LootCondition[0], null));
        }

        public LootPoolBuilder enchantedItemEntry(Block block, int minLevels, int maxLevels, boolean allowCurses, int weight) {
            return this.enchantedItemEntry(Item.func_150898_a((Block)block), minLevels, maxLevels, allowCurses, weight);
        }

        public LootPoolBuilder itemEntry(ResourceLocation item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + item + "'!");
            }
            return this.itemEntry(Registries.ITEMS.getValue(item));
        }

        public LootPoolBuilder itemEntry(String namespace, String identifier) {
            return this.itemEntry(new ResourceLocation(namespace, identifier));
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable, int weight) {
            return this.entry((LootEntry)new LootEntryTable(lootTable, weight, 0, new LootCondition[0], null));
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable) {
            return this.lootTableEntry(lootTable, 1);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path, int weight) {
            return this.lootTableEntry(new ResourceLocation(namespace, path), weight);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path) {
            return this.lootTableEntry(new ResourceLocation(namespace, path));
        }

        public LootPoolBuilder function(LootFunction function) {
            if (!LootFunctionManager.field_186585_b.containsKey(function.getClass())) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }

    public static class LootTableBuilder {
        protected final ResourceLocation identifier;
        private final List<LootPoolBuilder> pools = new ArrayList<LootPoolBuilder>();
        private final List<LootFunction> functions = new ArrayList<LootFunction>();

        protected LootTableBuilder(ResourceLocation identifier) {
            this.identifier = identifier;
        }

        public LootTableBuilder pool(Consumer<LootPoolBuilder> poolBuilderConsumer) {
            LootPoolBuilder poolBuilder = new LootPoolBuilder();
            poolBuilderConsumer.accept(poolBuilder);
            this.pools.add(poolBuilder);
            return this;
        }

        public LootTableBuilder function(LootFunction function) {
            if (!LootFunctionManager.field_186585_b.containsKey(function.getClass())) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }
}

