/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class BlockShape {
    private final List<AxisAlignedBB> boxes;
    private final AxisAlignedBB simplified;

    public static BlockShape create(AxisAlignedBB box) {
        return new BlockShape(box);
    }

    public static BlockShape create(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
    }

    public static BlockShape createBlockShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BlockShape.create(new AxisAlignedBB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0));
    }

    public static BlockShape or(BlockShape shape, BlockShape ... shapes) {
        LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>(shape.boxes);
        Arrays.stream(shapes).forEach(box -> boxes.addAll(box.boxes));
        return new BlockShape(boxes);
    }

    public static BlockShape fullCube() {
        return new BlockShape(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public static BlockShape empty() {
        return new BlockShape();
    }

    public static boolean intersects(BlockShape shape1, BlockShape shape2) {
        return shape1.intersects(shape2);
    }

    public BlockShape(List<AxisAlignedBB> shapes) {
        if (shapes == null) {
            shapes = Collections.emptyList();
        }
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>(shapes.size());
        block0: for (int i = 0; i < shapes.size(); ++i) {
            AxisAlignedBB shape1 = (AxisAlignedBB)shapes.get(i);
            if (shape1.field_72336_d - shape1.field_72340_a == 0.0 || shape1.field_72337_e - shape1.field_72338_b == 0.0 || shape1.field_72334_f - shape1.field_72339_c == 0.0) continue;
            for (AxisAlignedBB shape2 : boxes) {
                if (!(shape1.field_72340_a >= shape2.field_72340_a) || !(shape1.field_72338_b >= shape2.field_72338_b) || !(shape1.field_72339_c >= shape2.field_72339_c) || !(shape1.field_72336_d <= shape2.field_72336_d) || !(shape1.field_72337_e <= shape2.field_72337_e) || !(shape1.field_72334_f <= shape2.field_72334_f)) continue;
                continue block0;
            }
            for (int j = i + 1; j < shapes.size(); ++j) {
                AxisAlignedBB shape2;
                shape2 = (AxisAlignedBB)shapes.get(j);
                if (shape1.field_72340_a >= shape2.field_72340_a && shape1.field_72338_b >= shape2.field_72338_b && shape1.field_72339_c >= shape2.field_72339_c && shape1.field_72336_d <= shape2.field_72336_d && shape1.field_72337_e <= shape2.field_72337_e && shape1.field_72334_f <= shape2.field_72334_f) continue block0;
            }
            boxes.add(shape1);
        }
        this.boxes = Collections.unmodifiableList(boxes);
        if (this.boxes.isEmpty()) {
            this.simplified = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            double minX = 2.147483647E9;
            double minY = 2.147483647E9;
            double minZ = 2.147483647E9;
            double maxX = -2.147483648E9;
            double maxY = -2.147483648E9;
            double maxZ = -2.147483648E9;
            for (AxisAlignedBB box : this.boxes) {
                if (box.field_72340_a < minX) {
                    minX = box.field_72340_a;
                }
                if (box.field_72338_b < minY) {
                    minY = box.field_72338_b;
                }
                if (box.field_72339_c < minZ) {
                    minZ = box.field_72339_c;
                }
                if (box.field_72336_d > maxX) {
                    maxX = box.field_72336_d;
                }
                if (box.field_72337_e > maxY) {
                    maxY = box.field_72337_e;
                }
                if (!(box.field_72334_f > maxZ)) continue;
                maxZ = box.field_72334_f;
            }
            this.simplified = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public BlockShape(AxisAlignedBB shape) {
        this(Collections.singletonList(shape));
    }

    public BlockShape() {
        this((List<AxisAlignedBB>)null);
    }

    public List<AxisAlignedBB> toBoxes() {
        return this.boxes;
    }

    public void forEachBox(Consumer<AxisAlignedBB> action) {
        this.boxes.forEach(action);
    }

    public void forEachEdge(LineConsumer action) {
        this.forEachBox(box -> {
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72334_f);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f);
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72339_c);
            action.apply(box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            action.apply(box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f);
            action.apply(box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f);
        });
    }

    public void forEachCorner(PointConsumer action) {
        this.forEachBox(box -> {
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72339_c);
            action.apply(box.field_72340_a, box.field_72338_b, box.field_72334_f);
            action.apply(box.field_72336_d, box.field_72338_b, box.field_72334_f);
            action.apply(box.field_72340_a, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72336_d, box.field_72337_e, box.field_72339_c);
            action.apply(box.field_72340_a, box.field_72337_e, box.field_72334_f);
            action.apply(box.field_72336_d, box.field_72337_e, box.field_72334_f);
        });
    }

    public AxisAlignedBB simplify() {
        return this.simplified;
    }

    public double getStart(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? this.minX() : (axis == EnumFacing.Axis.Y ? this.minY() : (axis == EnumFacing.Axis.Z ? this.minZ() : 0.0));
    }

    public double getEnd(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? this.minX() : (axis == EnumFacing.Axis.Y ? this.minY() : (axis == EnumFacing.Axis.Z ? this.minZ() : 0.0));
    }

    public double minX() {
        return this.simplified.field_72340_a;
    }

    public double minY() {
        return this.simplified.field_72338_b;
    }

    public double minZ() {
        return this.simplified.field_72339_c;
    }

    public double maxX() {
        return this.simplified.field_72336_d;
    }

    public double maxY() {
        return this.simplified.field_72337_e;
    }

    public double maxZ() {
        return this.simplified.field_72334_f;
    }

    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    public BlockShape offset(double x, double y, double z) {
        return this.transformBoxes(box -> box.func_72317_d(x, y, z));
    }

    public BlockShape offset(BlockPos pos) {
        return this.transformBoxes(box -> box.func_186670_a(pos));
    }

    public BlockShape offset(EnumFacing facing) {
        return this.offset(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
    }

    public boolean intersects(BlockShape shape) {
        if (this.isEmpty() || shape.isEmpty()) {
            return false;
        }
        return this.maxX() > shape.minX() && this.minX() < shape.maxX() && this.maxY() > shape.minY() && this.minY() < shape.maxY() && this.maxZ() > shape.minZ() && this.minZ() < shape.maxZ();
    }

    public BlockShape grow(double amount) {
        return this.transformBoxes(box -> box.func_186662_g(amount));
    }

    public BlockShape shrink(double amount) {
        return this.transformBoxes(box -> box.func_186664_h(amount));
    }

    public BlockShape flip(EnumFacing.Axis axis) {
        return this.transformBoxes(box -> new AxisAlignedBB(axis == EnumFacing.Axis.X ? 1.0 - box.field_72340_a : box.field_72340_a, axis == EnumFacing.Axis.Y ? 1.0 - box.field_72338_b : box.field_72338_b, axis == EnumFacing.Axis.Z ? 1.0 - box.field_72339_c : box.field_72339_c, axis == EnumFacing.Axis.X ? 1.0 - box.field_72336_d : box.field_72336_d, axis == EnumFacing.Axis.Y ? 1.0 - box.field_72337_e : box.field_72337_e, axis == EnumFacing.Axis.Z ? 1.0 - box.field_72334_f : box.field_72334_f));
    }

    public BlockShape rotate(EnumFacing.Axis axis) {
        if (axis == null) {
            throw new IllegalArgumentException("axis must not be null!");
        }
        if (axis == EnumFacing.Axis.X) {
            return this.transformBoxes(box -> new AxisAlignedBB(box.field_72340_a, box.field_72339_c, -box.field_72338_b + 1.0, box.field_72336_d, box.field_72334_f, -box.field_72337_e + 1.0));
        }
        if (axis == EnumFacing.Axis.Y) {
            return this.transformBoxes(box -> new AxisAlignedBB(-box.field_72339_c + 1.0, box.field_72338_b, box.field_72340_a, -box.field_72334_f + 1.0, box.field_72337_e, box.field_72336_d));
        }
        if (axis == EnumFacing.Axis.Z) {
            return this.transformBoxes(box -> new AxisAlignedBB(box.field_72338_b, -box.field_72340_a + 1.0, box.field_72339_c, box.field_72337_e, -box.field_72336_d + 1.0, box.field_72334_f));
        }
        return null;
    }

    private BlockShape transformBoxes(Function<AxisAlignedBB, AxisAlignedBB> transformer) {
        return new BlockShape(this.toBoxes().stream().map(transformer::apply).collect(Collectors.toList()));
    }

    public static interface PointConsumer {
        public void apply(double var1, double var3, double var5);
    }

    public static interface LineConsumer {
        public void apply(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

