/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.google.common.collect.ImmutableSet;
import com.supermartijn642.core.block.BaseBlockEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public final class BaseBlockEntityType<T extends BaseBlockEntity> {
    private final Supplier<T> entitySupplier;
    private final Set<Block> validBlocks;
    final Set<Class<?>> blockEntityClasses = new HashSet();

    public static <T extends BaseBlockEntity> BaseBlockEntityType<T> create(Supplier<T> entitySupplier, Block ... validBlocks) {
        return new BaseBlockEntityType<T>(entitySupplier, (Set<Block>)ImmutableSet.copyOf((Object[])validBlocks));
    }

    private BaseBlockEntityType(Supplier<T> entitySupplier, Set<Block> validBlocks) {
        this.entitySupplier = entitySupplier;
        this.validBlocks = validBlocks;
    }

    public boolean isValid(IBlockState state) {
        return this.validBlocks.contains(state.func_177230_c());
    }

    public T createBlockEntity() {
        BaseBlockEntity entity = (BaseBlockEntity)((Object)this.entitySupplier.get());
        this.blockEntityClasses.add(((Object)((Object)entity)).getClass());
        return (T)((Object)((BaseBlockEntity)((Object)this.entitySupplier.get())));
    }

    @Deprecated
    public boolean containsClass(Class<?> clazz) {
        return this.blockEntityClasses.contains(clazz);
    }
}

