/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class SpellProperties {
    private static final Gson gson = new Gson();
    private final Map<Context, Boolean> enabledContexts;
    private final Map<String, Number> baseValues;
    public final Tier tier;
    public final Element element;
    public final SpellType type;
    public final int cost;
    public final int chargeup;
    public final int cooldown;

    private SpellProperties(JsonObject json, Spell spell) {
        String[] baseValueNames = spell.getPropertyKeys();
        this.enabledContexts = new EnumMap<Context, Boolean>(Context.class);
        this.baseValues = new HashMap<String, Number>();
        JsonObject enabled = JsonUtils.func_152754_s((JsonObject)json, (String)"enabled");
        for (Context context : Context.values()) {
            this.enabledContexts.put(context, JsonUtils.func_151212_i((JsonObject)enabled, (String)context.name));
        }
        try {
            this.tier = Tier.fromName(JsonUtils.func_151200_h((JsonObject)json, (String)"tier"));
            this.element = Element.fromName(JsonUtils.func_151200_h((JsonObject)json, (String)"element"));
            this.type = SpellType.fromName(JsonUtils.func_151200_h((JsonObject)json, (String)"type"));
        }
        catch (IllegalArgumentException e) {
            throw new JsonSyntaxException("Incorrect spell property value", (Throwable)e);
        }
        this.cost = JsonUtils.func_151203_m((JsonObject)json, (String)"cost");
        this.chargeup = JsonUtils.func_151203_m((JsonObject)json, (String)"chargeup");
        this.cooldown = JsonUtils.func_151203_m((JsonObject)json, (String)"cooldown");
        JsonObject baseValueObject = JsonUtils.func_152754_s((JsonObject)json, (String)"base_properties");
        int redundantKeys = baseValueObject.size() - baseValueNames.length;
        if (redundantKeys > 0) {
            Wizardry.logger.warn("Spell " + spell.getRegistryName() + " has " + redundantKeys + " redundant spell property key(s) defined in its JSON file. Extra values will have no effect! (Modders: make sure you have called addProperties(...) during spell construction)");
        }
        if (baseValueNames.length > 0) {
            for (String baseValueName : baseValueNames) {
                this.baseValues.put(baseValueName, Float.valueOf(JsonUtils.func_151217_k((JsonObject)baseValueObject, (String)baseValueName)));
            }
        }
    }

    public SpellProperties(Spell spell, ByteBuf buf) {
        this.enabledContexts = new EnumMap<Context, Boolean>(Context.class);
        this.baseValues = new HashMap<String, Number>();
        for (Context context : Context.values()) {
            this.enabledContexts.put(context, buf.readBoolean());
        }
        this.tier = Tier.values()[buf.readShort()];
        this.element = Element.values()[buf.readShort()];
        this.type = SpellType.values()[buf.readShort()];
        this.cost = buf.readInt();
        this.chargeup = buf.readInt();
        this.cooldown = buf.readInt();
        List<String> keys = Arrays.asList(spell.getPropertyKeys());
        Collections.sort(keys);
        for (String key : keys) {
            this.baseValues.put(key, Float.valueOf(buf.readFloat()));
        }
    }

    public void write(ByteBuf buf) {
        for (Context context : Context.values()) {
            buf.writeBoolean(this.enabledContexts.get((Object)context).booleanValue());
        }
        buf.writeShort(this.tier.ordinal());
        buf.writeShort(this.element.ordinal());
        buf.writeShort(this.type.ordinal());
        buf.writeInt(this.cost);
        buf.writeInt(this.chargeup);
        buf.writeInt(this.cooldown);
        ArrayList<String> keys = new ArrayList<String>(this.baseValues.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            buf.writeFloat(this.baseValues.get(key).floatValue());
        }
    }

    public boolean isEnabled(Context ... contexts) {
        return this.enabledContexts.entrySet().stream().anyMatch(e -> (Boolean)e.getValue() != false && Arrays.asList(contexts).contains(e.getKey()));
    }

    public boolean hasBaseValue(String identifier) {
        return this.baseValues.containsKey(identifier);
    }

    public Number getBaseValue(String identifier) {
        if (!this.baseValues.containsKey(identifier)) {
            throw new IllegalArgumentException("Base value with identifier '" + identifier + "' is not defined.");
        }
        return this.baseValues.get(identifier);
    }

    public static void init() {
        Set modIDs = Spell.getAllSpells().stream().map(s -> s.getRegistryName().func_110624_b()).collect(Collectors.toSet());
        boolean flag = SpellProperties.loadConfigSpellProperties();
        for (String modID : modIDs) {
            flag &= SpellProperties.loadBuiltInSpellProperties(modID);
        }
        if (!flag) {
            Wizardry.logger.warn("Some spell property files did not load correctly; this will likely cause problems later!");
        }
    }

    public static void loadWorldSpecificSpellProperties(World world) {
        Wizardry.logger.info("Loading custom spell properties for world {}", (Object)world.func_72912_H().func_76065_j());
        File spellJSONDir = new File(new File(world.func_72860_G().func_75765_b(), "data"), "spells");
        if (spellJSONDir.mkdirs()) {
            return;
        }
        if (!SpellProperties.loadSpellPropertiesFromDir(spellJSONDir)) {
            Wizardry.logger.warn("Some spell property files did not load correctly; this will likely cause problems later!");
        }
    }

    private static boolean loadConfigSpellProperties() {
        Wizardry.logger.info("Loading spell properties from config folder");
        File spellJSONDir = new File(Wizardry.configDirectory, "spells");
        if (!spellJSONDir.exists()) {
            return true;
        }
        return SpellProperties.loadSpellPropertiesFromDir(spellJSONDir);
    }

    private static boolean loadBuiltInSpellProperties(String modID) {
        ModContainer mod = Loader.instance().getModList().stream().filter(m -> m.getModId().equals(modID)).findFirst().orElse(null);
        if (mod == null) {
            Wizardry.logger.warn("Tried to load built-in spell properties for mod with ID '" + modID + "', but no such mod was loaded");
            return false;
        }
        List<Spell> spells = Spell.getSpells(s -> s.getRegistryName().func_110624_b().equals(modID));
        if (modID.equals("ebwizardry")) {
            spells.add(Spells.none);
        }
        Wizardry.logger.info("Loading built-in spell properties for " + spells.size() + " spells in mod " + modID);
        boolean success = CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + modID + "/spells"), null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(modID, name);
            Spell spell = (Spell)Spell.registry.getValue(key);
            if (spell == null) {
                Wizardry.logger.info("Spell properties file " + name + ".json does not match any registered spells; ensure the filename is spelled correctly.");
                return true;
            }
            if (!spells.remove(spell)) {
                Wizardry.logger.warn("What's going on?!");
            }
            if (spell.arePropertiesInitialised()) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                SpellProperties properties = new SpellProperties(json, spell);
                spell.setProperties(properties);
            }
            catch (JsonParseException jsonparseexception) {
                Wizardry.logger.error("Parsing error loading spell property file for " + key, (Throwable)jsonparseexception);
                Boolean bl = false;
                return bl;
            }
            catch (IOException ioexception) {
                Wizardry.logger.error("Couldn't read spell property file for " + key, (Throwable)ioexception);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)true, (boolean)true);
        if (!spells.isEmpty()) {
            if (spells.size() <= 15) {
                spells.forEach(s -> Wizardry.logger.error("Spell " + s.getRegistryName() + " is missing a properties file!"));
            } else {
                Wizardry.logger.error("Mod " + modID + " has " + spells.size() + " spells that are missing properties files!");
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadSpellPropertiesFromDir(File dir) {
        boolean success = true;
        for (File file : FileUtils.listFiles((File)dir, (String[])new String[]{"json"}, (boolean)true)) {
            String name;
            String relative = dir.toPath().relativize(file.toPath()).toString();
            String nameAndModID = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            String modID = nameAndModID.split("/")[0];
            ResourceLocation key = new ResourceLocation(modID, name = nameAndModID.substring(nameAndModID.indexOf(47) + 1));
            Spell spell = (Spell)Spell.registry.getValue(key);
            if (spell == null) {
                Wizardry.logger.info("Spell properties file " + nameAndModID + ".json does not match any registered spells; ensure the filename is spelled correctly.");
                continue;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file.toPath());
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                SpellProperties properties = new SpellProperties(json, spell);
                spell.setProperties(properties);
            }
            catch (JsonParseException jsonparseexception) {
                Wizardry.logger.error("Parsing error loading spell property file for " + key, (Throwable)jsonparseexception);
                success = false;
            }
            catch (IOException ioexception) {
                Wizardry.logger.error("Couldn't read spell property file for " + key, (Throwable)ioexception);
                success = false;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return success;
    }

    public static enum Context {
        BOOK("book"),
        SCROLL("scroll"),
        WANDS("wands"),
        NPCS("npcs"),
        DISPENSERS("dispensers"),
        COMMANDS("commands"),
        TREASURE("treasure"),
        TRADES("trades"),
        LOOTING("looting");

        public final String name;

        private Context(String name) {
            this.name = name;
        }
    }
}

