/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class SpellNetworkIDSorter {
    public static void init() {
        Wizardry.logger.debug("Reordering all spell NetworkIDs based on addon modid alphabetical order");
        int nextSpellId = (int)Spell.getAllSpells().stream().filter(spell -> spell.getRegistryName().func_110624_b().equals("ebwizardry")).count() + 1;
        List addonSpells = Spell.getAllSpells().stream().filter(spell -> !spell.getRegistryName().func_110624_b().equals("ebwizardry")).collect(Collectors.toList());
        addonSpells.sort(Comparator.comparing(o -> o.getRegistryName().toString()));
        for (Spell spell2 : addonSpells) {
            Wizardry.logger.debug("Updating networkID of spell " + spell2.getRegistryName().toString() + " from " + spell2.networkID() + " to " + nextSpellId);
            spell2.setId(nextSpellId++);
        }
    }
}

