/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;

public final class InventoryUtils {
    public static final EntityEquipmentSlot[] ARMOUR_SLOTS;

    private InventoryUtils() {
    }

    public static List<ItemStack> getHotbar(EntityPlayer player) {
        NonNullList hotbar = NonNullList.func_191196_a();
        hotbar.addAll((Collection)player.field_71071_by.field_70462_a.subList(0, 9));
        return hotbar;
    }

    public static List<ItemStack> getPrioritisedHotbarAndOffhand(EntityPlayer player) {
        List<ItemStack> hotbar = InventoryUtils.getHotbar(player);
        hotbar.add(0, player.func_184592_cb());
        hotbar.remove(player.func_184614_ca());
        hotbar.add(0, player.func_184614_ca());
        return hotbar;
    }

    public static EnumHandSide getSideForHand(EntityLivingBase entity, EnumHand hand) {
        return hand == EnumHand.MAIN_HAND ? entity.func_184591_cq() : entity.func_184591_cq().func_188468_a();
    }

    public static EnumHand getHandForSide(EntityLivingBase entity, EnumHandSide side) {
        return side == entity.func_184591_cq() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public static EnumHand getOpposite(EnumHand hand) {
        return hand == EnumHand.OFF_HAND ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public static boolean doesPlayerHaveItem(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack copyWithMeta(ItemStack toCopy, int newMetadata) {
        ItemStack copy = new ItemStack(toCopy.func_77973_b(), toCopy.func_190916_E(), newMetadata);
        NBTTagCompound compound = toCopy.func_77978_p();
        if (compound != null) {
            copy.func_77982_d(compound.func_74737_b());
        }
        return copy;
    }

    public static boolean canMerge(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77985_e() && stack2.func_77985_e() && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean replaceItemInInventory(Entity entity, int slot, ItemStack original, ItemStack replacement) {
        if (entity instanceof EntityLivingBase) {
            for (EntityEquipmentSlot eslot : EntityEquipmentSlot.values()) {
                if (((EntityLivingBase)entity).func_184582_a(eslot) != original) continue;
                entity.func_184201_a(eslot, replacement);
                return true;
            }
        }
        return entity.func_174820_d(slot, replacement);
    }

    static {
        ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>(Arrays.asList(EntityEquipmentSlot.values()));
        slots.removeIf(slot -> slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR);
        ARMOUR_SLOTS = slots.toArray(new EntityEquipmentSlot[0]);
    }
}

