/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public final class AllyDesignationSystem {
    private AllyDesignationSystem() {
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        Entity controller;
        NBTTagCompound entityNBT;
        if (attacker instanceof IEntityOwnable && !AllyDesignationSystem.isValidTarget(((IEntityOwnable)attacker).func_70902_q(), target)) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (attacker == null) {
            return true;
        }
        if (target == attacker) {
            return false;
        }
        if (target instanceof FakePlayer) {
            return false;
        }
        if (Wizardry.settings.passiveMobsAreAllies && (target.isCreatureType(EnumCreatureType.AMBIENT, false) || target.isCreatureType(EnumCreatureType.CREATURE, false) || target.isCreatureType(EnumCreatureType.WATER_CREATURE, false))) {
            return false;
        }
        if (target instanceof IEntityOwnable && ((IEntityOwnable)target).func_70902_q() == attacker) {
            return false;
        }
        if (target instanceof IEntityOwnable && attacker instanceof EntityLiving && ((EntityLiving)attacker).func_70643_av() != ((IEntityOwnable)target).func_70902_q() && ((EntityLiving)attacker).func_70638_az() != ((IEntityOwnable)target).func_70902_q()) {
            return false;
        }
        if (target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_186855_b("controllingEntity") && attacker == EntityUtils.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) {
            return false;
        }
        return !(attacker instanceof EntityPlayer) || WizardData.get((EntityPlayer)attacker) == null || !(target instanceof EntityPlayer ? WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)target) : (target instanceof IEntityOwnable ? AllyDesignationSystem.isOwnerAlly((EntityPlayer)attacker, (IEntityOwnable)target) : target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (controller = EntityUtils.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) instanceof EntityPlayer && WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)controller)));
    }

    public static boolean isAllied(EntityLivingBase allyOf, EntityLivingBase possibleAlly) {
        Entity owner;
        if (allyOf instanceof IEntityOwnable && (owner = ((IEntityOwnable)allyOf).func_70902_q()) instanceof EntityLivingBase && (owner == possibleAlly || AllyDesignationSystem.isAllied((EntityLivingBase)owner, possibleAlly))) {
            return true;
        }
        if (allyOf instanceof EntityPlayer && possibleAlly instanceof EntityPlayer && AllyDesignationSystem.isPlayerAlly((EntityPlayer)allyOf, (EntityPlayer)possibleAlly)) {
            return true;
        }
        if (possibleAlly instanceof IEntityOwnable) {
            IEntityOwnable pet = (IEntityOwnable)possibleAlly;
            if (pet.func_70902_q() == allyOf) {
                return true;
            }
            if (allyOf instanceof EntityPlayer && AllyDesignationSystem.isOwnerAlly((EntityPlayer)allyOf, pet)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerAlly(EntityPlayer allyOf, EntityPlayer possibleAlly) {
        WizardData data = WizardData.get(allyOf);
        return data != null && data.isPlayerAlly(possibleAlly);
    }

    public static boolean isOwnerAlly(EntityPlayer allyOf, IEntityOwnable ownable) {
        WizardData data = WizardData.get(allyOf);
        if (data == null) {
            return false;
        }
        Entity owner = ownable.func_70902_q();
        return owner instanceof EntityPlayer ? data.isPlayerAlly((EntityPlayer)owner) : data.isPlayerAlly(ownable.func_184753_b());
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource() instanceof IElementalDamage) {
            if (event.getEntity() instanceof EntityPlayer) {
                if (Wizardry.settings.friendlyFire.blockPlayers && AllyDesignationSystem.isPlayerAlly((EntityPlayer)event.getSource().func_76346_g(), (EntityPlayer)event.getEntity())) {
                    event.setCanceled(true);
                }
            } else if (Wizardry.settings.friendlyFire.blockOwned && AllyDesignationSystem.isAllied((EntityLivingBase)((EntityPlayer)event.getSource().func_76346_g()), event.getEntityLiving())) {
                event.setCanceled(true);
            }
        }
    }

    public static enum FriendlyFire {
        ALL("All", false, false),
        ONLY_PLAYERS("Only players", false, true),
        ONLY_OWNED("Only summoned/tamed creatures", true, false),
        NONE("None", true, true);

        public static final String[] names;
        public final String name;
        public final boolean blockPlayers;
        public final boolean blockOwned;

        private FriendlyFire(String name, boolean blockPlayers, boolean blockOwned) {
            this.name = name;
            this.blockPlayers = blockPlayers;
            this.blockOwned = blockOwned;
        }

        public static FriendlyFire fromName(String name) {
            for (FriendlyFire setting : FriendlyFire.values()) {
                if (!setting.name.equalsIgnoreCase(name)) continue;
                return setting;
            }
            Wizardry.logger.info("Invalid string for the friendly fire setting. Using default (all) instead.");
            return ALL;
        }

        static {
            names = new String[FriendlyFire.values().length];
            for (FriendlyFire setting : FriendlyFire.values()) {
                FriendlyFire.names[setting.ordinal()] = setting.name;
            }
        }
    }
}

