/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Whirlwind
extends SpellRay {
    public static final String REPULSION_VELOCITY = "repulsion_velocity";

    public Whirlwind() {
        super("whirlwind", SpellActions.POINT, false);
        this.soundValues(0.8f, 0.7f, 0.2f);
        this.addProperties(REPULSION_VELOCITY);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer && (caster instanceof EntityPlayer && !Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring))) {
            if (!world.field_72995_K && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
            return false;
        }
        if (target instanceof EntityLivingBase) {
            Vec3d vec = target.func_174824_e(1.0f).func_178788_d(origin).func_72432_b();
            if (!world.field_72995_K) {
                float velocity = this.getProperty(REPULSION_VELOCITY).floatValue() * modifiers.get("potency");
                target.field_70159_w = vec.field_72450_a * (double)velocity;
                target.field_70181_x = vec.field_72448_b * (double)velocity + 1.0;
                target.field_70179_y = vec.field_72449_c * (double)velocity;
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
                }
            }
            if (world.field_72995_K) {
                double distance = target.func_70011_f(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
                for (int i = 0; i < 10; ++i) {
                    double x = origin.field_72450_a + world.field_73012_v.nextDouble() - 0.5 + vec.field_72450_a * distance * 0.5;
                    double y = origin.field_72448_b + world.field_73012_v.nextDouble() - 0.5 + vec.field_72448_b * distance * 0.5;
                    double z = origin.field_72449_c + world.field_73012_v.nextDouble() - 0.5 + vec.field_72449_c * distance * 0.5;
                    world.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, new int[0]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

