/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Fangs
extends Spell {
    private static final double FANG_SPACING = 1.25;

    public Fangs() {
        super("fangs", SpellActions.SUMMON, false);
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.spawnFangs(world, caster.func_174791_d(), GeometryUtils.horizontalise(caster.func_70040_Z()), (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.spawnFangs(world, caster.func_174791_d(), target.func_174791_d().func_178788_d(caster.func_174791_d()).func_72432_b(), (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!this.spawnFangs(world, new Vec3d(x, y, z), new Vec3d(direction.func_176730_m()), null, modifiers)) {
            return false;
        }
        this.playSound(world, x, y, z, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected boolean spawnFangs(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        boolean defensiveCircle;
        boolean bl = defensiveCircle = caster instanceof EntityPlayer && caster.func_70093_af() && ItemArtefact.isArtefactActive((EntityPlayer)caster, WizardryItems.ring_evoker);
        if (!defensiveCircle && direction.func_189985_c() == 0.0) {
            return false;
        }
        boolean flag = false;
        if (world.field_72995_K) {
            double x = origin.field_72450_a;
            double y = caster == null ? origin.field_72448_b : origin.field_72448_b + (double)caster.func_70047_e();
            double z = origin.field_72449_c;
            for (int i = 0; i < 12; ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, world.field_73012_v, x, y, z, 0.5, false).clr(0.4f, 0.3f, 0.35f).spawn(world);
            }
        } else if (defensiveCircle) {
            float yaw;
            for (int i = 0; i < 5; ++i) {
                yaw = (float)i * (float)Math.PI * 0.4f;
                flag |= this.spawnFangsAt(world, caster, modifiers, yaw, 0, origin.func_72441_c((double)MathHelper.func_76134_b((float)yaw) * 1.5, 0.0, (double)MathHelper.func_76126_a((float)yaw) * 1.5));
            }
            for (int k = 0; k < 8; ++k) {
                yaw = (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                flag |= this.spawnFangsAt(world, caster, modifiers, yaw, 3, origin.func_72441_c((double)MathHelper.func_76134_b((float)yaw) * 2.5, 0.0, (double)MathHelper.func_76126_a((float)yaw) * 2.5));
            }
        } else {
            int count = (int)(this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade));
            float yaw = (float)MathHelper.func_181159_b((double)direction.field_72449_c, (double)direction.field_72450_a);
            for (int i = 0; i < count; ++i) {
                Vec3d vec = origin.func_178787_e(direction.func_186678_a((double)(i + 1) * 1.25));
                flag |= this.spawnFangsAt(world, caster, modifiers, yaw, i, vec);
            }
        }
        return flag;
    }

    private boolean spawnFangsAt(World world, @Nullable EntityLivingBase caster, SpellModifiers modifiers, float yaw, int delay, Vec3d vec) {
        Integer y = BlockUtils.getNearestFloor(world, new BlockPos(vec), 5);
        if (y != null) {
            EntityEvokerFangs fangs = new EntityEvokerFangs(world, vec.field_72450_a, (double)y.intValue(), vec.field_72449_c, yaw, delay, caster);
            fangs.getEntityData().func_74776_a("ebwizardryDamageModifier", modifiers.get("potency"));
            world.func_72838_d((Entity)fangs);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource().func_76364_f() instanceof EntityEvokerFangs && !AllyDesignationSystem.isValidTarget(event.getSource().func_76346_g(), (Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }
}

