/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.projectile.EntityEmber;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Disintegration
extends SpellRay {
    public static final String EMBER_COUNT = "ember_count";
    public static final String EMBER_LIFETIME = "ember_lifetime";
    public static final String NBT_KEY = "disintegrating";

    public Disintegration() {
        super("disintegration", SpellActions.POINT, false);
        this.addProperties("damage", "burn_duration", EMBER_LIFETIME, EMBER_COUNT);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, target)) {
            if (!world.field_72995_K && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
            }
        } else {
            target.func_70015_d((int)(this.getProperty("burn_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
            EntityUtils.attackEntityWithoutKnockback(target, caster == null ? DamageSource.field_76376_m : MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FIRE), this.getProperty("damage").floatValue() * modifiers.get("potency"));
            if (target instanceof EntityLivingBase && ((EntityLivingBase)target).func_110143_aJ() <= 0.0f) {
                Disintegration.spawnEmbers(world, caster, target, this.getProperty(EMBER_COUNT).intValue());
            }
        }
        return true;
    }

    public static void spawnEmbers(World world, EntityLivingBase caster, Entity target, int count) {
        target.func_70066_B();
        if (world.field_72995_K) {
            if (!target.getEntityData().func_74764_b(NBT_KEY)) {
                target.getEntityData().func_74768_a(NBT_KEY, target.field_70173_aa);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                EntityEmber ember = new EntityEmber(world, caster);
                double x = (world.field_73012_v.nextDouble() - 0.5) * (double)target.field_70130_N;
                double y = world.field_73012_v.nextDouble() * (double)target.field_70131_O;
                double z = (world.field_73012_v.nextDouble() - 0.5) * (double)target.field_70130_N;
                ember.func_70107_b(target.field_70165_t + x, target.field_70163_u + y, target.field_70161_v + z);
                ember.field_70173_aa = world.field_73012_v.nextInt(20);
                float speed = 0.2f;
                ember.field_70159_w = x * (double)speed;
                ember.field_70181_x = y * 0.5 * (double)speed;
                ember.field_70179_y = z * (double)speed;
                world.func_72838_d((Entity)ember);
            }
        }
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.LAVA, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
            if (world.func_180495_p(pos).func_185904_a().func_76220_a()) {
                Vec3d vec = hit.func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.005));
                ParticleBuilder.create(ParticleBuilder.Type.SCORCH).pos(vec).face(side).clr(1.0f, 0.2f, 0.0f).spawn(world);
            }
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(distance));
        ParticleBuilder.create(ParticleBuilder.Type.BEAM).clr(1.0f, 0.4f, 0.0f).fade(1.0f, 0.1f, 0.0f).time(4).pos(origin).target(endpoint).spawn(world);
    }
}

