/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ArcaneJammer
extends SpellRay {
    private static final Random random = new Random();
    private static final int UPDATE_INTERVAL = 15;
    private static final Field spellTicks = ObfuscationReflectionHelper.findField(EntitySpellcasterIllager.class, (String)"field_193087_b");

    public ArcaneJammer() {
        super("arcane_jammer", SpellActions.POINT, false);
        this.soundValues(0.7f, 1.0f, 0.4f);
        this.addProperties("effect_duration", "effect_strength");
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target) && !world.field_72995_K) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.arcane_jammer, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + (int)((modifiers.get("potency") - 1.0f) / Constants.POTENCY_INCREASE_PER_TIER + 0.5f)));
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(0.9f, 0.3f, 0.7f).spawn(world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        random.setSeed(event.getWorld().func_82737_E() / 15L);
        random.nextInt(2);
        if (event.getCaster() != null && event.getCaster().func_70644_a(WizardryPotions.arcane_jammer) && random.nextInt(event.getCaster().func_70660_b(WizardryPotions.arcane_jammer).func_76458_c() + 2) > 0) {
            event.setCanceled(true);
            if (event.getSource() == SpellCastEvent.Source.WAND || event.getSource() == SpellCastEvent.Source.SCROLL) {
                event.getCaster().func_184598_c(EnumHand.MAIN_HAND);
            }
            event.getWorld().func_184134_a(event.getCaster().field_70165_t, event.getCaster().field_70163_u, event.getCaster().field_70161_v, WizardrySounds.MISC_SPELL_FAIL, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
            if (event.getWorld().field_72995_K) {
                Vec3d centre = event.getCaster().func_174824_e(1.0f).func_178787_e(event.getCaster().func_70040_Z());
                for (int i = 0; i < 5; ++i) {
                    double x = centre.field_72450_a + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                    double y = centre.field_72448_b + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                    double z = centre.field_72449_c + (double)(0.5f * (event.getWorld().field_73012_v.nextFloat() - 0.5f));
                    event.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntitySpellcasterIllager && event.getEntityLiving().func_70644_a(WizardryPotions.arcane_jammer)) {
            ((EntitySpellcasterIllager)event.getEntity()).func_193081_a(EntitySpellcasterIllager.SpellType.NONE);
            try {
                spellTicks.set(event.getEntity(), 10);
            }
            catch (IllegalAccessException e) {
                Wizardry.logger.error("Error setting evoker spell timer:", (Throwable)e);
            }
        }
    }
}

