/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WizardryTabs {
    public static final CreativeTabs WIZARDRY = new CreativeTabListed("ebwizardry");
    public static final CreativeTabs GEAR = new CreativeTabListed("ebwizardrygear");
    public static final CreativeTabs SPELLS = new CreativeTabSorted("ebwizardryspells", (stack1, stack2) -> {
        if (stack1.func_77973_b() instanceof ItemSpellBook && stack2.func_77973_b() instanceof ItemSpellBook || stack1.func_77973_b() instanceof ItemScroll && stack2.func_77973_b() instanceof ItemScroll) {
            Spell spell1 = Spell.byMetadata(stack1.func_77952_i());
            Spell spell2 = Spell.byMetadata(stack2.func_77952_i());
            return spell1.compareTo(spell2);
        }
        if (stack1.func_77973_b() instanceof ItemScroll) {
            return 1;
        }
        if (stack2.func_77973_b() instanceof ItemScroll) {
            return -1;
        }
        return 0;
    }, true);

    private WizardryTabs() {
    }

    public static class CreativeTabListed
    extends CreativeTabSorted {
        public final List<Item> order;

        public CreativeTabListed(String label) {
            this(label, new ArrayList<Item>());
        }

        public CreativeTabListed(String label, List<Item> order) {
            super(label, (stack1, stack2) -> {
                if (!order.contains(stack1.func_77973_b()) && !order.contains(stack2.func_77973_b())) {
                    return 0;
                }
                if (!order.contains(stack1.func_77973_b())) {
                    return 1;
                }
                if (!order.contains(stack2.func_77973_b())) {
                    return -1;
                }
                return order.indexOf(stack1.func_77973_b()) - order.indexOf(stack2.func_77973_b());
            });
            this.order = order;
        }
    }

    public static class CreativeTabSorted
    extends CreativeTabs {
        private ItemStack iconItem;
        private final Comparator<? super ItemStack> sorter;
        private final boolean searchable;

        public CreativeTabSorted(String label, Comparator<? super ItemStack> sorter) {
            this(label, sorter, false);
        }

        public CreativeTabSorted(String label, Comparator<? super ItemStack> sorter, boolean searchable) {
            super(label);
            this.sorter = sorter;
            this.searchable = searchable;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return this.iconItem;
        }

        public void setIconItem(ItemStack iconItem) {
            this.iconItem = iconItem;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.sort(this.sorter);
        }

        public boolean hasSearchBar() {
            return this.searchable;
        }

        @SideOnly(value=Side.CLIENT)
        public String func_78015_f() {
            return this.searchable ? "item_search.png" : super.func_78015_f();
        }
    }
}

