/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.potion;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.potion.ISyncedPotion;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SlowTime;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PotionSlowTime
extends PotionMagicEffect
implements ISyncedPotion {
    public static final String NBT_KEY = "time_slowed";

    public PotionSlowTime(boolean isBadEffect, int liquidColour) {
        super(isBadEffect, liquidColour, new ResourceLocation("ebwizardry", "textures/gui/potion_icons/slow_time.png"));
        this.func_76390_b("potion.ebwizardry:slow_time");
    }

    private static double getEffectRadius() {
        return Spells.slow_time.getProperty("effect_radius").doubleValue();
    }

    public static void unblockNearbyEntities(EntityLivingBase host) {
        List<Entity> targetsBeyondRange = EntityUtils.getEntitiesWithinRadius(PotionSlowTime.getEffectRadius() + 3.0, host.field_70165_t, host.field_70163_u, host.field_70161_v, host.field_70170_p, Entity.class);
        targetsBeyondRange.forEach(e -> {
            e.updateBlocked = false;
        });
    }

    private static void performEffectConsistent(EntityLivingBase host, int strength) {
        boolean stopTime = host instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)host, WizardryItems.charm_stop_time);
        int interval = strength * 4 + 6;
        List<Entity> targetsInRange = EntityUtils.getEntitiesWithinRadius(PotionSlowTime.getEffectRadius(), host.field_70165_t, host.field_70163_u, host.field_70161_v, host.field_70170_p, Entity.class);
        targetsInRange.remove(host);
        targetsInRange.removeIf(t -> t instanceof EntityLivingBase && ((EntityLivingBase)t).func_70644_a(WizardryPotions.slow_time));
        if (!Wizardry.settings.slowTimeAffectsPlayers) {
            targetsInRange.removeIf(t -> t instanceof EntityPlayer);
        }
        targetsInRange.removeIf(t -> t instanceof EntityArrow && t.func_70094_T());
        for (Entity entity : targetsInRange) {
            entity.getEntityData().func_74757_a(NBT_KEY, true);
            boolean bl = entity.updateBlocked = stopTime || host.field_70173_aa % interval != 0;
            if (!stopTime && entity.field_70170_p.field_72995_K) {
                double z;
                double y;
                if (entity.field_70122_E) {
                    entity.field_70181_x = 0.0;
                }
                if (entity.updateBlocked) {
                    double x = entity.field_70165_t + entity.field_70159_w * 1.0 / (double)interval;
                    y = entity.field_70163_u + entity.field_70181_x * 1.0 / (double)interval;
                    z = entity.field_70161_v + entity.field_70179_y * 1.0 / (double)interval;
                    entity.field_70169_q = entity.field_70165_t;
                    entity.field_70167_r = entity.field_70163_u;
                    entity.field_70166_s = entity.field_70161_v;
                    entity.field_70165_t = x;
                    entity.field_70163_u = y;
                    entity.field_70161_v = z;
                } else {
                    entity.field_70165_t += entity.field_70159_w * 1.0 / (double)interval;
                    entity.field_70163_u += entity.field_70181_x * 1.0 / (double)interval;
                    entity.field_70161_v += entity.field_70179_y * 1.0 / (double)interval;
                    double x = entity.field_70165_t - entity.field_70159_w * 1.0 / (double)interval;
                    y = entity.field_70163_u - entity.field_70181_x * 1.0 / (double)interval;
                    z = entity.field_70161_v - entity.field_70179_y * 1.0 / (double)interval;
                    entity.field_70169_q = x;
                    entity.field_70167_r = y;
                    entity.field_70166_s = z;
                }
            }
            if (!entity.field_70170_p.field_72995_K || host.field_70173_aa % 2 != 0) continue;
            int lifetime = 15;
            double dx = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)entity.field_70130_N;
            double dy = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)entity.field_70130_N;
            double dz = (entity.field_70170_p.field_73012_v.nextDouble() - 0.5) * 2.0 * (double)entity.field_70130_N;
            double x = entity.field_70165_t + dx;
            double y = entity instanceof IProjectile ? entity.field_70163_u + dy : entity.field_70163_u + (double)(entity.field_70131_O / 2.0f) + dy;
            double z = entity.field_70161_v + dz;
            ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y, z).vel(-dx / (double)lifetime, -dy / (double)lifetime, -dz / (double)lifetime).clr(6022075).time(15).spawn(entity.field_70170_p);
        }
        List<Entity> targetsBeyondRange = EntityUtils.getEntitiesWithinRadius(PotionSlowTime.getEffectRadius() + 3.0, host.field_70165_t, host.field_70163_u, host.field_70161_v, host.field_70170_p, Entity.class);
        targetsBeyondRange.removeAll(targetsInRange);
        targetsBeyondRange.forEach(e -> {
            e.updateBlocked = false;
        });
    }

    public static void cleanUpEntities(World world) {
        ArrayList loadedEntityList = new ArrayList(world.field_72996_f);
        for (Entity entity : loadedEntityList) {
            List<EntityLivingBase> nearby;
            if (!entity.getEntityData().func_74767_n(NBT_KEY) || !(nearby = EntityUtils.getLivingWithinRadius(PotionSlowTime.getEffectRadius(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p)).stream().noneMatch(e -> e.func_70644_a(WizardryPotions.slow_time))) continue;
            entity.getEntityData().func_82580_o(NBT_KEY);
            entity.updateBlocked = false;
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70644_a(WizardryPotions.slow_time)) {
            PotionSlowTime.performEffectConsistent(entity, entity.func_70660_b(WizardryPotions.slow_time).func_76458_c());
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getPotionEffect().func_188419_a() == WizardryPotions.slow_time && event.getEntity() instanceof EntityPlayer) {
            Wizardry.proxy.loadShader((EntityPlayer)event.getEntity(), SlowTime.SHADER);
            Wizardry.proxy.playBlinkEffect((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END) {
            PotionSlowTime.cleanUpEntities(event.world);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.updateBlocked) {
            event.player.updateBlocked = false;
        }
    }
}

