/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.misc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemManaFlask;
import java.util.Collection;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod.EventBusSubscriber
public class RecipeRechargeWithFlask
extends ShapelessOreRecipe {
    private static final Multimap<Item, RecipeRechargeWithFlask> FLASK_RECIPES = HashMultimap.create();
    private final IManaStoringItem chargeable;
    private final ItemManaFlask flask;

    public RecipeRechargeWithFlask(Item chargeable, ItemManaFlask flask) {
        super(null, new ItemStack(chargeable, 1, Short.MAX_VALUE), new Object[]{new ItemStack(chargeable, 1, Short.MAX_VALUE), flask});
        if (!(chargeable instanceof IManaStoringItem)) {
            throw new IllegalArgumentException("Item to be charged must be an instance of IManaStoringItem");
        }
        this.chargeable = (IManaStoringItem)chargeable;
        this.flask = flask;
        FLASK_RECIPES.put((Object)chargeable, (Object)this);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack result = super.func_77572_b(inv);
        this.rechargeItemAndCopyNBT(result, inv);
        return result;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ItemStack stack = this.findItemToCharge(inv);
        if (!stack.func_190926_b() && this.chargeable.isManaFull(stack)) {
            return false;
        }
        return super.func_77569_a(inv, world);
    }

    private void rechargeItemAndCopyNBT(ItemStack toCharge, InventoryCrafting inv) {
        if (toCharge.func_77973_b() == this.chargeable) {
            ItemStack stack = this.findItemToCharge(inv);
            if (!stack.func_190926_b()) {
                this.chargeable.setMana(toCharge, this.chargeable.getMana(stack));
            }
            this.chargeable.rechargeMana(toCharge, this.flask.size.capacity);
            toCharge.func_77982_d(stack.func_77978_p());
        } else {
            Wizardry.logger.warn("Tried to recharge item {} with mana flask, but it did not match the recipe result {}!", (Object)toCharge.func_77973_b(), (Object)this.chargeable);
        }
    }

    private ItemStack findItemToCharge(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack ingredient = inv.func_70301_a(i);
            if (ingredient.func_77973_b() != this.chargeable) continue;
            return ingredient;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    @SubscribeEvent
    public static void onItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.craftMatrix instanceof InventoryCrafting) {
            Collection recipes = FLASK_RECIPES.get((Object)event.crafting.func_77973_b());
            for (RecipeRechargeWithFlask recipe : recipes) {
                if (!recipe.func_77569_a((InventoryCrafting)event.craftMatrix, event.player.field_70170_p)) continue;
                recipe.rechargeItemAndCopyNBT(event.crafting, (InventoryCrafting)event.craftMatrix);
            }
        }
    }
}

