/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.entity.construct.EntityArrowRain;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBlizzard;
import electroblob.wizardry.entity.construct.EntityHailstorm;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.entity.living.EntityIceGiant;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityVexMinion;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.projectile.EntityFirebomb;
import electroblob.wizardry.entity.projectile.EntityMagicFireball;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Banish;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public abstract class Forfeit {
    private static final ListMultimap<Pair<Tier, Element>, Forfeit> forfeits = ArrayListMultimap.create();
    private static final float TIER_CHANGE_CHANCE = 0.2f;
    private final ResourceLocation name;
    protected final SoundEvent sound;

    public Forfeit(ResourceLocation name) {
        this.name = name;
        this.sound = WizardrySounds.createSound("forfeit." + name.func_110623_a());
    }

    public abstract void apply(World var1, EntityPlayer var2);

    public ITextComponent getMessage(ITextComponent implementName) {
        return new TextComponentTranslation("forfeit." + this.name.toString(), new Object[]{implementName});
    }

    public ITextComponent getMessageForWand() {
        return this.getMessage((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.generic", new Object[0]));
    }

    public ITextComponent getMessageForScroll() {
        return this.getMessage((ITextComponent)new TextComponentTranslation("item.ebwizardry:scroll.generic", new Object[0]));
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public static void add(Tier tier, Element element, Forfeit forfeit) {
        forfeits.put((Object)Pair.of((Object)((Object)tier), (Object)((Object)element)), (Object)forfeit);
    }

    public static Forfeit getRandomForfeit(Random random, Tier tier, Element element) {
        float f = random.nextFloat();
        if (f < 0.2f) {
            tier = tier.previous();
        } else if (f > 0.8f) {
            tier = tier.next();
        }
        List matches = forfeits.get((Object)Pair.of((Object)((Object)tier), (Object)((Object)element)));
        if (matches.isEmpty()) {
            Wizardry.logger.warn("No forfeits with tier {} and element {}!", (Object)tier, (Object)element);
            return null;
        }
        return (Forfeit)matches.get(random.nextInt(matches.size()));
    }

    public static Collection<Forfeit> getForfeits() {
        return Collections.unmodifiableCollection(forfeits.values());
    }

    public static Forfeit create(ResourceLocation name, final BiConsumer<World, EntityPlayer> effect) {
        return new Forfeit(name){

            @Override
            public void apply(World world, EntityPlayer player) {
                effect.accept(world, player);
            }
        };
    }

    private static Forfeit create(String name, BiConsumer<World, EntityPlayer> effect) {
        return Forfeit.create(new ResourceLocation("ebwizardry", name), effect);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (!Wizardry.settings.discoveryMode) {
            return;
        }
        if (event.getCaster() instanceof EntityPlayer && !((EntityPlayer)event.getCaster()).func_184812_l_() && (event.getSource() == SpellCastEvent.Source.WAND || event.getSource() == SpellCastEvent.Source.SCROLL)) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            WizardData data = WizardData.get(player);
            float chance = (float)Wizardry.settings.forfeitChance;
            if (ItemArtefact.isArtefactActive(player, WizardryItems.amulet_wisdom)) {
                chance = (float)((double)chance * 0.5);
            }
            if (data.synchronisedRandom.nextFloat() < chance && !data.hasSpellBeenDiscovered(event.getSpell())) {
                event.setCanceled(true);
                Forfeit forfeit = Forfeit.getRandomForfeit(data.synchronisedRandom, event.getSpell().getTier(), event.getSpell().getElement());
                if (forfeit == null) {
                    if (!event.getWorld().field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("forfeit.ebwizardry:do_nothing", new Object[0]));
                    }
                    return;
                }
                forfeit.apply(event.getWorld(), player);
                ItemStack stack = player.func_184614_ca();
                if (!(stack.func_77973_b() instanceof ISpellCastingItem) && !((stack = player.func_184592_cb()).func_77973_b() instanceof ISpellCastingItem)) {
                    stack = ItemStack.field_190927_a;
                }
                if (!stack.func_190926_b()) {
                    if (event.getSource() == SpellCastEvent.Source.SCROLL) {
                        if (!player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                    } else if (stack.func_77973_b() instanceof IManaStoringItem) {
                        int cost = (int)((float)event.getSpell().getCost() * event.getModifiers().get("cost") + 0.1f);
                        ((IManaStoringItem)stack.func_77973_b()).consumeMana(stack, cost, (EntityLivingBase)player);
                    }
                }
                WizardryAdvancementTriggers.spell_failure.triggerFor(player);
                EntityUtils.playSoundAtPlayer(player, forfeit.getSound(), WizardrySounds.SPELLS, 1.0f, 1.0f);
                if (!event.getWorld().field_72995_K) {
                    player.func_145747_a(event.getSource() == SpellCastEvent.Source.WAND ? forfeit.getMessageForWand() : forfeit.getMessageForScroll());
                }
            }
        }
    }

    public static void register() {
        Forfeit.add(Tier.NOVICE, Element.FIRE, Forfeit.create("burn_self", (World w, EntityPlayer p) -> p.func_70015_d(5)));
        Forfeit.add(Tier.APPRENTICE, Element.FIRE, Forfeit.create("fireball", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityMagicFireball fireball = new EntityMagicFireball((World)w);
                Vec3d vec = p.func_174824_e(1.0f).func_178787_e(p.func_70040_Z().func_186678_a(6.0));
                fireball.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                fireball.func_70186_c(p.field_70165_t, p.field_70163_u + (double)p.func_70047_e(), p.field_70161_v, 1.5f, 1.0f);
                w.func_72838_d((Entity)fireball);
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.FIRE, Forfeit.create("firebomb", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityFirebomb firebomb = new EntityFirebomb((World)w);
                firebomb.func_70107_b(p.field_70165_t, p.field_70163_u + 5.0, p.field_70161_v);
                w.func_72838_d((Entity)firebomb);
            }
        }));
        Forfeit.add(Tier.ADVANCED, Element.FIRE, Forfeit.create("explode", (World w, EntityPlayer p) -> w.func_72876_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, 1.0f, false)));
        Forfeit.add(Tier.ADVANCED, Element.FIRE, Forfeit.create("blazes", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 3 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, 4, 2)) != null; ++i) {
                    EntityBlazeMinion blaze = new EntityBlazeMinion((World)w);
                    blaze.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)blaze);
                }
            }
        }));
        Forfeit.add(Tier.MASTER, Element.FIRE, Forfeit.create("burn_surroundings", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K && EntityUtils.canDamageBlocks((Entity)p, w)) {
                List<BlockPos> sphere = BlockUtils.getBlockSphere(p.func_180425_c(), 6.0);
                for (BlockPos pos : sphere) {
                    if (!w.field_73012_v.nextBoolean() || !w.func_175623_d(pos) || !BlockUtils.canPlaceBlock((Entity)p, w, pos)) continue;
                    w.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }));
        Forfeit.add(Tier.MASTER, Element.FIRE, Forfeit.create("meteors", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    w.func_72838_d((Entity)new EntityMeteor((World)w, p.field_70165_t + w.field_73012_v.nextDouble() * 16.0 - 8.0, p.field_70163_u + 40.0 + w.field_73012_v.nextDouble() * 30.0, p.field_70161_v + w.field_73012_v.nextDouble() * 16.0 - 8.0, 1.0f, EntityUtils.canDamageBlocks((Entity)p, w)));
                }
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.ICE, Forfeit.create("freeze_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(WizardryPotions.frost, 200))));
        Forfeit.add(Tier.APPRENTICE, Element.ICE, Forfeit.create("freeze_self_2", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(WizardryPotions.frost, 300, 1))));
        Forfeit.add(Tier.APPRENTICE, Element.ICE, Forfeit.create("ice_spikes", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    double z;
                    EntityIceSpike iceSpike = new EntityIceSpike((World)w);
                    double x = p.field_70165_t + 2.0 - (double)(w.field_73012_v.nextFloat() * 4.0f);
                    Integer y = BlockUtils.getNearestSurface(w, new BlockPos(x, p.field_70163_u, z = p.field_70161_v + 2.0 - (double)(w.field_73012_v.nextFloat() * 4.0f)), EnumFacing.UP, 2, true, BlockUtils.SurfaceCriteria.basedOn(World::func_175665_u));
                    if (y == null) break;
                    iceSpike.setFacing(EnumFacing.UP);
                    iceSpike.func_70107_b(x, y.intValue(), z);
                    w.func_72838_d((Entity)iceSpike);
                }
            }
        }));
        Forfeit.add(Tier.ADVANCED, Element.ICE, Forfeit.create("blizzard", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityBlizzard blizzard = new EntityBlizzard((World)w);
                blizzard.func_70107_b(p.field_70165_t, p.field_70163_u, p.field_70161_v);
                w.func_72838_d((Entity)blizzard);
            }
        }));
        Forfeit.add(Tier.ADVANCED, Element.ICE, Forfeit.create("ice_wraiths", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 3 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, 4, 2)) != null; ++i) {
                    EntityIceWraith iceWraith = new EntityIceWraith((World)w);
                    iceWraith.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)iceWraith);
                }
            }
        }));
        Forfeit.add(Tier.MASTER, Element.ICE, Forfeit.create("hailstorm", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityHailstorm hailstorm = new EntityHailstorm((World)w);
                hailstorm.func_70107_b(p.field_70165_t, p.field_70163_u + 5.0, p.field_70161_v - 3.0);
                w.func_72838_d((Entity)hailstorm);
            }
        }));
        Forfeit.add(Tier.MASTER, Element.ICE, Forfeit.create("ice_giant", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityIceGiant iceGiant = new EntityIceGiant((World)w);
                iceGiant.func_70107_b(p.field_70165_t + p.func_70040_Z().field_72450_a * 4.0, p.field_70163_u, p.field_70161_v + p.func_70040_Z().field_72449_c * 4.0);
                w.func_72838_d((Entity)iceGiant);
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.LIGHTNING, Forfeit.create("thunder", (World w, EntityPlayer p) -> {
            p.func_70024_g(-p.func_70040_Z().field_72450_a, 0.0, -p.func_70040_Z().field_72449_c);
            if (w.field_72995_K) {
                w.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, p.field_70165_t, p.field_70163_u, p.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.LIGHTNING, Forfeit.create("storm", (World w, EntityPlayer p) -> {
            if (!Spells.invoke_weather.isEnabled(SpellProperties.Context.WANDS)) {
                return;
            }
            int standardWeatherTime = (300 + new Random().nextInt(600)) * 20;
            w.func_72912_H().func_76084_b(true);
            w.func_72912_H().func_76080_g(standardWeatherTime);
            w.func_72912_H().func_76069_a(true);
            w.func_72912_H().func_76090_f(standardWeatherTime);
        }));
        Forfeit.add(Tier.APPRENTICE, Element.LIGHTNING, Forfeit.create("lightning_sigils", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    BlockPos pos = p.func_180425_c().func_177967_a(direction, 2);
                    Integer y = BlockUtils.getNearestFloor(w, pos, 2);
                    if (y == null) continue;
                    EntityLightningSigil sigil = new EntityLightningSigil((World)w);
                    sigil.func_70107_b((double)pos.func_177958_n() + 0.5, y.intValue(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)sigil);
                }
            }
        }));
        Forfeit.add(Tier.ADVANCED, Element.LIGHTNING, Forfeit.create("lightning", (World w, EntityPlayer p) -> w.func_72942_c((Entity)new EntityLightningBolt(w, p.field_70165_t, p.field_70163_u, p.field_70161_v, false))));
        Forfeit.add(Tier.ADVANCED, Element.LIGHTNING, Forfeit.create("paralyse_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(WizardryPotions.paralysis, 200))));
        Forfeit.add(Tier.ADVANCED, Element.LIGHTNING, Forfeit.create("lightning_wraiths", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 3 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, 4, 2)) != null; ++i) {
                    EntityLightningWraith lightningWraith = new EntityLightningWraith((World)w);
                    lightningWraith.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)lightningWraith);
                }
            }
        }));
        Forfeit.add(Tier.MASTER, Element.LIGHTNING, Forfeit.create("storm_elementals", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    BlockPos pos = p.func_180425_c().func_177967_a(direction, 3);
                    EntityStormElemental stormElemental = new EntityStormElemental((World)w);
                    stormElemental.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)stormElemental);
                }
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.NECROMANCY, Forfeit.create("nausea", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400))));
        Forfeit.add(Tier.APPRENTICE, Element.NECROMANCY, Forfeit.create("zombie_horde", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 3 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, 4, 2)) != null; ++i) {
                    EntityZombieMinion zombie = new EntityZombieMinion((World)w);
                    zombie.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)zombie);
                }
            }
        }));
        Forfeit.add(Tier.ADVANCED, Element.NECROMANCY, Forfeit.create("wither_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400))));
        Forfeit.add(Tier.MASTER, Element.NECROMANCY, Forfeit.create("cripple_self", (World w, EntityPlayer p) -> p.func_70097_a(DamageSource.field_76376_m, p.func_110143_aJ() - 1.0f)));
        Forfeit.add(Tier.MASTER, Element.NECROMANCY, Forfeit.create("shadow_wraiths", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    BlockPos pos = p.func_180425_c().func_177967_a(direction, 3);
                    EntityShadowWraith wraith = new EntityShadowWraith((World)w);
                    wraith.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)wraith);
                }
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.EARTH, Forfeit.create("snares", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K && EntityUtils.canDamageBlocks((Entity)p, w)) {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    BlockPos pos = p.func_180425_c().func_177972_a(direction);
                    if (!BlockUtils.canBlockBeReplaced(w, pos) || !BlockUtils.canPlaceBlock((Entity)p, w, pos)) continue;
                    w.func_175656_a(pos, WizardryBlocks.snare.func_176223_P());
                }
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.EARTH, Forfeit.create("squid", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntitySquid squid = new EntitySquid(w);
                squid.func_70107_b(p.field_70165_t, p.field_70163_u + 3.0, p.field_70161_v);
                w.func_72838_d((Entity)squid);
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.EARTH, Forfeit.create("uproot_plants", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K && EntityUtils.canDamageBlocks((Entity)p, w)) {
                List<BlockPos> sphere = BlockUtils.getBlockSphere(p.func_180425_c(), 5.0);
                sphere.removeIf(pos -> !(w.func_180495_p(pos).func_177230_c() instanceof IPlantable) || !BlockUtils.canBreakBlock((Entity)p, w, pos));
                sphere.forEach(pos -> w.func_175655_b(pos, true));
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.EARTH, Forfeit.create("poison_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400, 1))));
        Forfeit.add(Tier.ADVANCED, Element.EARTH, Forfeit.create("flood", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K && EntityUtils.canDamageBlocks((Entity)p, w)) {
                List<BlockPos> sphere = BlockUtils.getBlockSphere(p.func_180425_c().func_177984_a(), 2.0);
                sphere.removeIf(pos -> !BlockUtils.canBlockBeReplaced(w, pos, true) || !BlockUtils.canPlaceBlock((Entity)p, w, pos));
                sphere.forEach(pos -> w.func_175656_a(pos, Blocks.field_150355_j.func_176223_P()));
            }
        }));
        Forfeit.add(Tier.MASTER, Element.EARTH, Forfeit.create("bury_self", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                List<BlockPos> sphere = BlockUtils.getBlockSphere(p.func_180425_c(), 4.0);
                sphere.removeIf(pos -> !w.func_180495_p(pos).func_185917_h() || BlockUtils.isBlockUnbreakable(w, pos) || BlockUtils.canBreakBlock((Entity)p, w, pos));
                sphere.forEach(pos -> {
                    EntityFallingBlock block = new EntityFallingBlock(w, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, w.func_180495_p(pos));
                    block.field_70181_x = 0.3 * (double)(4 - (p.func_180425_c().func_177956_o() - pos.func_177956_o()));
                    w.func_72838_d((Entity)block);
                });
            }
        }));
        Forfeit.add(Tier.NOVICE, Element.SORCERY, Forfeit.create("spill_inventory", (World w, EntityPlayer p) -> {
            for (int i = 0; i < p.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)p.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b()) continue;
                p.func_146097_a(stack, true, false);
                p.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.SORCERY, Forfeit.create("teleport_self", (World w, EntityPlayer p) -> ((Banish)Spells.banish).teleport((EntityLivingBase)p, (World)w, 8.0 + w.field_73012_v.nextDouble() * 8.0)));
        Forfeit.add(Tier.ADVANCED, Element.SORCERY, Forfeit.create("levitate_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200))));
        Forfeit.add(Tier.ADVANCED, Element.SORCERY, Forfeit.create("vex_horde", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 4 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, 4, 2)) != null; ++i) {
                    EntityVexMinion vex = new EntityVexMinion((World)w);
                    vex.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)vex);
                }
            }
        }));
        Forfeit.add(Tier.MASTER, Element.SORCERY, Forfeit.create("black_hole", (World w, EntityPlayer p) -> {
            EntityBlackHole blackHole = new EntityBlackHole((World)w);
            Vec3d vec = p.func_174824_e(1.0f).func_178787_e(p.func_70040_Z().func_186678_a(4.0));
            blackHole.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            w.func_72838_d((Entity)blackHole);
        }));
        Forfeit.add(Tier.MASTER, Element.SORCERY, Forfeit.create("arrow_rain", (World w, EntityPlayer p) -> {
            if (!w.field_72995_K) {
                EntityArrowRain arrowRain = new EntityArrowRain((World)w);
                arrowRain.func_70107_b(p.field_70165_t, p.field_70163_u + 5.0, p.field_70161_v - 3.0);
                w.func_72838_d((Entity)arrowRain);
            }
        }));
        Forfeit.add(Tier.MASTER, Element.SORCERY, Forfeit.create("teleport_self_large_distance", (World w, EntityPlayer p) -> ((Banish)Spells.banish).teleport((EntityLivingBase)p, (World)w, 8.0 + w.field_73012_v.nextDouble() * 700.0)));
        Forfeit.add(Tier.NOVICE, Element.HEALING, Forfeit.create("damage_self", (World w, EntityPlayer p) -> p.func_70097_a(DamageSource.field_76376_m, 4.0f)));
        Forfeit.add(Tier.NOVICE, Element.HEALING, Forfeit.create("spill_armour", (World w, EntityPlayer p) -> {
            for (int i = 0; i < p.field_71071_by.field_70460_b.size(); ++i) {
                ItemStack stack = (ItemStack)p.field_71071_by.field_70460_b.get(i);
                if (stack.func_190926_b()) continue;
                p.func_146097_a(stack, true, false);
                p.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
            }
        }));
        Forfeit.add(Tier.APPRENTICE, Element.HEALING, Forfeit.create("hunger", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 400, 4))));
        Forfeit.add(Tier.APPRENTICE, Element.HEALING, Forfeit.create("blind_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200))));
        Forfeit.add(Tier.ADVANCED, Element.HEALING, Forfeit.create("weaken_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 600, 3))));
        Forfeit.add(Tier.ADVANCED, Element.HEALING, Forfeit.create("jam_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(WizardryPotions.arcane_jammer, 300))));
        Forfeit.add(Tier.MASTER, Element.HEALING, Forfeit.create("curse_self", (World w, EntityPlayer p) -> p.func_70690_d(new PotionEffect(WizardryPotions.curse_of_undeath, Integer.MAX_VALUE))));
    }
}

