/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.Multimap;
import electroblob.wizardry.entity.construct.EntityHammer;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemLightningHammer
extends Item
implements IConjuredItem {
    public static final String DURATION_NBT_KEY = "duration";
    public static final String DAMAGE_MULTIPLIER_NBT_KEY = "damageMultiplier";
    public static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("d4c3bd93-c8e3-49c5-b35b-9356663bad1b");
    private static final double ATTACK_SPEED = -3.2;
    private static final double CHAINING_RANGE = 4.0;
    private static final float CHAINING_DAMAGE = 4.0f;
    private static final double THROW_SPEED = 0.75;
    private static final double MOVEMENT_SPEED_REDUCTION = -0.25;

    public ItemLightningHammer() {
        this.func_77656_e(600);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(null);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(DURATION_NBT_KEY)) {
            return stack.func_77978_p().func_74762_e(DURATION_NBT_KEY);
        }
        return super.getMaxDamage(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return IConjuredItem.getTimerBarColour(stack);
    }

    @Override
    private float getDamageMultiplier(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(DAMAGE_MULTIPLIER_NBT_KEY)) {
            return stack.func_77978_p().func_74760_g(DAMAGE_MULTIPLIER_NBT_KEY);
        }
        return 1.0f;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            float attackDamage = Spells.lightning_hammer.arePropertiesInitialised() ? Spells.lightning_hammer.getProperty("direct_damage").floatValue() : 10.0f;
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.2, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "Weapon modifier", -0.25, 1));
        }
        return multimap;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        int damage = stack.func_77952_i();
        if (damage > stack.func_77958_k()) {
            InventoryUtils.replaceItemInInventory(entity, slot, stack, ItemStack.field_190927_a);
        }
        stack.func_77964_b(damage + 1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EntityHammer hammer = new EntityHammer(world);
            Vec3d look = player.func_70040_Z();
            Vec3d vec = player.func_174824_e(1.0f).func_178787_e(look);
            hammer.func_70080_a(vec.field_72450_a, vec.field_72448_b - (double)(hammer.field_70131_O / 2.0f), vec.field_72449_c, player.field_70759_as - 90.0f, 0.0f);
            hammer.field_70127_C = hammer.field_70125_A = 180.0f + player.field_70125_A;
            float attackStrength = player.func_184825_o(0.0f);
            double speed = 0.75 * (double)attackStrength;
            hammer.func_70024_g(look.field_72450_a * speed, look.field_72448_b * speed, look.field_72449_c * speed);
            hammer.lifetime = stack.func_77958_k() - stack.func_77952_i();
            hammer.setCaster((EntityLivingBase)player);
            hammer.damageMultiplier = this.getDamageMultiplier(stack);
            hammer.spin = true;
            world.func_72838_d((Entity)hammer);
        }
        EntityUtils.playSoundAtPlayer(player, WizardrySounds.ENTITY_HAMMER_THROW, 1.0f, 0.8f);
        player.func_184611_a(hand, ItemStack.field_190927_a);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof ItemLightningHammer && event.getTarget() instanceof EntityLivingBase) {
            EntityPlayer wielder = event.getEntityPlayer();
            EntityLivingBase hit = (EntityLivingBase)event.getTarget();
            float attackStrength = wielder.func_184825_o(0.0f);
            double dx = wielder.field_70165_t - hit.field_70165_t;
            double dz = wielder.field_70161_v - hit.field_70161_v;
            while (dx * dx + dz * dz < 1.0E-4) {
                dx = (Math.random() - Math.random()) * 0.01;
                dz = (Math.random() - Math.random()) * 0.01;
            }
            hit.func_70653_a((Entity)wielder, 2.0f * attackStrength, dx, dz);
            if (attackStrength == 1.0f) {
                List<EntityLivingBase> nearby = EntityUtils.getLivingWithinRadius(4.0, hit.field_70165_t, hit.field_70163_u, hit.field_70161_v, hit.field_70170_p);
                nearby.remove(hit);
                nearby.remove(wielder);
                int maxTargets = Spells.lightning_hammer.getProperty("secondary_max_targets").intValue() / 2;
                while (nearby.size() > maxTargets) {
                    nearby.remove(nearby.size() - 1);
                }
                for (EntityLivingBase target : nearby) {
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)wielder, MagicDamage.DamageType.SHOCK), 4.0f * ((ItemLightningHammer)stack.func_77973_b()).getDamageMultiplier(stack));
                    if (!hit.field_70170_p.field_72995_K) continue;
                    ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(hit.func_174791_d().func_72441_c(0.0, (double)(hit.field_70131_O / 2.0f), 0.0)).target((Entity)target).spawn(hit.field_70170_p);
                    ParticleBuilder.spawnShockParticles(hit.field_70170_p, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                }
            }
        }
    }
}

