/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtVillager;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySpectralGolem
extends EntityIronGolem
implements ISummonedCreature {
    private static final DataParameter<Boolean> SPAWN_PARTICLES = EntityDataManager.func_187226_a(EntitySpectralGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lifetime = -1;
    private UUID casterUUID;

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Override
    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntitySpectralGolem(World world) {
        super(world);
        this.field_70728_aV = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWN_PARTICLES, (Object)true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookAtVillager((EntityIronGolem)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
        if (this.field_70170_p.field_72995_K) {
            double x = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            double y = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()) + (double)0.2f;
            double z = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y, z).clr(0.7f, 0.9f, 1.0f).shaded(true).spawn(this.field_70170_p);
        }
    }

    @Override
    public void onSpawn() {
        if (((Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES)).booleanValue()) {
            this.spawnParticleEffect();
        }
    }

    @Override
    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 2.0f), this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean hasParticleEffect() {
        return true;
    }

    @Override
    public boolean hasAnimation() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES) != false || this.field_70173_aa > 20;
    }

    public void hideParticles() {
        this.field_70180_af.func_187227_b(SPAWN_PARTICLES, (Object)false);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.writeNBTDelegate(nbttagcompound);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.readNBTDelegate(nbttagcompound);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType);
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }
}

