/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityTornado
extends EntityScaledConstruct {
    private double velX;
    private double velZ;

    public EntityTornado(World world) {
        super(world);
        this.func_70105_a(Spells.tornado.getProperty("effect_radius").floatValue(), 8.0f);
        this.field_70178_ae = false;
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.velX = velX;
        this.velZ = velZ;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        double radius = this.field_70130_N / 2.0f;
        if (this.field_70173_aa % 120 == 1 && this.field_70170_p.field_72995_K) {
            Wizardry.proxy.playMovingSound(this, WizardrySounds.ENTITY_TORNADO_AMBIENT, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
        }
        this.func_70091_d(MoverType.SELF, this.velX, this.field_70181_x, this.velZ);
        BlockPos pos = new BlockPos((Entity)this);
        Integer y = BlockUtils.getNearestSurface(this.field_70170_p, pos.func_177981_b(3), EnumFacing.UP, 5, true, BlockUtils.SurfaceCriteria.NOT_AIR_TO_AIR);
        if (y != null && this.field_70170_p.func_180495_p(pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p())).func_185904_a() == Material.field_151587_i) {
            this.func_70015_d(5);
        }
        if (!this.field_70170_p.field_72995_K) {
            List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
            for (EntityLivingBase target : targets) {
                if (target instanceof EntityPlayer && (this.getCaster() instanceof EntityPlayer && !Wizardry.settings.playersMoveEachOther || ItemArtefact.isArtefactActive((EntityPlayer)target, WizardryItems.amulet_anchoring)) || !this.isValidTarget((Entity)target)) continue;
                double velY = target.field_70181_x;
                double dx = (this.field_70165_t - target.field_70165_t > 0.0 ? 0.5 : -0.5) - (this.field_70165_t - target.field_70165_t) * 0.125;
                double dz = (this.field_70161_v - target.field_70161_v > 0.0 ? 0.5 : -0.5) - (this.field_70161_v - target.field_70161_v) * 0.125;
                if (this.func_70027_ad()) {
                    target.func_70015_d(4);
                }
                float damage = Spells.tornado.getProperty("damage").floatValue() * this.damageMultiplier;
                if (this.getCaster() != null) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), damage);
                } else {
                    target.func_70097_a(DamageSource.field_76376_m, damage);
                }
                target.field_70159_w = dx;
                target.field_70181_x = velY + (double)Spells.tornado.getProperty("upward_acceleration").floatValue();
                target.field_70179_y = dz;
                if (!(target instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
            }
        } else {
            for (int i = 1; i < 10; ++i) {
                int blockZ;
                double yPos = this.field_70146_Z.nextDouble() * 8.0;
                int blockX = (int)this.field_70165_t - 2 + this.field_70146_Z.nextInt(4);
                BlockPos pos1 = new BlockPos((double)blockX, this.field_70163_u + 3.0, (double)(blockZ = (int)this.field_70161_v - 2 + this.field_70146_Z.nextInt(4)));
                Integer blockY = BlockUtils.getNearestSurface(this.field_70170_p, pos1, EnumFacing.UP, 5, true, BlockUtils.SurfaceCriteria.NOT_AIR_TO_AIR);
                if (blockY == null) continue;
                Integer dz = blockY;
                Integer n = blockY = Integer.valueOf(blockY - 1);
                IBlockState block = this.field_70170_p.func_180495_p(pos1 = new BlockPos(pos1.func_177958_n(), blockY.intValue(), pos1.func_177952_p()));
                if (!EntityTornado.canTornadoPickUpBitsOf(block)) {
                    block = this.field_70170_p.func_180494_b((BlockPos)pos1).field_76752_A;
                }
                Wizardry.proxy.spawnTornadoParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u + yPos, this.field_70161_v, this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos1);
                Wizardry.proxy.spawnTornadoParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u + yPos, this.field_70161_v, this.velX, this.velZ, yPos / 3.0 + 0.5, 100, block, pos1);
                if (this.field_70146_Z.nextInt(3) != 0) continue;
                ResourceLocation type = null;
                if (block.func_185904_a() == Material.field_151584_j) {
                    type = ParticleBuilder.Type.LEAF;
                }
                if (block.func_185904_a() == Material.field_151597_y || block.func_185904_a() == Material.field_151596_z) {
                    type = ParticleBuilder.Type.SNOW;
                }
                if (type == null) continue;
                double yPos1 = this.field_70146_Z.nextDouble() * 8.0;
                ParticleBuilder.create(type).pos(this.field_70165_t + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5), this.field_70163_u + yPos1, this.field_70161_v + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (yPos1 / 3.0 + 0.5)).time(40 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            }
        }
    }

    private static boolean canTornadoPickUpBitsOf(IBlockState block) {
        Material material = block.func_185904_a();
        return material == Material.field_151596_z || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151587_i || material == Material.field_151595_p || material == Material.field_151597_y || material == Material.field_151586_h || material == Material.field_151585_k || material == Material.field_151584_j || material == Material.field_151582_l;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.velX = nbttagcompound.func_74769_h("velX");
        this.velZ = nbttagcompound.func_74769_h("velZ");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("velX", this.velX);
        nbttagcompound.func_74780_a("velZ", this.velZ);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeDouble(this.velX);
        data.writeDouble(this.velZ);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.velX = data.readDouble();
        this.velZ = data.readDouble();
    }
}

