/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.entity.layers;

import electroblob.wizardry.client.renderer.entity.layers.LayerTiledOverlay;
import electroblob.wizardry.entity.living.ISummonedCreature;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class LayerSummonAnimation<T extends EntityLivingBase>
extends LayerTiledOverlay<T> {
    private static final int ANIMATION_TICKS = 19;
    private static final int HIDE_MODEL_TICKS = 9;
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[19];

    public LayerSummonAnimation(RenderLivingBase<?> renderer) {
        super(renderer, 32, 32);
    }

    @Override
    public boolean shouldRender(T entity, float partialTicks) {
        return entity instanceof ISummonedCreature && ((ISummonedCreature)entity).hasAnimation() && ((ISummonedCreature)entity).getLifetime() > 0 && this.getFrameNumber(entity) < 19;
    }

    @Override
    public ResourceLocation getTexture(T entity, float partialTicks) {
        return TEXTURES[this.getFrameNumber(entity)];
    }

    private int getFrameNumber(T entity) {
        if (!(entity instanceof ISummonedCreature)) {
            throw new IllegalArgumentException("Entity must be an ISummonedCreature");
        }
        return Math.min(((EntityLivingBase)entity).field_70173_aa, Math.max(((ISummonedCreature)entity).getLifetime() - ((EntityLivingBase)entity).field_70173_aa - 1, 0));
    }

    @Override
    public void func_177141_a(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(entity instanceof ISummonedCreature)) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int colour = ((ISummonedCreature)entity).getAnimationColour((float)this.getFrameNumber(entity) / 19.0f);
        GlStateManager.func_179124_c((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f));
        super.func_177141_a(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (LayerSummonAnimation.shouldHideMainModel(event.getEntity())) {
            event.getEntity().func_82142_c(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEvent(RenderLivingEvent.Post<EntityLivingBase> event) {
        if (LayerSummonAnimation.shouldHideMainModel(event.getEntity())) {
            event.getEntity().func_82142_c(false);
        }
    }

    private static boolean shouldHideMainModel(EntityLivingBase entity) {
        return entity instanceof ISummonedCreature && ((ISummonedCreature)entity).hasAnimation() && ((ISummonedCreature)entity).getLifetime() > 0 && (entity.field_70173_aa < 9 || ((ISummonedCreature)entity).getLifetime() - entity.field_70173_aa < 9);
    }

    static {
        for (int i = 0; i < 19; ++i) {
            LayerSummonAnimation.TEXTURES[i] = new ResourceLocation("ebwizardry", "textures/entity/summon_overlay/summon_overlay_" + i + ".png");
        }
    }
}

