/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer.effect;

import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.misc.DonationPerksHandler;
import electroblob.wizardry.util.GeometryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderDonationPerks {
    private static final ResourceLocation FLARE_TEXTURE = new ResourceLocation("ebwizardry", "textures/entity/totem/flare.png");
    private static final ResourceLocation[] CUBE_TEXTURES = new ResourceLocation[14];
    private static final float BOBBING_PERIOD = 25.0f;
    private static final float ROTATION_PERIOD = 60.0f;
    private static final double ROTATION_RADIUS = 0.7;
    private static final double HEIGHT_FRACTION = 0.8;
    private static final double BOBBING_DISTANCE = 0.2;
    private static final double FOLLOW_DISTANCE = 1.4;

    @SubscribeEvent
    public static void onRenderPlayerEvent(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        float partialTicks = event.getPartialRenderTick();
        Element element = DonationPerksHandler.getElement(player);
        if (element != null) {
            int c1 = BlockReceptacle.PARTICLE_COLOURS.get((Object)element)[0];
            int r1 = (c1 & 0xFF0000) >> 16;
            int g1 = (c1 & 0xFF00) >> 8;
            int b1 = c1 & 0xFF;
            int c2 = BlockReceptacle.PARTICLE_COLOURS.get((Object)element)[2];
            int r2 = (c2 & 0xFF0000) >> 16;
            int g2 = (c2 & 0xFF00) >> 8;
            int b2 = c2 & 0xFF;
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            double x1 = player.field_71094_bP - player.field_70165_t;
            double y1 = player.field_71095_bQ - player.field_70163_u;
            double z1 = player.field_71085_bR - player.field_70161_v;
            double x2 = player.field_71091_bM - player.field_70169_q;
            double y2 = player.field_71096_bN - player.field_70167_r;
            double z2 = player.field_71097_bO - player.field_70166_s;
            double dx = x2 + (x1 - x2) * (double)partialTicks;
            double dy = y2 + (y1 - y2) * (double)partialTicks;
            double dz = z2 + (z1 - z2) * (double)partialTicks;
            float t = (float)player.field_70173_aa + partialTicks;
            float hMoveFraction = MathHelper.func_76131_a((float)((float)(dx * dx + dz * dz) / 0.3f), (float)0.0f, (float)1.0f);
            float vMoveFraction = MathHelper.func_76131_a((float)((float)(dy * dy) / 0.3f), (float)0.0f, (float)1.0f);
            double x = event.getX() + 0.7 * (double)MathHelper.func_76126_a((float)(t / 60.0f)) * (double)(1.0f - hMoveFraction) + 1.4 * dx;
            double y = event.getY() + 0.8 * (double)player.field_70131_O + 0.2 * (double)MathHelper.func_76126_a((float)(t / 25.0f)) * (double)(1.0f - vMoveFraction) + 1.4 * dy;
            double z = event.getZ() + 0.7 * (double)MathHelper.func_76134_b((float)(t / 60.0f)) * (double)(1.0f - hMoveFraction) + 1.4 * dz;
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)260);
            GlStateManager.func_179124_c((float)((float)r1 / 255.0f), (float)((float)g1 / 255.0f), (float)((float)b1 / 255.0f));
            RenderDonationPerks.drawFlare(tessellator);
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
            GlStateManager.func_179124_c((float)((float)r2 / 255.0f), (float)((float)g2 / 255.0f), (float)((float)b2 / 255.0f));
            RenderDonationPerks.drawCube(player, tessellator, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private static void drawFlare(Tessellator tessellator) {
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(FLARE_TEXTURE);
        float yaw = Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? Minecraft.func_71410_x().func_175598_ae().field_78732_j : -Minecraft.func_71410_x().func_175598_ae().field_78732_j;
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yaw, (float)1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float r = 0.5f;
        buffer.func_181662_b((double)(-r), (double)r, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)r, (double)r, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)r, (double)(-r), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-r), (double)(-r), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void drawCube(EntityPlayer player, Tessellator tessellator, float partialTicks) {
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        float age = (float)player.field_70173_aa + partialTicks;
        float rotationSpeed = 2.0f;
        GlStateManager.func_179114_b((float)(age * rotationSpeed / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)60.0f, (float)0.7071f, (float)0.0f, (float)0.7071f);
        GlStateManager.func_179114_b((float)(age * rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179112_b((int)770, (int)1);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(CUBE_TEXTURES[player.field_70173_aa % CUBE_TEXTURES.length]);
        Vec3d[] vertices = GeometryUtils.getVertices(new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5));
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderDonationPerks.drawFace(buffer, vertices[0], vertices[1], vertices[3], vertices[2], 0.5f, 0.0f, 0.75f, 0.5f);
        RenderDonationPerks.drawFace(buffer, vertices[6], vertices[7], vertices[2], vertices[3], 0.75f, 0.5f, 1.0f, 1.0f);
        RenderDonationPerks.drawFace(buffer, vertices[5], vertices[6], vertices[1], vertices[2], 0.0f, 0.5f, 0.25f, 1.0f);
        RenderDonationPerks.drawFace(buffer, vertices[4], vertices[5], vertices[0], vertices[1], 0.25f, 0.5f, 0.5f, 1.0f);
        RenderDonationPerks.drawFace(buffer, vertices[7], vertices[4], vertices[3], vertices[0], 0.5f, 0.5f, 0.75f, 1.0f);
        RenderDonationPerks.drawFace(buffer, vertices[5], vertices[4], vertices[6], vertices[7], 0.25f, 0.0f, 0.5f, 0.5f);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void drawFace(BufferBuilder buffer, Vec3d topLeft, Vec3d topRight, Vec3d bottomLeft, Vec3d bottomRight, float u1, float v1, float u2, float v2) {
        buffer.func_181662_b(topLeft.field_72450_a, topLeft.field_72448_b, topLeft.field_72449_c).func_187315_a((double)u1, (double)v1).func_181675_d();
        buffer.func_181662_b(topRight.field_72450_a, topRight.field_72448_b, topRight.field_72449_c).func_187315_a((double)u2, (double)v1).func_181675_d();
        buffer.func_181662_b(bottomRight.field_72450_a, bottomRight.field_72448_b, bottomRight.field_72449_c).func_187315_a((double)u2, (double)v2).func_181675_d();
        buffer.func_181662_b(bottomLeft.field_72450_a, bottomLeft.field_72448_b, bottomLeft.field_72449_c).func_187315_a((double)u1, (double)v2).func_181675_d();
    }

    static {
        for (int i = 0; i < CUBE_TEXTURES.length; ++i) {
            RenderDonationPerks.CUBE_TEXTURES[i] = new ResourceLocation("ebwizardry", "textures/entity/totem/cube_" + i + ".png");
        }
    }
}

