/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelGlowingOverlay
implements IBakedModel {
    private final IBakedModel delegate;
    private String suffix;
    private static final VertexFormat ITEM_FORMAT_WITH_LIGHTMAP = new VertexFormat(DefaultVertexFormats.field_176599_b).func_181721_a(DefaultVertexFormats.field_181716_p);

    public BakedModelGlowingOverlay(IBakedModel delegate, String suffix) {
        this.delegate = delegate;
        this.suffix = suffix;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return this.delegate.func_188616_a(state, side, rand);
        }
        return BakedModelGlowingOverlay.transformQuads(this.delegate.func_188616_a(state, side, rand), this.suffix);
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> oldQuads, String suffix) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(oldQuads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (!quad.func_187508_a().func_94215_i().endsWith(suffix)) continue;
            quads.set(i, BakedModelGlowingOverlay.transformQuad(quad, 0.007f));
        }
        return quads;
    }

    private static BakedQuad transformQuad(BakedQuad quad, final float light) {
        if (BakedModelGlowingOverlay.isLightMapDisabled()) {
            return quad;
        }
        VertexFormat newFormat = BakedModelGlowingOverlay.getFormatWithLightMap(quad.getFormat());
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(newFormat);
        VertexLighterFlat trans = new VertexLighterFlat(Minecraft.func_71410_x().func_184125_al()){

            protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
                lightmap[0] = light;
                lightmap[1] = light;
            }

            public void setQuadTint(int tint) {
            }
        };
        trans.setParent((IVertexConsumer)builder);
        quad.pipe((IVertexConsumer)trans);
        builder.setQuadTint(quad.func_178211_c());
        builder.setQuadOrientation(quad.func_178210_d());
        builder.setTexture(quad.func_187508_a());
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }

    public boolean func_177555_b() {
        return this.delegate.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.delegate.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.delegate.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.delegate.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.delegate.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.delegate.func_188617_f();
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.delegate.isAmbientOcclusion(state);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.delegate.handlePerspective(cameraTransformType);
    }

    private static boolean isLightMapDisabled() {
        return FMLClientHandler.instance().hasOptifine() || !ForgeModContainer.forgeLightPipelineEnabled;
    }

    private static VertexFormat getFormatWithLightMap(VertexFormat format) {
        if (BakedModelGlowingOverlay.isLightMapDisabled()) {
            return format;
        }
        if (format == DefaultVertexFormats.field_176600_a) {
            return DefaultVertexFormats.field_176600_a;
        }
        if (format == DefaultVertexFormats.field_176599_b) {
            return ITEM_FORMAT_WITH_LIGHTMAP;
        }
        if (!format.func_177347_a(1)) {
            VertexFormat result = new VertexFormat(format);
            result.func_181721_a(DefaultVertexFormats.field_181716_p);
            return result;
        }
        return format;
    }
}

