/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.ClientProxy;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.MixedFontRenderer;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiSpellDisplay {
    private static final ResourceLocation INDEX = new ResourceLocation("ebwizardry", "textures/gui/spell_hud/_index.json");
    private static final ResourceLocation CHARGE_METER = new ResourceLocation("ebwizardry", "textures/gui/spell_charge_meter.png");
    private static final Map<String, Skin> skins = new LinkedHashMap<String, Skin>(14);
    private static final Gson gson = new Gson();
    private static final Random random = new Random();
    private static final int CHARGE_METER_WIDTH = 25;
    private static final int CHARGE_METER_HEIGHT = 9;
    private static final int SPELL_ICON_SIZE = 32;
    private static final int SPELL_SWITCH_TIME = 4;
    private static final float SPELL_NAME_SCALE = 0.5f;
    private static final float SPELL_NAME_OPACITY = 0.3f;
    private static final int HALF_HOTBAR_WIDTH = 97;
    private static final int OFFHAND_SLOT_WIDTH = 29;
    private static int switchTimer = 0;

    public static void playSpellSwitchAnimation(boolean next) {
        switchTimer = next ? 4 : -4;
    }

    public static Set<String> getSkinKeys() {
        return Collections.unmodifiableSet(skins.keySet());
    }

    public static Map<String, Skin> getSkins() {
        return Collections.unmodifiableMap(skins);
    }

    @Nullable
    public static Skin getSkin(String key) {
        Skin skin = skins.get(key);
        if (skin == null) {
            Wizardry.logger.info("The spell HUD skin '" + Wizardry.settings.spellHUDSkin + "' specified in the config did not match any of the loaded skins; using the default skin as a fallback.");
            skin = skins.get("default");
            if (skin == null) {
                Wizardry.logger.warn("The default spell HUD skin is missing! A resource pack must have overridden it with an invalid JSON file (default.json), please try again without any resource packs.");
                return null;
            }
        }
        return skin;
    }

    @SubscribeEvent
    public static void draw(RenderGameOverlayEvent.Post event) {
        if (!Wizardry.settings.showSpellHUD && !Wizardry.settings.showChargeMeter) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_175149_v()) {
            return;
        }
        ItemStack wand = player.func_184614_ca();
        boolean mainHand = true;
        if (!(wand.func_77973_b() instanceof ISpellCastingItem) || !((ISpellCastingItem)wand.func_77973_b()).showSpellHUD((EntityPlayer)player, wand)) {
            wand = player.func_184592_cb();
            mainHand = false;
            if (!(wand.func_77973_b() instanceof ISpellCastingItem) || !((ISpellCastingItem)wand.func_77973_b()).showSpellHUD((EntityPlayer)player, wand)) {
                return;
            }
        }
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        switch (event.getType()) {
            case CROSSHAIRS: {
                GuiSpellDisplay.renderChargeMeter((EntityPlayer)player, wand, width, height, event.getPartialTicks());
                break;
            }
            case HOTBAR: {
                GuiSpellDisplay.renderSpellHUD((EntityPlayer)player, wand, mainHand, width, height, event.getPartialTicks(), false);
                break;
            }
            case TEXT: {
                GuiSpellDisplay.renderSpellHUD((EntityPlayer)player, wand, mainHand, width, height, event.getPartialTicks(), true);
            }
        }
    }

    private static void renderChargeMeter(EntityPlayer player, ItemStack wand, int width, int height, float partialTicks) {
        if (!Wizardry.settings.showChargeMeter) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return;
        }
        if (wand != player.func_184607_cu()) {
            return;
        }
        if (!(wand.func_77973_b() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        Spell spell = ((ISpellCastingItem)wand.func_77973_b()).getCurrentSpell(wand);
        int chargeup = spell.getChargeup();
        if (WizardData.get(player) != null) {
            chargeup = (int)((float)chargeup * WizardData.get((EntityPlayer)player).itemCastingModifiers.get("chargeup"));
        }
        if (chargeup <= 0) {
            return;
        }
        if (player.func_184612_cw() == 0) {
            return;
        }
        float charge = ((float)player.func_184612_cw() + partialTicks) / (float)chargeup;
        if (charge > 1.0f) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(CHARGE_METER);
        int x1 = width / 2 - 12;
        int y = height / 2 - 4;
        int w = (int)(12.0f * charge);
        int u = 25 - w;
        DrawingUtils.drawTexturedRect(x1, y, 0, 0, w, 9, 32, 32);
        DrawingUtils.drawTexturedRect(x1 + u, y, u, 0, w, 9, 32, 32);
    }

    private static void renderSpellHUD(EntityPlayer player, ItemStack wand, boolean mainHand, int width, int height, float partialTicks, boolean textLayer) {
        Skin skin;
        if (!Wizardry.settings.showSpellHUD) {
            return;
        }
        if (!(wand.func_77973_b() instanceof ISpellCastingItem)) {
            throw new IllegalArgumentException("The given stack must contain an ISpellCastingItem!");
        }
        boolean flipX = Wizardry.settings.spellHUDPosition.flipX;
        boolean flipY = Wizardry.settings.spellHUDPosition.flipY;
        if (Wizardry.settings.spellHUDPosition.dynamic) {
            boolean bl = flipX = flipX == ((mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a()) == EnumHandSide.LEFT);
        }
        if ((skin = GuiSpellDisplay.getSkin(Wizardry.settings.spellHUDSkin)) == null) {
            return;
        }
        GlStateManager.func_179094_E();
        int x = flipX ? width : 0;
        int y = flipY ? 0 : height;
        float xSpace = width / 2 - 97;
        if (!player.func_184592_cb().func_190926_b() && player.func_184591_cq() == EnumHandSide.LEFT == flipX) {
            xSpace -= 29.0f;
        }
        if (!flipY && (float)skin.getWidth() > xSpace) {
            float scale = xSpace / (float)skin.getWidth();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            x = MathHelper.func_76123_f((float)((float)x / scale));
            y = MathHelper.func_76123_f((float)((float)y / scale));
        }
        Spell spell = ((ISpellCastingItem)wand.func_77973_b()).getCurrentSpell(wand);
        int cooldown = ((ISpellCastingItem)wand.func_77973_b()).getCurrentCooldown(wand);
        int maxCooldown = ((ISpellCastingItem)wand.func_77973_b()).getCurrentMaxCooldown(wand);
        if (textLayer) {
            float animationProgress = Math.signum(switchTimer) * (((float)(4 - Math.abs(switchTimer)) + partialTicks) / 4.0f);
            String prevSpellName = GuiSpellDisplay.getFormattedSpellName(((ISpellCastingItem)wand.func_77973_b()).getPreviousSpell(wand), player, 0);
            String spellName = GuiSpellDisplay.getFormattedSpellName(spell, player, cooldown);
            String nextSpellName = GuiSpellDisplay.getFormattedSpellName(((ISpellCastingItem)wand.func_77973_b()).getNextSpell(wand), player, 0);
            skin.drawText(x, y, flipX, flipY, prevSpellName, spellName, nextSpellName, animationProgress);
        } else {
            boolean discovered = true;
            if (!player.func_184812_l_() && WizardData.get(player) != null) {
                discovered = WizardData.get(player).hasSpellBeenDiscovered(spell);
            }
            ResourceLocation icon = discovered ? spell.getIcon() : Spells.none.getIcon();
            float progress = 1.0f;
            if (!player.func_184812_l_()) {
                progress = maxCooldown == 0 ? 1.0f : ((float)maxCooldown - (float)cooldown + partialTicks) / (float)maxCooldown;
            }
            skin.drawBackground(x, y, flipX, flipY, icon, progress, player.func_184812_l_(), player.func_70644_a(WizardryPotions.arcane_jammer));
        }
        GlStateManager.func_179121_F();
    }

    private static String getFormattedSpellName(Spell spell, EntityPlayer player, int cooldown) {
        String format;
        boolean discovered = true;
        if (!player.func_184812_l_() && WizardData.get(player) != null) {
            discovered = WizardData.get(player).hasSpellBeenDiscovered(spell);
        }
        String string = format = cooldown > 0 ? "\u00a78" : spell.getElement().getFormattingCode();
        if (!discovered) {
            format = "\u00a79";
        }
        if (player.func_70644_a(WizardryPotions.arcane_jammer)) {
            format = format + "\u00a7k";
        }
        String name = discovered ? spell.getDisplayName() : SpellGlyphData.getGlyphName(spell, player.field_70170_p);
        name = format + name;
        if (!discovered) {
            name = "#" + name + "#";
        }
        return name;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            if (switchTimer > 0) {
                --switchTimer;
            } else if (switchTimer < 0) {
                ++switchTimer;
            }
        }
    }

    public static void loadSkins(IResourceManager manager) {
        try {
            List indexFiles = manager.func_135056_b(INDEX);
            skins.clear();
            for (IResource indexFile : indexFiles) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(indexFile.func_110527_b(), StandardCharsets.UTF_8));
                JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                JsonObject json = je.getAsJsonObject();
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonObject skinData = JsonUtils.func_152754_s((JsonObject)json, (String)key);
                    String[] splitName = ResourceLocation.func_177516_a((String)JsonUtils.func_151200_h((JsonObject)skinData, (String)"texture"));
                    ResourceLocation texture = new ResourceLocation(splitName[0], "textures/" + splitName[1] + ".png");
                    splitName = ResourceLocation.func_177516_a((String)JsonUtils.func_151200_h((JsonObject)skinData, (String)"metadata"));
                    ResourceLocation metadata = new ResourceLocation(splitName[0], "textures/" + splitName[1] + ".json");
                    skins.put(key, new Skin(texture, metadata));
                }
            }
        }
        catch (IOException e) {
            Wizardry.logger.error("Error reading spell HUD skin index file: ", (Throwable)e);
        }
    }

    public static class Skin {
        private final ResourceLocation texture;
        private String name;
        private String description;
        private int width;
        private int height;
        private boolean mirrorX;
        private boolean mirrorY;
        private int spellIconInsetX;
        private int spellIconInsetY;
        private int textInsetX;
        private int textInsetY;
        private int cascadeOffsetX;
        private int cascadeOffsetY;
        private int cooldownBarX;
        private int cooldownBarY;
        private int cooldownBarLength;
        private int cooldownBarHeight;
        private boolean cooldownBarMirrorX;
        private boolean cooldownBarMirrorY;
        private boolean showCooldownWhenFull;
        private final Minecraft mc = Minecraft.func_71410_x();

        public Skin(ResourceLocation texture, ResourceLocation metadata) {
            this.texture = texture;
            try {
                IResource metadataFile = Minecraft.func_71410_x().func_110442_L().func_110536_a(metadata);
                BufferedReader reader = new BufferedReader(new InputStreamReader(metadataFile.func_110527_b(), StandardCharsets.UTF_8));
                JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                this.parseJson(je.getAsJsonObject());
            }
            catch (IOException e) {
                Wizardry.logger.error("Error reading spell HUD skin metadata file: ", (Throwable)e);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        private void parseJson(JsonObject json) {
            this.name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
            this.description = JsonUtils.func_151200_h((JsonObject)json, (String)"description");
            this.width = JsonUtils.func_151203_m((JsonObject)json, (String)"width");
            if (this.width > 128) {
                Wizardry.logger.warn("The width of the spell HUD skin " + this.name + " exceeds 128, this may cause it to render strangely.");
            }
            this.height = JsonUtils.func_151203_m((JsonObject)json, (String)"height");
            JsonObject mirror = JsonUtils.func_152754_s((JsonObject)json, (String)"mirror");
            this.mirrorX = JsonUtils.func_151212_i((JsonObject)mirror, (String)"x");
            this.mirrorY = JsonUtils.func_151212_i((JsonObject)mirror, (String)"y");
            JsonObject spellIconInset = JsonUtils.func_152754_s((JsonObject)json, (String)"spell_icon_inset");
            this.spellIconInsetX = JsonUtils.func_151203_m((JsonObject)spellIconInset, (String)"x");
            this.spellIconInsetY = JsonUtils.func_151203_m((JsonObject)spellIconInset, (String)"y");
            JsonObject textInset = JsonUtils.func_152754_s((JsonObject)json, (String)"text_inset");
            this.textInsetX = JsonUtils.func_151203_m((JsonObject)textInset, (String)"x");
            this.textInsetY = JsonUtils.func_151203_m((JsonObject)textInset, (String)"y");
            JsonObject cascadeOffset = JsonUtils.func_152754_s((JsonObject)json, (String)"spell_cascade_offset");
            this.cascadeOffsetX = JsonUtils.func_151203_m((JsonObject)cascadeOffset, (String)"x");
            this.cascadeOffsetY = JsonUtils.func_151203_m((JsonObject)cascadeOffset, (String)"y");
            JsonObject cooldownBar = JsonUtils.func_152754_s((JsonObject)json, (String)"cooldown_bar");
            this.cooldownBarX = JsonUtils.func_151203_m((JsonObject)cooldownBar, (String)"x");
            this.cooldownBarY = JsonUtils.func_151203_m((JsonObject)cooldownBar, (String)"y");
            this.cooldownBarLength = JsonUtils.func_151203_m((JsonObject)cooldownBar, (String)"length");
            this.cooldownBarHeight = JsonUtils.func_151203_m((JsonObject)cooldownBar, (String)"height");
            JsonObject cooldownBarMirror = JsonUtils.func_152754_s((JsonObject)cooldownBar, (String)"mirror");
            this.cooldownBarMirrorX = JsonUtils.func_151212_i((JsonObject)cooldownBarMirror, (String)"x");
            this.cooldownBarMirrorY = JsonUtils.func_151212_i((JsonObject)cooldownBarMirror, (String)"y");
            this.showCooldownWhenFull = JsonUtils.func_151212_i((JsonObject)cooldownBar, (String)"show_when_full");
        }

        public void drawBackground(int x, int y, boolean flipX, boolean flipY, ResourceLocation icon, float cooldownBarProgress, boolean creativeMode, boolean jammed) {
            int y1;
            if (flipX && !this.mirrorX) {
                x -= this.width;
            }
            if (flipY && !this.mirrorY) {
                y += this.height;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(icon);
            int x1 = flipX && this.mirrorX ? x - this.spellIconInsetX - 32 : x + this.spellIconInsetX;
            int n = y1 = flipY && this.mirrorY ? y + this.spellIconInsetY : y - this.spellIconInsetY - 32;
            if (jammed) {
                random.setSeed(Minecraft.func_71410_x().field_71441_e.func_82737_E() / 2L);
                DrawingUtils.drawGlitchRect(random, x1, y1, 0, 0, 32, 32, 32, 32, false, false);
            } else {
                DrawingUtils.drawTexturedRect(x1, y1, 0, 0, 32, 32, 32, 32);
            }
            this.mc.field_71446_o.func_110577_a(this.texture);
            x1 = flipX && this.mirrorX ? x - this.width : x;
            int n2 = y1 = flipY && this.mirrorY ? y : y - this.height;
            if (jammed) {
                DrawingUtils.drawGlitchRect(random, x1, y1, creativeMode ? 128 : 0, 0, this.width, this.height, 256, 256, flipX && this.mirrorX, flipY && this.mirrorY);
            } else {
                DrawingUtils.drawTexturedFlippedRect(x1, y1, creativeMode ? 128 : 0, 0, this.width, this.height, 256, 256, flipX && this.mirrorX, flipY && this.mirrorY);
            }
            if (!creativeMode && cooldownBarProgress > 0.0f && (this.showCooldownWhenFull || cooldownBarProgress < 1.0f)) {
                int l = (int)(cooldownBarProgress * (float)this.cooldownBarLength);
                x1 = flipX && this.mirrorX ? x - this.cooldownBarX - (this.cooldownBarMirrorX ? l : this.cooldownBarLength) : x + this.cooldownBarX;
                y1 = flipY && this.mirrorY ? y + this.cooldownBarY : y - this.cooldownBarY - this.cooldownBarHeight;
                int u = this.cooldownBarX;
                int v = this.height;
                if (jammed) {
                    DrawingUtils.drawGlitchRect(random, x1, y1, u, v, l, this.cooldownBarHeight, 256, 256, flipX && this.cooldownBarMirrorX, flipY && this.cooldownBarMirrorY);
                } else {
                    DrawingUtils.drawTexturedFlippedRect(x1, y1, u, v, l, this.cooldownBarHeight, 256, 256, flipX && this.cooldownBarMirrorX, flipY && this.cooldownBarMirrorY);
                }
            }
            GlStateManager.func_179121_F();
        }

        public void drawText(int x, int y, boolean flipX, boolean flipY, String prevSpellName, String spellName, String nextSpellName, float animationProgress) {
            if (flipX && !this.mirrorX) {
                x -= this.width;
            }
            if (flipY && !this.mirrorY) {
                y += this.height;
            }
            MixedFontRenderer font = ClientProxy.mixedFontRenderer;
            int x1 = flipX && this.mirrorX ? x - this.width : x + this.textInsetX;
            int y1 = flipY && this.mirrorY ? y + this.textInsetY - font.field_78288_b / 2 + 2 : y - this.textInsetY - font.field_78288_b / 2 - 1;
            int maxWidth = this.width - this.textInsetX;
            if (animationProgress == 0.0f) {
                float xPrev;
                float f = flipX && this.mirrorX ? (float)(x - this.width) : (xPrev = (float)(x + this.textInsetX - (flipY ? -1 : 1) * this.cascadeOffsetX));
                float xNext = flipX && this.mirrorX ? (float)(x - this.width) : (float)(x + this.textInsetX + (flipY ? -1 : 1) * this.cascadeOffsetX);
                float yPrev = y1 - (this.cascadeOffsetY + 1);
                float yNext = y1 + this.cascadeOffsetY;
                float maxWidthPrev = maxWidth + (flipY ? -1 : 1) * this.cascadeOffsetX;
                float maxWidthNext = maxWidth - (flipY ? -1 : 1) * this.cascadeOffsetX;
                int nextPrevClr = DrawingUtils.makeTranslucent(0xFFFFFF, 0.3f);
                DrawingUtils.drawScaledStringToWidth(font, prevSpellName, xPrev, yPrev, 0.5f, nextPrevClr, maxWidthPrev, true, flipX && this.mirrorX);
                DrawingUtils.drawScaledStringToWidth(font, spellName, x1, y1, 1.0f, -1, maxWidth, true, flipX && this.mirrorX);
                DrawingUtils.drawScaledStringToWidth(font, nextSpellName, xNext, yNext, 0.5f, nextPrevClr, maxWidthNext, true, flipX && this.mirrorX);
            } else {
                float xPrev;
                boolean reverse;
                boolean bl = reverse = animationProgress < 0.0f;
                if (reverse) {
                    animationProgress = 1.0f - Math.abs(animationProgress);
                }
                float f = flipX && this.mirrorX ? (float)(x - this.width) : (xPrev = (float)(x + this.textInsetX) - (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * animationProgress);
                float xNext = flipX && this.mirrorX ? (float)(x - this.width) : (float)(x + this.textInsetX) + (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * (1.0f - animationProgress);
                float yPrev = (float)y1 - (float)(this.cascadeOffsetY + 1) * animationProgress;
                float yNext = (float)y1 + (float)this.cascadeOffsetY * (1.0f - animationProgress);
                float maxWidthPrev = (float)maxWidth + (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * animationProgress;
                float maxWidthNext = (float)maxWidth - (float)((flipY ? -1 : 1) * this.cascadeOffsetX) * (1.0f - animationProgress);
                float scalePrev = 0.5f + 0.5f * (1.0f - animationProgress);
                float scaleNext = 0.5f + 0.5f * animationProgress;
                int clrPrev = DrawingUtils.makeTranslucent(0xFFFFFF, 0.3f + 0.7f * (1.0f - animationProgress));
                int clrNext = DrawingUtils.makeTranslucent(0xFFFFFF, 0.3f + 0.7f * animationProgress);
                if (reverse) {
                    DrawingUtils.drawScaledStringToWidth(font, spellName, xPrev, yPrev, scalePrev, clrPrev, maxWidthPrev, true, flipX && this.mirrorX);
                    DrawingUtils.drawScaledStringToWidth(font, nextSpellName, xNext, yNext, scaleNext, clrNext, maxWidthNext, true, flipX && this.mirrorX);
                } else {
                    DrawingUtils.drawScaledStringToWidth(font, prevSpellName, xPrev, yPrev, scalePrev, clrPrev, maxWidthPrev, true, flipX && this.mirrorX);
                    DrawingUtils.drawScaledStringToWidth(font, spellName, xNext, yNext, scaleNext, clrNext, maxWidthNext, true, flipX && this.mirrorX);
                }
            }
        }
    }
}

