/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.client.gui.GuiButtonSpellSort;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.inventory.ContainerArcaneWorkbench;
import electroblob.wizardry.inventory.SlotBookList;
import electroblob.wizardry.inventory.VirtualSlot;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.util.ISpellSortable;
import electroblob.wizardry.util.WandHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiArcaneWorkbench
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("ebwizardry", "textures/gui/container/arcane_workbench.png");
    private static final int TOOLTIP_WIDTH = 144;
    private static final int TOOLTIP_BORDER = 6;
    private static final int LINE_SPACING_WIDE = 5;
    private static final int LINE_SPACING_NARROW = 1;
    private static final int BOOKSHELF_UI_WIDTH = 122;
    private static final int MAIN_GUI_WIDTH = 176;
    private static final int RUNE_LEFT = 38;
    private static final int RUNE_TOP = 22;
    private static final int RUNE_WIDTH = 100;
    private static final int RUNE_HEIGHT = 100;
    private static final int SCROLL_BAR_LEFT = 102;
    private static final int SCROLL_BAR_TOP = 34;
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_HEIGHT = 178;
    private static final int SCROLL_HANDLE_HEIGHT = 15;
    private static final int HALO_DIAMETER = 156;
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int ANIMATION_DURATION = 20;
    private static final int SEARCH_TOOLTIP_HOVER_TIME = 20;
    private static final Style TOOLTIP_SYNTAX = new Style().func_150238_a(TextFormatting.YELLOW);
    private static final Style TOOLTIP_BODY = new Style().func_150238_a(TextFormatting.WHITE);
    private InventoryPlayer playerInventory;
    private IInventory arcaneWorkbenchInventory;
    private ContainerArcaneWorkbench arcaneWorkbenchContainer;
    private GuiButton applyBtn;
    private GuiButton clearBtn;
    private GuiButton[] sortButtons = new GuiButton[3];
    private GuiTextField searchField;
    private boolean searchNeedsClearing;
    private int searchBarHoverTime;
    private final List<TooltipElement> tooltipElements = new ArrayList<TooltipElement>();
    private int animationTimer = 0;
    private float scroll = 0.0f;
    private boolean scrolling = false;

    public GuiArcaneWorkbench(InventoryPlayer invPlayer, TileEntityArcaneWorkbench entity) {
        super((Container)new ContainerArcaneWorkbench((IInventory)invPlayer, entity));
        this.arcaneWorkbenchContainer = (ContainerArcaneWorkbench)this.field_147002_h;
        this.playerInventory = invPlayer;
        this.arcaneWorkbenchInventory = entity;
        this.field_146999_f = 176;
        this.field_147000_g = 220;
    }

    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - 176) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.applyBtn = new GuiButtonApply(0, this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 3);
        this.field_146292_n.add(this.applyBtn);
        this.clearBtn = new GuiButtonClear(0, this.field_146294_l / 2 + 64, this.field_146295_m / 2 - 16);
        this.field_146292_n.add(this.clearBtn);
        this.sortButtons[0] = new GuiButtonSpellSort(1, this.field_147003_i - 44, this.field_147009_r + 8, ISpellSortable.SortType.TIER, this.arcaneWorkbenchContainer, (GuiScreen)this);
        this.field_146292_n.add(this.sortButtons[0]);
        this.sortButtons[1] = new GuiButtonSpellSort(2, this.field_147003_i - 31, this.field_147009_r + 8, ISpellSortable.SortType.ELEMENT, this.arcaneWorkbenchContainer, (GuiScreen)this);
        this.field_146292_n.add(this.sortButtons[1]);
        this.sortButtons[2] = new GuiButtonSpellSort(3, this.field_147003_i - 18, this.field_147009_r + 8, ISpellSortable.SortType.ALPHABETICAL, this.arcaneWorkbenchContainer, (GuiScreen)this);
        this.field_146292_n.add(this.sortButtons[2]);
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i - 113, this.field_147009_r + 22, 104, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.tooltipElements.clear();
        this.tooltipElements.add(new TooltipElementItemName(new Style().func_150238_a(TextFormatting.WHITE), 5));
        this.tooltipElements.add(new TooltipElementManaReadout(5));
        this.tooltipElements.add(new TooltipElementProgressionBar(5));
        this.tooltipElements.add(new TooltipElementSpellList(5));
        this.tooltipElements.add(new TooltipElementUpgradeList(5));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
        if (this.arcaneWorkbenchContainer.needsRefresh) {
            this.arcaneWorkbenchContainer.refreshBookshelfSlots();
            this.arcaneWorkbenchContainer.needsRefresh = false;
        }
        if (this.searchBarHoverTime > 0 && this.searchBarHoverTime < 20) {
            ++this.searchBarHoverTime;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean mouseHeld = Mouse.isButtonDown((int)0);
        if (!this.scrolling && mouseHeld && this.getMaxScrollRows() > 0 && this.func_146978_c(102, 34, 12, 178, mouseX, mouseY)) {
            this.scrolling = true;
        }
        if (!mouseHeld || this.getMaxScrollRows() == 0) {
            this.scrolling = false;
        }
        if (this.scrolling) {
            this.scroll = MathHelper.func_76131_a((float)((float)(mouseY - 34 - 7 - this.field_147009_r) / 163.0f), (float)0.0f, (float)1.0f);
            this.arcaneWorkbenchContainer.scrollTo((int)((float)this.getMaxScrollRows() * this.scroll + 0.5f));
        }
        Slot centreSlot = this.field_147002_h.func_75139_a(9);
        this.field_146999_f = 176;
        this.field_147003_i = (this.field_146294_l - 176) / 2;
        if (centreSlot.func_75216_d() && centreSlot.func_75211_c().func_77973_b() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.func_75211_c().func_77973_b()).showTooltip(centreSlot.func_75211_c())) {
            this.field_146999_f += 144;
        }
        if (this.arcaneWorkbenchContainer.hasBookshelves()) {
            this.field_146999_f += 122;
            this.field_147003_i -= 122;
        }
        this.applyBtn.field_146124_l = centreSlot.func_75216_d();
        this.clearBtn.field_146124_l = centreSlot.func_75216_d() && centreSlot.func_75211_c().func_77973_b() instanceof IWorkbenchItem && ((IWorkbenchItem)centreSlot.func_75211_c().func_77973_b()).isClearable();
        for (GuiButton button : this.sortButtons) {
            button.field_146125_m = this.arcaneWorkbenchContainer.hasBookshelves();
        }
        this.searchField.func_146189_e(this.arcaneWorkbenchContainer.hasBookshelves());
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        int left = this.arcaneWorkbenchContainer.hasBookshelves() ? this.field_147003_i + 122 : this.field_147003_i;
        int top = this.field_147009_r;
        DrawingUtils.drawTexturedRect(left + 38, top + 22, 320, 0, 100, 100, 512, 512);
        if (this.animationTimer > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int x = left + 38 + 50;
            int y = top + 22 + 50;
            float scale = ((float)this.animationTimer + partialTicks) / 20.0f;
            scale = (float)(1.0 - Math.pow(1.0f - scale, 1.4f));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)x / scale), (float)((float)y / scale), (float)0.0f);
            DrawingUtils.drawTexturedRect(-78, -78, 320, 100, 156, 156, 512, 512);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        DrawingUtils.drawTexturedRect(left, top, 0, 0, 176, this.field_147000_g, 512, 512);
        float opacity = ((float)this.animationTimer + partialTicks) / 20.0f;
        for (int i = 0; i < 8; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot.field_75223_e < 0 || slot.field_75221_f < 0) continue;
            DrawingUtils.drawTexturedRect(this.field_147003_i + slot.field_75223_e - 10, this.field_147009_r + slot.field_75221_f - 10, 0, 220, 36, 36, 512, 512);
            if (this.animationTimer <= 0 || !slot.func_75216_d()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            DrawingUtils.drawTexturedRect(this.field_147003_i + slot.field_75223_e - 10, this.field_147009_r + slot.field_75221_f - 10, 36, 220, 36, 36, 512, 512);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (this.animationTimer > 0) {
            Slot crystals = this.field_147002_h.func_75139_a(8);
            Slot upgrades = this.field_147002_h.func_75139_a(10);
            if (crystals.func_75216_d()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_147003_i + crystals.field_75223_e - 8, this.field_147009_r + crystals.field_75221_f - 8, 420, 0, 32, 32, 512, 512);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            if (upgrades.func_75216_d()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_147003_i + upgrades.field_75223_e - 8, this.field_147009_r + upgrades.field_75221_f - 8, 420, 0, 32, 32, 512, 512);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
        if (this.arcaneWorkbenchContainer.hasBookshelves()) {
            DrawingUtils.drawTexturedRect(left - 122, top, 0, 256, 122, this.field_147000_g, 512, 512);
            DrawingUtils.drawTexturedRect(left - 122 + 102, top + 34 + (int)(this.scroll * 163.0f + 0.5f), this.getMaxScrollRows() > 0 ? 0 : 12, 476, 12, 15, 512, 512);
        }
        if (this.field_147002_h.func_75139_a(9).func_75216_d()) {
            ItemStack stack = this.field_147002_h.func_75139_a(9).func_75211_c();
            if (!(stack.func_77973_b() instanceof IWorkbenchItem)) {
                Wizardry.logger.warn("Invalid item in central slot of arcane workbench, how did that get there?!");
                return;
            }
            if (((IWorkbenchItem)stack.func_77973_b()).showTooltip(stack)) {
                int tooltipHeight = this.tooltipElements.stream().mapToInt(e -> e.getTotalHeight(stack)).sum() - this.tooltipElements.get(this.tooltipElements.size() - 1).spaceAfter;
                DrawingUtils.drawTexturedRect(left + 176, top, 176, 0, 144, 6 + tooltipHeight, 512, 512);
                DrawingUtils.drawTexturedRect(left + 176, top + 6 + tooltipHeight, 176, this.field_147000_g - 6, 144, 6, 512, 512);
                int x = left + 176 + 6;
                int y = top + 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawBackgroundLayer(x, y, stack, partialTicks, mouseX, mouseY);
                }
            }
        }
        this.searchField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.arcaneWorkbenchContainer.hasBookshelves() ? 122 : 0;
        this.field_146289_q.func_78276_b(this.arcaneWorkbenchInventory.func_145818_k_() ? this.arcaneWorkbenchInventory.func_70005_c_() : I18n.func_135052_a((String)this.arcaneWorkbenchInventory.func_70005_c_(), (Object[])new Object[0]), left + 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_70005_c_() : I18n.func_135052_a((String)this.playerInventory.func_70005_c_(), (Object[])new Object[0]), left + 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.arcaneWorkbenchContainer.hasBookshelves()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.bookshelves", (Object[])new Object[0]), 8, 6, 0x404040);
        }
        if (this.field_147002_h.func_75139_a(9).func_75216_d()) {
            ItemStack stack = this.field_147002_h.func_75139_a(9).func_75211_c();
            if (!(stack.func_77973_b() instanceof IWorkbenchItem)) {
                Wizardry.logger.warn("Invalid item in central slot of arcane workbench, how did that get there?!");
                return;
            }
            if (((IWorkbenchItem)stack.func_77973_b()).showTooltip(stack)) {
                int x = left + 176 + 6;
                int y = 6;
                for (TooltipElement element : this.tooltipElements) {
                    y = element.drawForegroundLayer(x, y, stack, mouseX, mouseY);
                }
            }
        }
        this.field_146292_n.forEach(b -> b.func_146111_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r));
        if (this.func_146978_c(this.searchField.field_146209_f, this.searchField.field_146210_g, this.searchField.field_146218_h, this.searchField.field_146219_i, mouseX + this.field_147003_i, mouseY + this.field_147009_r)) {
            if (this.searchBarHoverTime == 0) {
                ++this.searchBarHoverTime;
            } else if (this.searchBarHoverTime == 20) {
                this.func_146279_a(I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.search_tooltip", (Object[])new Object[]{TOOLTIP_SYNTAX.func_150218_j(), TOOLTIP_BODY.func_150218_j()}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        } else {
            this.searchBarHoverTime = 0;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            PacketControlInput.Message msg;
            if (button == this.applyBtn) {
                msg = new PacketControlInput.Message(PacketControlInput.ControlType.APPLY_BUTTON);
                WizardryPacketHandler.net.sendToServer((IMessage)msg);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, (float)1.0f));
                this.animationTimer = 20;
            }
            if (button == this.clearBtn) {
                msg = new PacketControlInput.Message(PacketControlInput.ControlType.CLEAR_BUTTON);
                WizardryPacketHandler.net.sendToServer((IMessage)msg);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, (float)0.8f));
                this.animationTimer = 20;
            }
            if (button instanceof GuiButtonSpellSort) {
                this.arcaneWorkbenchContainer.setSortType(((GuiButtonSpellSort)button).sortType);
            }
        }
    }

    private int getMaxScrollRows() {
        return Math.max(0, MathHelper.func_76123_f((float)((float)this.arcaneWorkbenchContainer.getActiveBookshelfSlots().size() / 5.0f)) - 10);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scrollDist = -Mouse.getEventDWheel();
        if (scrollDist != 0 && this.getMaxScrollRows() > 0) {
            if (scrollDist > 0) {
                this.scroll += 1.0f / (float)this.getMaxScrollRows();
            }
            if (scrollDist < 0) {
                this.scroll -= 1.0f / (float)this.getMaxScrollRows();
            }
            this.scroll = MathHelper.func_76131_a((float)this.scroll, (float)0.0f, (float)1.0f);
            this.arcaneWorkbenchContainer.scrollTo((int)(this.scroll * (float)this.getMaxScrollRows() + 0.5f));
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        this.searchNeedsClearing = true;
        if (slot instanceof SlotBookList && ((SlotBookList)slot).hasDelegate() && this.playerInventory.func_70445_o().func_190926_b()) {
            VirtualSlot virtualSlot = ((SlotBookList)slot).getDelegate();
            super.func_184098_a((Slot)virtualSlot, virtualSlot.field_75222_d, mouseButton, type);
        } else {
            super.func_184098_a(slot, slotId, mouseButton, type);
        }
        this.arcaneWorkbenchContainer.updateActiveBookshelfSlots();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchNeedsClearing) {
            this.searchNeedsClearing = false;
            this.searchField.func_146180_a("");
        }
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.arcaneWorkbenchContainer.setSearchText(this.searchField.func_146179_b().toLowerCase(Locale.ROOT));
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_CRYSTAL);
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_UPGRADE);
    }

    private TooltipElement[] generateSpellEntries(int count) {
        TooltipElement[] entries = new TooltipElement[count];
        for (int i = 0; i < count; ++i) {
            entries[i] = new TooltipElementSpellEntry(i);
        }
        return entries;
    }

    private static class GuiButtonClear
    extends GuiButton {
        public GuiButtonClear(int id, int x, int y) {
            super(id, x, y, 16, 16, I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.clear", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = 72;
            int l = 236;
            if (this.field_146124_l) {
                if (this.field_146123_n) {
                    k += this.field_146120_f * 2;
                }
            } else {
                k += this.field_146120_f;
            }
            DrawingUtils.drawTexturedRect(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g, 512, 512);
        }
    }

    private static class GuiButtonApply
    extends GuiButton {
        public GuiButtonApply(int id, int x, int y) {
            super(id, x, y, 16, 16, I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.apply", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = 72;
            int l = 220;
            if (this.field_146124_l) {
                if (this.field_146123_n) {
                    k += this.field_146120_f * 2;
                }
            } else {
                k += this.field_146120_f;
            }
            DrawingUtils.drawTexturedRect(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g, 512, 512);
        }
    }

    private class TooltipElementUpgrades
    extends TooltipElement {
        private static final int ITEM_SIZE = 16;
        private static final int ITEM_SPACING = 2;

        public TooltipElementUpgrades(int spaceAfter) {
            super(spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return true;
        }

        @Override
        protected int getHeight(ItemStack stack) {
            int rows = 1 + (WandHelper.getTotalUpgrades(stack) * 18 - 2) / 132;
            return rows * 18 - 2;
        }

        @Override
        protected void drawBackground(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179126_j();
            int x1 = 0;
            for (Item item : WandHelper.getSpecialUpgrades()) {
                int level = WandHelper.getUpgradeLevel(stack, item);
                if (level <= 0) continue;
                ItemStack upgrade = new ItemStack(item, level);
                GuiArcaneWorkbench.this.field_146296_j.func_180450_b(upgrade, x + x1, y);
                GuiArcaneWorkbench.this.field_146296_j.func_180453_a(GuiArcaneWorkbench.this.field_146289_q, upgrade, x + x1, y, null);
                if ((x1 += 18) + 16 <= 132) continue;
                x1 = 0;
                y += 18;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179140_f();
        }

        @Override
        protected void drawForeground(int x, int y, ItemStack stack, int mouseX, int mouseY) {
            int x1 = 0;
            for (Item item : WandHelper.getSpecialUpgrades()) {
                int level = WandHelper.getUpgradeLevel(stack, item);
                if (level <= 0) continue;
                if (GuiArcaneWorkbench.this.func_146978_c(x + x1, y, 16, 16, mouseX, mouseY)) {
                    ItemStack upgrade = new ItemStack(item, level);
                    GuiArcaneWorkbench.this.func_146285_a(upgrade, mouseX - GuiArcaneWorkbench.this.field_147003_i, mouseY - GuiArcaneWorkbench.this.field_147009_r);
                }
                if (12 + (x1 += 18) + 16 <= 144) continue;
                x1 = 0;
                y += 18;
            }
        }
    }

    private class TooltipElementUpgradeList
    extends TooltipElementText {
        public TooltipElementUpgradeList(int spaceAfter) {
            super(I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.upgrades", (Object[])new Object[0]), new Style().func_150238_a(TextFormatting.WHITE), spaceAfter, new TooltipElementUpgrades(0));
        }

        @Override
        protected int getHeight(ItemStack stack) {
            return super.getHeight(stack) + 1;
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return WandHelper.getTotalUpgrades(stack) > 0;
        }
    }

    private class TooltipElementSpellEntry
    extends TooltipElementText {
        private final int index;

        public TooltipElementSpellEntry(int index) {
            super(null, new Style().func_150238_a(TextFormatting.BLUE), 1, new TooltipElement[0]);
            this.index = index;
        }

        private Spell getSpell(ItemStack stack) {
            ItemStack spellBook = GuiArcaneWorkbench.this.field_147002_h.func_75139_a(this.index).func_75211_c();
            if (!spellBook.func_190926_b() && spellBook.func_77973_b() instanceof ItemSpellBook) {
                return Spell.byMetadata(spellBook.func_77960_j());
            }
            return ((ISpellCastingItem)stack.func_77973_b()).getSpells(stack)[this.index];
        }

        private boolean shouldFlash(ItemStack stack) {
            ItemStack spellBook = GuiArcaneWorkbench.this.field_147002_h.func_75139_a(this.index).func_75211_c();
            return !spellBook.func_190926_b() && spellBook.func_77973_b() instanceof ItemSpellBook && Spell.byMetadata(spellBook.func_77960_j()) != ((ISpellCastingItem)stack.func_77973_b()).getSpells(stack)[this.index];
        }

        private float getAlpha(float partialTicks) {
            return (MathHelper.func_76126_a((float)(0.2f * ((float)GuiArcaneWorkbench.this.field_146297_k.field_71439_g.field_70173_aa + partialTicks))) + 1.0f) / 4.0f + 0.5f;
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return stack.func_77973_b() instanceof ISpellCastingItem && this.index < ((ISpellCastingItem)stack.func_77973_b()).getSpells(stack).length;
        }

        @Override
        protected FontRenderer getFontRenderer(ItemStack stack) {
            return Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(stack), null) ? super.getFontRenderer(stack) : GuiArcaneWorkbench.this.field_146297_k.field_71464_q;
        }

        @Override
        protected int getColour(ItemStack stack) {
            return this.shouldFlash(stack) ? DrawingUtils.makeTranslucent(0, this.getAlpha(GuiArcaneWorkbench.this.field_146297_k.func_184121_ak())) : super.getColour(stack);
        }

        @Override
        protected String getText(ItemStack stack) {
            Spell spell = this.getSpell(stack);
            if (Wizardry.proxy.shouldDisplayDiscovered(spell, null)) {
                return spell.getDisplayNameWithFormatting();
            }
            return SpellGlyphData.getGlyphName(spell, (World)GuiArcaneWorkbench.this.field_146297_k.field_71441_e);
        }

        @Override
        protected void drawBackground(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
            Spell spell = this.getSpell(stack);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Wizardry.proxy.shouldDisplayDiscovered(spell, null) ? spell.getElement().getIcon() : Element.MAGIC.getIcon());
            if (this.shouldFlash(stack)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha(partialTicks));
            }
            DrawingUtils.drawTexturedRect(x, y, 8, 8);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        protected void drawForeground(int x, int y, ItemStack stack, int mouseX, int mouseY) {
            super.drawForeground(x + 11, y, stack, mouseX, mouseY);
        }
    }

    private class TooltipElementSpellList
    extends TooltipElement {
        public TooltipElementSpellList(int spaceAfter) {
            super(spaceAfter, GuiArcaneWorkbench.this.generateSpellEntries(8));
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return stack.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).showSpellsInWorkbench((EntityPlayer)GuiArcaneWorkbench.this.field_146297_k.field_71439_g, stack);
        }

        @Override
        protected int getHeight(ItemStack stack) {
            return 0;
        }

        @Override
        public int drawBackgroundLayer(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179147_l();
            y = super.drawBackgroundLayer(x, y, stack, partialTicks, mouseX, mouseY);
            GlStateManager.func_179084_k();
            return y;
        }

        @Override
        protected void drawBackground(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        }

        @Override
        protected void drawForeground(int x, int y, ItemStack stack, int mouseX, int mouseY) {
        }
    }

    private class TooltipElementProgressionBar
    extends TooltipElement {
        private static final int PROGRESSION_BAR_WIDTH = 131;
        private static final int PROGRESSION_BAR_HEIGHT = 3;

        public TooltipElementProgressionBar(int spaceAfter) {
            super(spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemWand && !Wizardry.settings.legacyWandLevelling;
        }

        @Override
        protected int getHeight(ItemStack stack) {
            return ((GuiArcaneWorkbench)GuiArcaneWorkbench.this).field_146289_q.field_78288_b + 1 + 3;
        }

        @Override
        protected void drawBackground(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
            y += ((GuiArcaneWorkbench)GuiArcaneWorkbench.this).field_146289_q.field_78288_b + 1;
            Tier tier = ((ItemWand)stack.func_77973_b()).tier;
            float progressFraction = 1.0f;
            if (tier != Tier.MASTER) {
                progressFraction = (float)WandHelper.getProgression(stack) / (float)Tier.values()[tier.level + 1].getProgression();
            }
            DrawingUtils.drawTexturedRect(x, y, 176, GuiArcaneWorkbench.this.field_147000_g + 3, 131, 3, 512, 512);
            int width = (int)(131.0f * progressFraction);
            DrawingUtils.drawTexturedRect(x, y, 176, GuiArcaneWorkbench.this.field_147000_g, width, 3, 512, 512);
        }

        @Override
        protected void drawForeground(int x, int y, ItemStack stack, int mouseX, int mouseY) {
            Tier tier = ((ItemWand)stack.func_77973_b()).tier;
            GuiArcaneWorkbench.this.field_146289_q.func_175063_a(tier.getDisplayNameWithFormatting(), (float)x, (float)y, 0);
            if (tier != Tier.MASTER) {
                Tier nextTier = Tier.values()[tier.level + 1];
                String s = TextFormatting.DARK_GRAY.toString() + nextTier.getDisplayName();
                if (WandHelper.getProgression(stack) >= nextTier.getProgression()) {
                    s = nextTier.getDisplayNameWithFormatting();
                }
                GuiArcaneWorkbench.this.field_146289_q.func_175063_a(s, (float)(x + 144 - 12 - GuiArcaneWorkbench.this.field_146289_q.func_78256_a(s)), (float)y, 0);
            }
        }
    }

    private class TooltipElementManaReadout
    extends TooltipElementText {
        public TooltipElementManaReadout(int spaceAfter) {
            super(null, new Style().func_150238_a(TextFormatting.BLUE), spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected String getText(ItemStack stack) {
            return I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.mana", (Object[])new Object[]{((IManaStoringItem)stack.func_77973_b()).getMana(stack), ((IManaStoringItem)stack.func_77973_b()).getManaCapacity(stack)});
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return stack.func_77973_b() instanceof IManaStoringItem && ((IManaStoringItem)stack.func_77973_b()).showManaInWorkbench((EntityPlayer)GuiArcaneWorkbench.this.field_146297_k.field_71439_g, stack);
        }
    }

    private class TooltipElementItemName
    extends TooltipElementText {
        public TooltipElementItemName(Style style, int spaceAfter) {
            super(null, style, spaceAfter, new TooltipElement[0]);
        }

        @Override
        protected String getText(ItemStack stack) {
            return stack.func_82833_r();
        }
    }

    private class TooltipElementText
    extends TooltipElement {
        private final String text;
        private final Style style;

        public TooltipElementText(String text, Style style, int spaceAfter, TooltipElement ... children) {
            super(spaceAfter, children);
            this.text = text;
            this.style = style;
        }

        protected String getText(ItemStack stack) {
            return this.text;
        }

        protected FontRenderer getFontRenderer(ItemStack stack) {
            return GuiArcaneWorkbench.this.field_146289_q;
        }

        protected int getColour(ItemStack stack) {
            return 0;
        }

        @Override
        protected boolean isVisible(ItemStack stack) {
            return true;
        }

        @Override
        protected int getHeight(ItemStack stack) {
            return this.getFontRenderer(stack).func_78271_c(this.getText(stack), 132).size() * this.getFontRenderer((ItemStack)stack).field_78288_b;
        }

        @Override
        protected void drawBackground(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
        }

        @Override
        protected void drawForeground(int x, int y, ItemStack stack, int mouseX, int mouseY) {
            for (String line : this.getFontRenderer(stack).func_78271_c(this.getText(stack), 132)) {
                this.getFontRenderer(stack).func_175063_a(this.style.func_150218_j() + line, (float)x, (float)y, this.getColour(stack));
                y += this.getFontRenderer((ItemStack)stack).field_78288_b;
            }
        }
    }

    private static abstract class TooltipElement {
        private final TooltipElement[] children;
        private final int spaceAfter;

        public TooltipElement(int spaceAfter, TooltipElement ... children) {
            this.children = children;
            this.spaceAfter = spaceAfter;
        }

        public int getTotalHeight(ItemStack stack) {
            if (!this.isVisible(stack)) {
                return 0;
            }
            int height = this.getHeight(stack);
            for (TooltipElement child : this.children) {
                height += child.getTotalHeight(stack);
            }
            return height + this.spaceAfter;
        }

        public int drawBackgroundLayer(int x, int y, ItemStack stack, float partialTicks, int mouseX, int mouseY) {
            if (!this.isVisible(stack)) {
                return y;
            }
            this.drawBackground(x, y, stack, partialTicks, mouseX, mouseY);
            y += this.getHeight(stack);
            for (TooltipElement child : this.children) {
                y = child.drawBackgroundLayer(x, y, stack, partialTicks, mouseX, mouseY);
            }
            return y + this.spaceAfter;
        }

        public int drawForegroundLayer(int x, int y, ItemStack stack, int mouseX, int mouseY) {
            if (!this.isVisible(stack)) {
                return y;
            }
            this.drawForeground(x, y, stack, mouseX, mouseY);
            y += this.getHeight(stack);
            for (TooltipElement child : this.children) {
                y = child.drawForegroundLayer(x, y, stack, mouseX, mouseY);
            }
            return y + this.spaceAfter;
        }

        protected abstract boolean isVisible(ItemStack var1);

        protected abstract int getHeight(ItemStack var1);

        protected abstract void drawBackground(int var1, int var2, ItemStack var3, float var4, int var5, int var6);

        protected abstract void drawForeground(int var1, int var2, ItemStack var3, int var4, int var5);
    }
}

