/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import com.google.common.collect.ImmutableList;
import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class BlockBookshelf
extends BlockHorizontal
implements ITileEntityProvider {
    public static final double PLAYER_NOTIFY_RANGE = 32.0;
    public static final int SLOT_COUNT = 12;
    public static final UnlistedPropertyInt[] BOOKS = new UnlistedPropertyInt[12];
    private static final Map<Supplier<Item>, ResourceLocation> BOOK_TEXTURE_MAP = new HashMap<Supplier<Item>, ResourceLocation>();
    private static ImmutableList<Item> bookItems;
    private static ImmutableList<ResourceLocation> bookTextures;

    public BlockBookshelf() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(WizardryTabs.WIZARDRY);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{field_185512_D}).add((IUnlistedProperty[])BOOKS).build();
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == face.func_176740_k() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState block) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityBookshelf) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityBookshelf)tileentity));
        }
        super.func_180663_b(world, pos, block);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState s = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (world.func_175625_s(pos) instanceof TileEntityBookshelf) {
            TileEntityBookshelf tileentity = (TileEntityBookshelf)world.func_175625_s(pos);
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                if (tileentity.func_70301_a(i).func_190926_b()) {
                    s = s.withProperty((IUnlistedProperty)BOOKS[i], (Object)bookItems.size());
                    continue;
                }
                Item item = tileentity.func_70301_a(i).func_77973_b();
                s = s.withProperty((IUnlistedProperty)BOOKS[i], (Object)(bookItems.contains((Object)item) ? bookItems.indexOf((Object)item) : 0));
            }
        }
        return s;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBookshelf();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState block, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)Wizardry.instance, WizardryGuiHandler.BOOKSHELF, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBookshelf) {
            int slotsOccupied = 0;
            for (int i = 0; i < ((TileEntityBookshelf)tileEntity).func_70302_i_(); ++i) {
                if (((TileEntityBookshelf)tileEntity).func_70301_a(i).func_190926_b()) continue;
                ++slotsOccupied;
            }
            return slotsOccupied;
        }
        return super.func_180641_l(state, world, pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public static ImmutableList<ResourceLocation> getBookTextures() {
        return bookTextures == null ? ImmutableList.copyOf(BOOK_TEXTURE_MAP.values()) : bookTextures;
    }

    public static ImmutableList<Item> getBookItems() {
        return bookItems;
    }

    public static void initBookProperties() {
        for (int i = 0; i < 12; ++i) {
            BlockBookshelf.BOOKS[i] = new UnlistedPropertyInt("book" + i);
        }
    }

    public static void compileBookModelTextures() {
        ImmutableList.Builder itemListBuider = ImmutableList.builder();
        ImmutableList.Builder textureListBuilder = ImmutableList.builder();
        for (Map.Entry<Supplier<Item>, ResourceLocation> entry : BOOK_TEXTURE_MAP.entrySet()) {
            itemListBuider.add((Object)entry.getKey().get());
            textureListBuilder.add((Object)entry.getValue());
        }
        bookItems = itemListBuider.build();
        bookTextures = textureListBuilder.build();
    }

    public static void registerStandardBookModelTextures() {
        BlockBookshelf.registerBookModelTexture(() -> Items.field_151122_aG, new ResourceLocation("ebwizardry", "blocks/books_brown"));
        BlockBookshelf.registerBookModelTexture(() -> Items.field_151099_bA, new ResourceLocation("ebwizardry", "blocks/books_brown"));
        BlockBookshelf.registerBookModelTexture(() -> Items.field_151164_bB, new ResourceLocation("ebwizardry", "blocks/books_brown"));
        BlockBookshelf.registerBookModelTexture(() -> Items.field_151134_bR, new ResourceLocation("ebwizardry", "blocks/books_enchanted"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.spell_book, new ResourceLocation("ebwizardry", "blocks/books_red"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.wizard_handbook, new ResourceLocation("ebwizardry", "blocks/books_blue"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.arcane_tome, new ResourceLocation("ebwizardry", "blocks/books_purple"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.ruined_spell_book, new ResourceLocation("ebwizardry", "blocks/books_brown"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.scroll, new ResourceLocation("ebwizardry", "blocks/scrolls_blue"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.blank_scroll, new ResourceLocation("ebwizardry", "blocks/scrolls_blue"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.identification_scroll, new ResourceLocation("ebwizardry", "blocks/scrolls_purple"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.storage_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.siphon_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.condenser_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.range_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.duration_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.cooldown_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.blast_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.attunement_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
        BlockBookshelf.registerBookModelTexture(() -> WizardryItems.melee_upgrade, new ResourceLocation("ebwizardry", "blocks/scrolls_wooden"));
    }

    public static void registerBookModelTexture(Supplier<Item> itemFactory, ResourceLocation texture) {
        BOOK_TEXTURE_MAP.put(itemFactory, texture);
    }

    public static List<IInventory> findNearbyBookshelves(World world, BlockPos centre, TileEntity ... exclude) {
        ArrayList<IInventory> bookshelves = new ArrayList<IInventory>();
        int searchRadius = Wizardry.settings.bookshelfSearchRadius;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    TileEntity te;
                    BlockPos pos = centre.func_177982_a(x, y, z);
                    if (!Settings.containsMetaBlock(Wizardry.settings.bookshelfBlocks, world.func_180495_p(pos)) || !((te = world.func_175625_s(pos)) instanceof IInventory) || ArrayUtils.contains((Object[])exclude, (Object)te)) continue;
                    bookshelves.add((IInventory)te);
                }
            }
        }
        return bookshelves;
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)Listener.instance);
    }

    @SubscribeEvent
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        event.getWorld().func_72848_b((IWorldEventListener)Listener.instance);
    }

    public static class Listener
    implements IWorldEventListener {
        public static final Listener instance = new Listener();

        private Listener() {
        }

        public void func_184376_a(World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
            if (oldState == newState) {
                return;
            }
            if (Settings.containsMetaBlock(Wizardry.settings.bookshelfBlocks, oldState) || Settings.containsMetaBlock(Wizardry.settings.bookshelfBlocks, newState)) {
                Wizardry.proxy.notifyBookshelfChange(world, pos);
            }
        }

        public void func_174959_b(BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_72703_a(Entity entityIn) {
        }

        public void func_72709_b(Entity entityIn) {
        }

        public void func_180440_a(int soundID, BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        }
    }

    private static final class UnlistedPropertyInt
    extends Properties.PropertyAdapter<Integer> {
        public UnlistedPropertyInt(String name) {
            super((IProperty)PropertyInteger.func_177719_a((String)name, (int)0, (int)BOOK_TEXTURE_MAP.size()));
        }
    }
}

